function [r_t,r_ind] = rpeakDetection(data,fs,opt)
%RPEAKDETECTION  function [r_t,r_ind] = rpeakDetection(data,fs,opt)
% *************************************************************************
% fprintf(1,'-> Detecting R peaks in the signal... ');


% opt can be used for removing detected T-waves (opt=0 default)
if nargin<3,
    opt = 0;
end
% thresh = 0.2;


%%%%%%%%%%% check format of data %%%%%%%%%%
[a,b] = size(data);
len = max(a,b);


%%%%%%%%%% if there's no time axis - make one
if a==1 || b==1,
    % make time axis
    tt = 1/fs:1/fs:ceil(len/fs);
    t = tt(1:len);
    y = data;
end

%%%%%%%%%% check if data is in columns or rows
if a==2,
    y = data(:,1);
    t = data(:,2);
end
if b==2,
    t = data(:,1);
    y = data(:,2);
end


%%%%%%%%% bandpass filter data - assume 256hz data %%%%%
% remove mean
y = y-nanmean(y);
bpf = y;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%% differentiate data %%%%%%%%%%%%%%%%%%%%%%%%%%%
dff = [0; diff(bpf)];       % now it's one datum shorter than before

%%%%%%%%%%%%%
sqr = dff.*dff;

%%%%%%%%% integrate data over window 'd' %%%%%%%%%%%%%%%%%%%%%%%%%
d = [1 1 1 1 1 1 1];        % window size - initalise
if fs>=256,                 % adapt it for sampling rates higher than 256 Hz
    d = ones(1,round(7*fs/256));
end

% integrate data
mdfint = medfilt1(filter(d,1,sqr),10);

% remove filter delay for scanning back through ECG
delay = ceil(length(d)/2);
mdfint = mdfint(delay:length(mdfint));
z = zeros(delay-1,1);
mdfint = [mdfint; z];

% apply adaptive thresholds
interval = 0.1*fs;
[r_t,r_ind] = adaptiveThreshold(mdfint,bpf,t,interval);

if opt==1,
    % check if a found beat is R peak or not (by checking the width of peak)
    peakwidth = round(0.1*fs);
    itmp = []; % tmp = [];
    for i=1:numel(r_ind),
        int_start = max(r_ind(i)-peakwidth,1);
        int_end = min(r_ind(i)+peakwidth,length(bpf));
        if mean(bpf(int_start:int_end))>0.3*bpf(r_ind(i)),
            itmp = [itmp i];
        end
    end
    
    % mark the beats for deleting
    % r_ind_del = [r_ind_del(:); r_ind(itmp)];
    
    % eliminate those peaks
    r_ind(itmp) = [];
    r_t(itmp) = [];
    % r_amp(itmp) = [];

    % fprintf(1,'-> number of deleted beats is %d out of %d. \n',numel(itmp),numel(r_ind));
end

% fprintf(1,'DONE!\n');
