function [filtdata]  = filterECG128Hz(data)
% [filtdata]  = filterECG128Hz(data);
% apply a zerophase FIR filter (coeffs designed with sptool)
% Least Sq. FIR LP & HP filters (cascaded): 70dB 0.05-40Hz 1dB ripple. 
% Sampling Frequency of Fs = 128.
%
% Should work nicely for 16bit, 256Hz ECG. You may experince 
% some ringing at turning points, but that's FIR filters for you.  
% You might like to try wavelets for a better filter 
%
% These routines are made available under the GNU general public license. 
% If you have not received a copy of this license, please download from 
% http://www.gnu.org/
%
% Please distribute (and modify) freely, commenting where you have 
% added modifications. The author would appreciate correspondence 
% regarding corrections, modifications, improvements etc.
%
% G. Clifford : gari@ieee.org


% Data should be zero-meaned before calling this function
data = data-mean(data);

% set up transfer function
denominator = 1;
numerator_lp = [
    -7.836313016322635e-03
    -1.896972756320189e-02
    -5.175330833579545e-03
     1.828346656167859e-02
    -6.018872954550802e-04
    -1.897562067220059e-02
     2.024098477556695e-02
     2.007552016297064e-02
    -4.029205517855476e-02
     3.980639054552623e-03
     7.022378021831376e-02
    -5.937364415063083e-02
    -8.822946558472169e-02
     3.032906360635707e-01
     5.996608499295303e-01
     3.032906360635707e-01
    -8.822946558472169e-02
    -5.937364415063083e-02
     7.022378021831376e-02
     3.980639054552623e-03
    -4.029205517855476e-02
     2.007552016297064e-02
     2.024098477556695e-02
    -1.897562067220059e-02
    -6.018872954550802e-04
     1.828346656167859e-02
    -5.175330833579545e-03
    -1.896972756320189e-02
    -7.836313016322635e-03
];


numerator_hp = [ 
    -5.272437301928293e-04
    -1.270087347478445e-04
    -1.421348135287156e-04
    -1.582961734171513e-04
    -1.755764587237310e-04
    -1.939486402411108e-04
    -2.135296230579367e-04
    -2.342715794110092e-04
    -2.563093703085422e-04
    -2.796160181433441e-04
    -3.043014698229107e-04
    -3.303453248658040e-04
    -3.578455028268245e-04
    -3.867214105939904e-04
    -4.170888923036170e-04
    -4.488811733969728e-04
    -4.822063006316578e-04
    -5.170197946280047e-04
    -5.535253395139226e-04
    -5.916625148888152e-04
    -6.316044529097936e-04
    -6.732081327790902e-04
    -7.165788660268917e-04
    -7.614673946729495e-04
    -8.081236729920874e-04
    -8.564379420809926e-04
    -9.069404054062480e-04
    -9.592891108521169e-04
    -1.013520022388740e-03
    -1.068455050967581e-03
    -1.126689269663744e-03
    -1.186204883152881e-03
    -1.247380114262856e-03
    -1.310856912732174e-03
    -1.375900461340159e-03
    -1.443041461735466e-03
    -1.511885029416557e-03
    -1.582738786552247e-03
    -1.655320583005337e-03
    -1.729893353369970e-03
    -1.806203460527855e-03
    -1.884446397624664e-03
    -1.964430802275773e-03
    -2.046262955654651e-03
    -2.129750428836313e-03
    -2.215037813560021e-03
    -2.301981811742379e-03
    -2.390672229028491e-03
    -2.480975908659032e-03
    -2.572931105092679e-03
    -2.666360748382136e-03
    -2.761304979221734e-03
    -2.857698150519032e-03
    -2.955598535068774e-03
    -3.054901001596308e-03
    -3.155478224722803e-03
    -3.257211616317062e-03
    -3.360192620167190e-03
    -3.464496103258388e-03
    -3.569633821553856e-03
    -3.675798007866096e-03
    -3.783106411027402e-03
    -3.891012640258272e-03
    -3.999917962979201e-03
    -4.109378741483071e-03
    -4.219573587392301e-03
    -4.330206242883826e-03
    -4.441415505603127e-03
    -4.552895068871517e-03
    -4.664787674933710e-03
    -4.776796783833356e-03
    -4.888968546054471e-03
    -5.001078813544399e-03
    -5.113207893538720e-03
    -5.225099919404130e-03
    -5.336816346211259e-03
    -5.448125259639512e-03
    -5.559029938118835e-03
    -5.669293181689946e-03
    -5.778976225031504e-03
    -5.887879122882245e-03
    -5.996012432011148e-03
    -6.103126173593918e-03
    -6.209214132300607e-03
    -6.314120595416707e-03
    -6.417882343141420e-03
    -6.520214636498100e-03
    -6.621088290402421e-03
    -6.720450076732404e-03
    -6.818237948419261e-03
    -6.914128204056832e-03
    -7.008372785989206e-03
    -7.100533958060398e-03
    -7.190766902504709e-03
    -7.278807347187491e-03
    -7.364733068710562e-03
    -7.448280274431376e-03
    -7.529573080376522e-03
    -7.608284813103398e-03
    -7.684521116446521e-03
    -7.758085897312433e-03
    -7.829019629435470e-03
    -7.897106543328992e-03
    -7.962444021838374e-03
    -8.024797816710869e-03
    -8.084212682808753e-03
    -8.140518300829559e-03
    -8.193808564001160e-03
    -8.243881936890022e-03
    -8.290796858484446e-03
    -8.334367833865763e-03
    -8.374699271329103e-03
    -8.411637628938252e-03
    -8.445234427388959e-03
    -8.475297677477069e-03
    -8.501979217581199e-03
    -8.525132171625144e-03
    -8.544799261897136e-03
    -8.560853979448457e-03
    -8.573474502979061e-03
    -8.582371323167616e-03
    -8.587790488764461e-03
     9.914104520892446e-01
    -8.587790488764461e-03
    -8.582371323167616e-03
    -8.573474502979061e-03
    -8.560853979448457e-03
    -8.544799261897136e-03
    -8.525132171625144e-03
    -8.501979217581199e-03
    -8.475297677477069e-03
    -8.445234427388959e-03
    -8.411637628938252e-03
    -8.374699271329103e-03
    -8.334367833865763e-03
    -8.290796858484446e-03
    -8.243881936890022e-03
    -8.193808564001160e-03
    -8.140518300829559e-03
    -8.084212682808753e-03
    -8.024797816710869e-03
    -7.962444021838374e-03
    -7.897106543328992e-03
    -7.829019629435470e-03
    -7.758085897312433e-03
    -7.684521116446521e-03
    -7.608284813103398e-03
    -7.529573080376522e-03
    -7.448280274431376e-03
    -7.364733068710562e-03
    -7.278807347187491e-03
    -7.190766902504709e-03
    -7.100533958060398e-03
    -7.008372785989206e-03
    -6.914128204056832e-03
    -6.818237948419261e-03
    -6.720450076732404e-03
    -6.621088290402421e-03
    -6.520214636498100e-03
    -6.417882343141420e-03
    -6.314120595416707e-03
    -6.209214132300607e-03
    -6.103126173593918e-03
    -5.996012432011148e-03
    -5.887879122882245e-03
    -5.778976225031504e-03
    -5.669293181689946e-03
    -5.559029938118835e-03
    -5.448125259639512e-03
    -5.336816346211259e-03
    -5.225099919404130e-03
    -5.113207893538720e-03
    -5.001078813544399e-03
    -4.888968546054471e-03
    -4.776796783833356e-03
    -4.664787674933710e-03
    -4.552895068871517e-03
    -4.441415505603127e-03
    -4.330206242883826e-03
    -4.219573587392301e-03
    -4.109378741483071e-03
    -3.999917962979201e-03
    -3.891012640258272e-03
    -3.783106411027402e-03
    -3.675798007866096e-03
    -3.569633821553856e-03
    -3.464496103258388e-03
    -3.360192620167190e-03
    -3.257211616317062e-03
    -3.155478224722803e-03
    -3.054901001596308e-03
    -2.955598535068774e-03
    -2.857698150519032e-03
    -2.761304979221734e-03
    -2.666360748382136e-03
    -2.572931105092679e-03
    -2.480975908659032e-03
    -2.390672229028491e-03
    -2.301981811742379e-03
    -2.215037813560021e-03
    -2.129750428836313e-03
    -2.046262955654651e-03
    -1.964430802275773e-03
    -1.884446397624664e-03
    -1.806203460527855e-03
    -1.729893353369970e-03
    -1.655320583005337e-03
    -1.582738786552247e-03
    -1.511885029416557e-03
    -1.443041461735466e-03
    -1.375900461340159e-03
    -1.310856912732174e-03
    -1.247380114262856e-03
    -1.186204883152881e-03
    -1.126689269663744e-03
    -1.068455050967581e-03
    -1.013520022388740e-03
    -9.592891108521169e-04
    -9.069404054062480e-04
    -8.564379420809926e-04
    -8.081236729920874e-04
    -7.614673946729495e-04
    -7.165788660268917e-04
    -6.732081327790902e-04
    -6.316044529097936e-04
    -5.916625148888152e-04
    -5.535253395139226e-04
    -5.170197946280047e-04
    -4.822063006316578e-04
    -4.488811733969728e-04
    -4.170888923036170e-04
    -3.867214105939904e-04
    -3.578455028268245e-04
    -3.303453248658040e-04
    -3.043014698229107e-04
    -2.796160181433441e-04
    -2.563093703085422e-04
    -2.342715794110092e-04
    -2.135296230579367e-04
    -1.939486402411108e-04
    -1.755764587237310e-04
    -1.582961734171513e-04
    -1.421348135287156e-04
    -1.270087347478445e-04
    -5.272437301928293e-04
];

% low pass filter
aff_lp = filtfilt(numerator_lp,denominator,data);

% Don't high pass filter it if you don't want to remove the baseline 
% fluctuations due to resp, BP? and electrode noise?
filtdata = filtfilt(numerator_hp,denominator,aff_lp);
