function [r_t,r_ind] = adaptiveThreshold(mdfint,bpf,t,interval)
% function [rr,r_t,r_amp,r_ind] = adaptiveThreshold(mdfint,bpf,t,interval)
% this function defines the R peaks in the ECG and determine the RR intervals 
% using an adaptive thresholding technique. The technique implemented is 
% the one shown in the Pan-Tompkins method.

thri1 = sqrt(max(mdfint));  % set initial level for THRESHOLD I1
thri2 = thri1/2;            % set initial level for THRESHOLD I2
spki = 0;                   % set SPKI (peak level corresponding to a QRS complex) to 0
npki = 0.061;               % set NPKI (peak level corresponding to noise) to 0
r_t = [];                   % timings of the R peaks in the ECG signal
r_ind = [];                 % locations of the R peaks in the ECG signal
rr = [];                    % time differences between consecutive R peaks
r_amp_prev = [];
r_amp = [];                 % amplitude of the R peaks detected
RD = 0;

%%% Need to find the points of the curve where it changes direction   %%%
dff = diff(mdfint);
dff = [0 dff'];             % adding a '0' to compensate for the differentiation

f = dff<0;
pos = diff(f);
pl = find(pos==1);          % pl contains numbers representing the position on the curve where it changes direction
                            % (from a positive to a negative value)
f = dff>0;
pos = diff(f);
pr = find(pos==1);          % pr contains numbers representing the position on the curve where it changes direction
                            % (from a negative to a positive value)


%%% the following loop detects the points in the signal where there is
%%% a change in direction and then keeps only those that refer to peaks
n = 2;                      % counter for the loop
while n~=length(pl),
    
    for n=n:length(pl),
        if n==length(pl),
            break
        end
        a = t(pl(n-1));
        b = t(pl(n));
        s1 = t(pr)>a;
        s2 = t(pr)<b;
        
        s = s1-s2;
        s = find(s==0,1);
        
        if isempty(s),
            pl(n) = [];
            break
        end
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%   At this point the adaptive thresholding technique is implemented with the following loop   %%%
c = 1;                % counting variable for the loop
d = 0;                % counting variable for the loop

%%% This first part of the loop will analyse the first 8 R peaks %%%
for l=1:length(pl),
    if length(r_amp_prev)~=length(r_amp),
        if mdfint(pl(l))>mdfint(pl(l-1))/2,
            tim = t(pl(l))-t(pl(l-1));
            if tim<=0.2,
                r_amp_prev = r_amp;
                continue
            end
        end
    end
    if length(rr)>=8,
        if rr(end)<(1.66*RR_ave2),
            if mdfint(pl(l))>=thri1,
                spki = (0.125*mdfint(pl(l)))+(0.875*spki);
                int_start = max(pl(l)-round(interval/2),1);
                int_end = min(pl(l)+round(interval/2),length(bpf));
                [val loc] = max(bpf(int_start:int_end));
                loc = loc+int_start-1;
                r_ind = [r_ind loc];
                r_t = t(r_ind);
                r_amp_prev = r_amp;
                r_amp = [r_amp val];
                rr = diff(r_t);
            elseif mdfint(pl(l))<thri1,
                npki_prev = npki;
                npki = (0.125*mdfint(pl(l)))+(0.875*npki);
                r_amp_prev = r_amp;
            end
            thri1 = npki+(0.25*(spki-npki));
            thri2 = thri1/2;
        elseif rr(end)>=(1.66*RR_ave2),
            k = find(pl>r_ind(end-1)+round(interval/2));
            k = [k find(pl<r_ind(end))];
            k = sort(k);
            z = [];
            for q=1:(length(k)-1),
                if k(q)==k(q+1),
                    z = [z k(q)];
                end
            end
            [max_l lok] = max(mdfint(pl(z)));
            if max_l>thri2,
                spki = (0.125*max_l)+(0.875*spki);
                int_start = max(pl(z(lok))-round(interval/2),1);
                int_end = min(pl(z(lok))+round(interval/2),length(bpf));
                [val loc] = max(bpf(int_start:int_end));
                loc = loc+int_start-1;
                r_ind = [r_ind loc];
                r_ind = sort(r_ind);
                r_t = t(r_ind);
                r_amp = [r_amp(1:end-1) val r_amp(end)];
                rr = diff(r_t);
                if spki==npki,
                    npki = npki_prev;
                end
            end
            if mdfint(pl(l))>=thri1,
                spki = (0.125*mdfint(pl(l)))+(0.875*spki);
                int_start = max(pl(l)-round(interval/2),1);
                int_end = min(pl(l)+round(interval/2),length(bpf));
                [val loc] = max(bpf(int_start:int_end));
                loc = loc+int_start-1;
                r_ind = [r_ind loc];
                r_t = t(r_ind);
                r_amp_prev = r_amp;
                r_amp = [r_amp val];
                rr = diff(r_t);
            elseif mdfint(pl(l))<thri1,
                npki_prev = npki;
                npki = (0.125*mdfint(pl(l)))+(0.875*npki);
                r_amp_prev = r_amp;
            end
            thri1 = npki+(0.25*(spki-npki));
            thri2 = thri1/2;
        end
        RR_ave1 = sum(rr(end-7:end))/8;
        while c~=9,
            if rr(end-d)>=RR_low && rr(end-d)<=RR_high,
                RD(c) = rr(end-d);
                c = c+1;
                d = d+1;
            else
                d = d+1;
            end
            if d==length(rr),
                c = 9;
            end
        end
        RR_ave2 = mean(RD);
        RR_low = 0.92*RR_ave2;
        RR_high = 1.16*RR_ave2;
        c = 1;
        d = 0;
    end
    if length(rr)<8,
        if mdfint(pl(l))>=thri1,
            spki = (0.125*mdfint(pl(l)))+(0.875*spki);
            int_start = max(pl(l)-round(interval/2),1);
            int_end = min(pl(l)+round(interval/2),length(bpf));
            [val loc] = max(bpf(int_start:int_end));
            loc = loc+int_start-1;
            r_ind = [r_ind loc];
            r_t = t(r_ind);
            r_amp_prev = r_amp;
            r_amp = [r_amp val];
            rr = diff(r_t);
        elseif mdfint(pl(l))<thri1,
            npki = (0.125*mdfint(pl(l)))+(0.875*npki);
            r_amp_prev = r_amp;
        end
        thri1 = npki+(0.25*(spki-npki));
        thri2 = thri1/2;
        
        RR_ave1 = mean(rr);
        RR_ave2 = RR_ave1;
        RR_low  = 0.92*RR_ave2;
        RR_high = 1.16*RR_ave2;
        Rr_temp = rr;
        for p = 1:length(Rr_temp),
            [value location] = max(Rr_temp);
            if value>RR_high,
                Rr_temp(location) = [];
                RR_ave2 = mean(Rr_temp);
                RR_low = 0.92*RR_ave2;
                RR_high = 1.16*RR_ave2;
            end
        end
        Rr_temp = rr;
        for p=1:length(Rr_temp),
            [value location] = min(Rr_temp);
            if value<RR_low,
                Rr_temp = rr;
                Rr_temp(location) = [];
                RR_ave2 = mean(Rr_temp);
                RR_low = 0.92*RR_ave2;
                RR_high = 1.16*RR_ave2;
            end
        end
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%