
%% wqrs 
function [ONSET ,Ronset, PERIOD] = wqrs(Araw,Offset, Scale, Fs)
% r = wecg(Araw,Offset,Scale, Fs);
% Input: Araw (125Hz sampled) waveform in wfdb-MIT format, 
%        Offset, Scale
% Output: The onset times of the input ECG waveform
% Defaults are Offset = 1600; Scale=20; Fs=125; 
% If you pass 0 as the scale then above defaults are invoked
% Default Fs=125Hz unless you pass a fourth argument.
%
% Gnu Public License Applies
% 
% James Sun Feb 09 2005 with some changes from Gari Clifford
% based upon wabp.c by Wei Zong (www.physionet.org)
% Last Modified: Zhiqiang Sheng March 19, 2015

%% if the signal is not at 125Hz, then resample it.
if nargin<4
Fs=125;
end

% if the sample frequency is not 125, resample to 125
if Fs~=125
    Q=round(Fs);
    P=round(125);
    Araw = resample(Araw, P, Q);
end
Araw = (Araw+Offset)/Scale;
Araw = Araw( find(~ isnan(Araw)));

if isempty(Araw)
    ONSET =  zeros(10000,1);
    Ronset =  zeros(10000,1);
    PERIOD =  zeros(10000,1);
else
    %% The wavelet analysis
    %% ---The wavelet analysis in addition to the noise---
 
    [c,l]=wavedec(Araw,8,'coif4');   % ѡȡsym8Сź8ֽ

    cA8=appcoef(c,l,'coif4',8);
    cD8=detcoef(c,l,8);
    cD7=detcoef(c,l,7);
    cD6=detcoef(c,l,6);
    cD5=detcoef(c,l,5);
    cD4=detcoef(c,l,4);
    cD3=detcoef(c,l,3);
    cD2=detcoef(c,l,2);
    cD1=detcoef(c,l,1);
    % cA8cD1cD2cD3ˣ㣩
    cA8(:,1)=0;
    cD1(:,1)=0;
    cD2(:,1)=0;
    cD3(:,1)=0;
    re_c=[cA8;cD8;cD7;cD6;cD5;cD4;cD3;cD2;cD1];
    S2=waverec(re_c,l,'coif4'); %ع
    
    %% QRS complex detection
    %% -------- QRSȺ -------------------------------------
    
    Araw=S2;
    Araw = Araw( find(~ isnan(Araw)));
    Araw = Araw( find(Araw));

    if isempty(Araw)
        
        ONSET = zeros(10000,1);
        Ronset = zeros(10000,1);
        PERIOD = zeros(10000,1);

    else
        datasize=size(Araw,1);
        slope=zeros(datasize-1,1); % б
        
        for k=1:datasize-1
            slope(k)=Araw(k+1)-Araw(k);
        end;
        abslope=abs(slope);
        
        
        [IDX,cluster_center]=kmeans(abslope,2,'start','uniform','emptyaction','drop');  % K-means'
        
        IDX=IDX-1;
        bound=0;
        if sum(IDX)<size(IDX,1)/2
            bound=1;
        end;

        flag=[];
        siz=size(IDX,1)-1;
        i=1;
        a=0; % ¼ġ0bound==0
        b=0; % ¼ġ1bound==0
        for k=2:siz-1
            if IDX(k)==bound
                if IDX(k-1)==1-bound && IDX(k+1)==bound
                    flag(i,1)=1;
                    flag(i,2)=k;
                    if i>2
                        flag(i-1,3)=b;
                        b=0;
                        flag(i-2,3)=a;
                        a=0;
                    end;
                    i=i+1;
                else
                    if IDX(k-1)==bound && IDX(k+1)==1-bound
                        flag(i,1)=-1;
                        flag(i,2)=k;
                        i=i+1;
                    end;
                end;
                a=a+1;
            end;
            if i>2 && IDX(k)==1-bound
                b=b+1;
            end;
        end;
                
        % IDX2=zeros(size(IDX,1),1);
        % f=flag(1,1);
        loc=flag(1,2);
        R_border=[];
        for k=1:size(flag,1)
            %   if(flag(k,2)-loc>sfreq/3)
            if((flag(k,2)-loc) > Fs / 3)
                R_border(end+1)=loc;
                R_border(end+1)=flag(k-1,2);
                loc=flag(k,2);
            end;
        end;
        R_border(end+1)=loc;
        R_border(end+1)=flag(k,2);
        IDX2=zeros(size(IDX,1),1);
        for k=1:size(R_border,2)
            IDX2(R_border(k))=1;
        end;
        
        QRS_complex=[];
        k=1;
        while k<size(R_border,2)
            QRS_complex(end+1)=R_border(k+1)-R_border(k);
            k=k+2;
        end;
        
        %% ---QRS_borderֵΪR-------
        QRS_R=[];
        k=1;i=1;
        while k<size(R_border,2)
            [QRS_R(i,1),QRS_R(i,2)]=max(Araw(R_border(k):R_border(k+1)));
            QRS_R(i,2)=QRS_R(i,2)+R_border(k)-1;
            k=k+2;
            i=i+1;
        end;

        
        %% -----------QS-------------------
        %% ===========QS===================
        Qwave=[];
        Swave=[];
        n=size(R_border,2);
        k=1;
        while k<n
            i=R_border(k);
            j=R_border(k+1);
            while slope(i)>0 || slope(i)==0     % find first trough
                i=i-1;
                if i == 0
                    break;
                end
            end;
            Qwave(end+1)=i+1;
            while slope(j)<0 || slope(j)==0
                j=j+1;
                if j>size(slope,1)
                    break;
                end;
            end;
            Swave(end+1)=j;
            k=k+2;
        end;
        
        QRSborder=[];
        n=size(Qwave,2);
        k=1;
        while k<n+1
            i=Qwave(k)-1;
            j=Swave(k);
            while i>0 && slope(i)<0 % find first trough
                i=i-1;
            end;
            QRSborder(end+1)=i+1;
            while j<size(slope,1) && slope(j)>0
                j=j+1;
            end;
            QRSborder(end+1)=j;
            k=k+1;
        end;
        
        
        %% OUTPUT
        period = diff(QRSborder);
        ONSET = Qwave';
        Ronset = QRS_R(:,2);
        PERIOD = (period(1:2:end))';
    end
end
end
