%% ECGSQI rules
%% ECGSQI

%%
function [bsqi , isqi , ksqi , ssqi] = ecgSQI(ecg_II ,ann_lt_II ...
                ,ann_km_II ,ann_km_V , period , Ronset_km_II ,Ronset_lt_II ,Ronset_lt_V)
% function [bsqi , isqi , ksqi , ssqi] = ecgSQI(ecg_II ,ann_lt_II ...
%                 ,ann_km_II ,ann_lt_V , period)            
%         bsqi = bSQI(ann_lt_II , ann_km_II);
%         isqi = iSQI(ann_km_II , ann_km_V );
        bsqi = bSQI(Ronset_lt_II , Ronset_km_II);
        isqi = iSQI(Ronset_lt_II , Ronset_lt_V );
%       isqi = iSQI(ann_lt_II , ann_lt_V );
        ksqi = kSQI(ecg_II , ann_lt_II); 
        ssqi = sSQI(ecg_II , ann_lt_II ,period);
end
%% ------------------- Help Function -----------------------
%% bSQI
%% KM & LT  II or V
function r = bSQI(lt_onset , km_onset)
% bSQI = Nmatched(k,w) / Nall(k,w); Nall(k,w) = Nkm + Nlt - Nmatched;

if isempty(lt_onset) || isempty(km_onset)
        r = zeros(10000,1);
else
        Length = min( length(lt_onset) , length(km_onset) );
        bSQI   = ones(1,Length);
       
        index_on  = 1;
        index_off = Length;
        End = min(km_onset(end),lt_onset(end));
        if Length < 10
            
            Nmatched = anastomose(lt_onset,km_onset,4);
            Nall = length(lt_onset) + length(km_onset) - Nmatched;
            bSQI = Nmatched / Nall; 
        else
    
                while ( km_onset(index_on) <= 625 ) && (index_on < Length)
                    index_on = index_on + 1;
                end
    
                while ( km_onset(index_off) >= (End - 625) ) && (index_off > 1)
                    index_off = index_off - 1;
                end
    
            for i = index_on : index_off
        
                i_on  = i - 1;
                i_off = i + 1;
        
                if i_on == 0
                    i_on = 1;
                end
        
                while (km_onset(i) - km_onset(i_on) < 625)  && (i_on > 1)
                    i_on = i_on - 1;
                end
        
                while (km_onset(i_off) - km_onset(i) < 625 ) && (i_off < Length)
                    i_off = i_off + 1;
                end
 
                if  i_off >= Length 
                    i_off = Length;
                end
        
                a = lt_onset(i_on:i_off);
                b = km_onset(i_on:i_off);
                Nmatched = anastomose(a,b,4);
                Nall = length(a) + length(b) - Nmatched;
                bSQI(i-index_on+1) = Nmatched / Nall; 
            end
    
        end
        r = bSQI';
end 
end

%% iSQI
%% KM II and V
function r = iSQI(onsetII , onsetV)
% iSQI = max ( Nmatched(k,w) / Nall(k,w) ); Nall(k,w) = Nkm + Nlt - Nmatched;

if isempty(onsetV) || isempty(onsetII)
    r = zeros(10000,1);
else
    Length = min( length(onsetII) , length(onsetV) );
    iSQI = ones(1,Length);
    if Length < 10
        
        Nmatched = anastomose(onsetII,onsetV,4);
        Nall = length(onsetII) + length(onsetV) - Nmatched;
        iSQI = Nmatched / Nall;
    else

        index_on  = 1;
        index_off = Length;
        End = min(onsetII(end) , onsetV(end));
        
        while (onsetII(index_on) <= 625) && (index_on < Length)
            index_on = index_on + 1;
        end
        
        while (onsetII(index_off) >= (End - 625)) && (index_off > 1)
            index_off = index_off - 1;
        end
        
        for i = index_on : index_off
            
            i_on  = i - 1;
            i_off = i + 1;
            
            if i_on == 0
                i_on = 1;
            end
            
            while (onsetII(i) - onsetII(i_on) <= 625) && (i_on > 1)
                i_on = i_on - 1;
            end
            
            while (onsetII(i_off) - onsetII(i) < 625 ) && (i_off < Length)
                i_off = i_off + 1;
            end
            
            if  i_off >= Length
                i_off = Length;
            end
            
            a = onsetII(i_on:i_off);
            b = onsetV(i_on:i_off);
            Nmatched = anastomose(a,b,4);
            Nall = length(a) + length(b) - Nmatched;
            iSQI(i-index_on+1) = Nmatched / Nall;
        end
    end
    r = iSQI';
end
end

%% kSQI
%% K -> kurtosis
function r = kSQI(Arraw ,onset)

if isempty(onset)
       r = zeros(10000,1);
else
        Length = length(onset);
        kSQI = ones(1,Length);
        
        for i = 1 : Length
            
             if onset(i)+625 > length(Arraw)
                 t_end = length(Arraw);
             else
                 t_end = onset(i)+625;
             end
             
              if onset(i)-625 <= 0
                 t_on = 1;
             else
                 t_on = onset(i)-625;
             end
        
            k = kurtosis(Arraw(t_on:t_end)) ;
            
            if k>5
                kSQI(i) = 1;
            else
                kSQI(i) = 0;
            end
         
        end  
        r = kSQI';
end
end


%% sSQI
%% PSD -> power spectral distribution
function r = sSQI(Arraw ,onset,period)

if isempty(onset)
      r = zeros(10000,1);
else
    
    sSQI = ones(1,length(onset));

    for i = 1 : length(onset)-1   
       [Pss, W ] = pwelch( Arraw(onset(i):( onset(i) + period(i) ) ) ,hamming(4) ,2 ,4 ,100,'onesided');
            F_5_14=[5,14];
            F_5_50=[5,50];
            % ҵƵʶӦ
            iVLF_fft= (W>=F_5_14(1)) & (W<=F_5_14(2));
            iLF_fft = (W>=F_5_50(1)) & (W<=F_5_50(2));
            % ƵʶεĹVLFLFHF
            aVLF_fft=trapz(W(iVLF_fft),Pss(iVLF_fft));
            aLF_fft=trapz(W(iLF_fft),Pss(iLF_fft));
            SDR=aVLF_fft/ aLF_fft;           
%            SDR = 0.5;
        
        if (SDR>=0.5) && (SDR<=0.8)
            sSQI(i) = 1;
        end
        
        if (SDR<0.5) || (SDR>0.8)
            sSQI(i) = 0;
        end
    end     
        r = sSQI';
end
end
