function alarmResult=challenge(recordName,alarm_type)
%
%  alarmResult=challenge(recordName,alarm_type)
%
% Sample entry for the 2015 PhysioNet/CinC Challenge.
%
% Inputs:
%   recordName
%       String specifying the record name to process
%   alarmType
%       String specifying the alarm type. Alarm types are:
%             Asystole, Bradycardia, Tachycardia,
%             Ventricular_Tachycardia, Ventricular_Flutter_Fib
%
%
% Outputs:
%   alarmResult
%       Integer value where 0 = false alarm and 1 is a true
%       alarm. 
%
%

answers = 'answers.txt';

%Get all ECG, blood pressure and photoplethysmogram signals
[~,signal,Fs,siginfo]=rdmat(recordName);
alarmResult=1;                                  %
description=squeeze(struct2cell(siginfo));
description=description(4,:);

% Resample signal to 125Hz
Fs=Fs(1);
if Fs~=125
    signal=resample(signal,125,Fs);
    Fs=125;
end
N_d = Fs * 5 * 60;                                     % alarm positionʱ
% N_d = N_d + 4 * Fs;
N0_d= N_d - Fs * 17 + 1;                                % 17s before the alarm
%%Users can access the raw samples of the record by running the following

N=[];
N0=[];
abp_ind=get_index( description, 'ABP' );                                       %abpźż¼
ann_abp=[];                                                                 %
features=[];                                                                
BEATQ=[];
R=[];
if(~isempty(abp_ind))
   ann_abp=wabp(signal(:,abp_ind),0,1);
   % Analyze the signal quality index of ABP using jSQI
   if length(ann_abp)>=3 % at least 3 abp beats detected
        [features] = abpfeature(signal(:,abp_ind),ann_abp);
        [BEATQ R] = jSQI(features, ann_abp, signal(:,abp_ind));
        
        %2015/3/16
        %adjust:     Analyze the signal quality index of ABP using wSQI
        [wBEATQ wR] = wSQI( features, ann_abp );
   end
end

%% Run WECG WQRS on the record, which by default will analyze the ECG signal
N=[];
N0=[];
ecg_II=get_index(description,'II');
if length(ecg_II)>=2
    ecg_II_ind = ecg_II(1);
else
    ecg_II_ind = ecg_II;
end

ecg_V_ind=get_index(description,'V');
ann_lt_II=[];
ann_km_II=[];
ann_km_V=[];
Ronset_lt_II=[];
Ronset_km_II=[];
Ronset_lt_V=[];
Ronset_km_V=[];



% жAVRźǷЧ̶жiSQIֵ
% жAVRźǷȫΪ0Ԫ
if ~isempty(ecg_V_ind)
    %if all(signal(:,ecg_V_ind))
    if max(signal(:,ecg_V_ind)) == min(signal(:,ecg_V_ind))
        iseffectiveV  = 0;
    else
        iseffectiveV  = 1;
    end
else
        iseffectiveV  = 0;
end

% жIIźǷЧ̶жiSQIֵ
% жIIźǷȫΪ0Ԫ
if ~isempty(ecg_II_ind)
    if max(signal(:,ecg_II_ind)) == min(signal(:,ecg_II_ind))
        iseffectiveII  = 0;
    else
        iseffectiveII  = 1;
    end
else
        iseffectiveII  = 0;
end

% -------------II𲫵Լecgsqi-----------------------------%

% жIIźǷΪ
if ~isempty(ecg_II_ind) && iseffectiveII
    [ann_km_II , Ronset_km_II , km_period_II] = wqrs(signal(:,ecg_II_ind),0,1);
    [breadth, ann_lt_II,lt_period_II, Ronset_lt_II] = ECG_breadth(signal(:,ecg_II_ind));
end
    ecgsqi_II = 0;
    ecgsqi_II = ECG_SQI( Ronset_km_II, Ronset_lt_II, N0_d, N_d );

    str = '------ecgsqi_II :';
    fprintf('%s%d\n', str, ecgsqi_II);
    
%-------------------------------------------------------------------%

% -------------VΪecgsqi-----------------------------%
  

% жIIźǷΪ
if ~isempty(ecg_V_ind) && iseffectiveV
    [ann_km_V , Ronset_km_V , km_period_V ] = wqrs(signal(:,ecg_V_ind),0,1);
    [breadth, ann_lt_V, lt_period_V, Ronset_lt_V] = ECG_breadth(signal(:,ecg_V_ind));
end
    ecgsqi_V = 0;
    ecgsqi_V = ECG_SQI( Ronset_km_V, Ronset_lt_V, N0_d, N_d );


    str = '------ecgsqi_V  :';
    fprintf('%s%d\n', str, ecgsqi_V);
    
%-------------------------------------------------------------------%

Signal = [];
Onset = [];
% Ronset = [];

%-------------------------------------------------------------------%
if ~isempty(ecg_II_ind) || ~isempty(ecg_V_ind) 
    if ecgsqi_II >= ecgsqi_V
        Signal = signal(:,ecg_II_ind);
        Onset = ann_lt_II;
        ecgsqi = ecgsqi_II;
        ecg_ind = ecg_II_ind;
        
    else
        Signal = signal(:,ecg_V_ind);
        Onset = ann_lt_V;
        ecgsqi = ecgsqi_V;
        ecg_ind = ecg_V_ind;
    end
    
else
        Signal = [];
        Onset = [];
%         Ronset = [];
        ecgsqi = 0;
        
        ecg_ind = [];
        
end

    str = '------ecgsqi    :';
    fprintf('%s%d\n', str, ecgsqi);
 
        
        ecg_sqi = ecgsqi;                   % ecgsqi
        ann_ecg = Onset;                    % onset 
%         ecg_R   = Ronset;                   % R
        

%-------------------------------------------------------------------%

%%
%Run WABP on the record of 'PLETH' to analyze photoplethysmogram signal
ppg_ind=get_index(description,'PLETH');
ann_ppg=[];
if (~isempty(ppg_ind))
    y=quantile(signal(:,ppg_ind),[0.05,0.5,0.95]);
    ann_ppg=wabp(signal(:,ppg_ind),0,(y(3)-y(1))/120);
    % Analyze the signal quality index of PPG 
    if ~isempty(ann_ppg)
        [psqi]=ppgSQI(signal(:,ppg_ind),ann_ppg);
    end
end

%%

%Make decisions

% % set valid data segment for decision making, 16s before the alarm
% % ѡȡ ʱǰ13s,ʱ̺4s
% N_d = Fs * 5 * 60;                                     % alarm positionʱ
% % N_d = N_d + 4 * Fs;
% N0_d= N_d - Fs * 17 + 1;                                % 17s before the alarm

% ȡеƬ
n_abp_beats = intersect(find(ann_abp>=N0_d),find(ann_abp<=N_d)); %Ƭеonsetindexֵ
n_ppg_beats = intersect(find(ann_ppg>=N0_d),find(ann_ppg<=N_d));
n_ecg_beats = intersect(find(ann_ecg>=N0_d),find(ann_ecg<=N_d));




%% calculate the signal quality index ABP and PPG

if ~isempty(ann_abp)
    len_abpsect = length( n_abp_beats );
    temp_abpsqi = zeros( len_abpsect,1 );
    scale_n = 0.7;
    if ( ~isempty( BEATQ ) )
        for i = 1:len_abpsect
             if ( BEATQ(  n_abp_beats( i )  ) == false )
                 temp_abpsqi(i) = wBEATQ( n_abp_beats( i ) );
             else
                 temp_abpsqi(i) = wBEATQ( n_abp_beats( i ) ) * scale_n;
             end
         end
    end
    abpsqi = mean( temp_abpsqi );
else
    abpsqi=0;
end

if ~isempty(ann_ppg)
    ppgsqi=mean(psqi(intersect(n_ppg_beats,1:length(psqi))));
else
    ppgsqi=0;
end

    str = '------abpsqi    :';
    fprintf('%s%d\n', str, abpsqi);
    
    str = '------ppgsqi    :';
    fprintf('%s%d\n', str, ppgsqi);

%% PPG: calculate the heart rate

hr_max_ppg = NaN;
max_rr_ppg = NaN;

rr_ppg     = NaN;
RR_ppg     = NaN;

if length(n_ppg_beats)>=2
    
    rr_ppg = diff( ann_ppg( n_ppg_beats ) ) / Fs;
    RR_ppg = Kalman( rr_ppg, ppgsqi );
    max_rr_ppg = max( RR_ppg );
    hr_max_ppg = 60 * Fs / min( diff( ann_ppg( n_ppg_beats ) ) );
    
end
    
%% PPG: calculate low heart rate of 5 consecutive beats for Bradycardia
low_hr_ppg=NaN;
if length(n_ppg_beats>=5)
    for i=1:length(n_ppg_beats)-4
        low_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+4))-ann_ppg(n_ppg_beats(i)))/4);
    end
end
low_hr_ppg=min(low_hr_ppg);
        
%PPG: calculate high heart reate of 17 consecutive beats for Tachycardia
high_hr_ppg=NaN;
if (length(n_ppg_beats)>=17)
    for i=1:length(n_ppg_beats)-16
        high_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+16))-ann_ppg(n_ppg_beats(i)))/16);
    end
end
high_hr_ppg=max(high_hr_ppg);

%% ECG: calculate the heart rate
hr_max_ecg = NaN;
max_rr_ecg = NaN;
high_hr_ecg = NaN;
low_hr_ecg = NaN;


rr_ecg     = NaN;
RR_ecg     = NaN;

if length(n_ecg_beats)>=2
    
    rr_ecg = diff( ann_ecg( n_ecg_beats ) ) / Fs;
    RR_ecg = Kalman( rr_ecg, ecg_sqi );
    max_rr_ecg = max( RR_ecg );
    hr_max_ecg = 60 * Fs / min( diff( ann_ecg( n_ecg_beats ) ) );

    
    % ecg: calculate low heart rate of 5 consecutive beats for Bradycardia
    low_hr_ecg = NaN;
    if ( length(n_ecg_beats) >= 5 )
        for i=1:length(n_ecg_beats)-4
            low_hr_ecg(i)=60*Fs/((ann_ecg(n_ecg_beats(i+4))-ann_ecg(n_ecg_beats(i)))/4);
        end
%         low_HR_ecg = Kalman( low_hr_ecg, ecgsqi );
        low_hr_ecg = min( low_hr_ecg );
    end
        
    % ecg: calculate high heart reate of 17 consecutive beats for Tachycardia
    high_hr_ecg=NaN;
    if ( length( n_ecg_beats ) >= 17 )
        for i=1:length(n_ecg_beats)-16
            high_hr_ecg(i)=60*Fs/((ann_ecg(n_ecg_beats(i+16))-ann_ecg(n_ecg_beats(i)))/16);
        end
%         [HRecg, ~] = Kalman( high_hr_ecg, ecgsqi );
        HRecg = high_hr_ecg;
        high_hr_ecg = max( HRecg );
    end
end


%% ABP: calculate the heart rate
hr_max_abp = NaN;
max_rr_abp = NaN;
high_hr_abp = NaN;
low_hr_abp = NaN;


rr_abp     = NaN;
RR_abp     = NaN;

if length(n_abp_beats)>=2

    rr_abp = diff( ann_abp( n_abp_beats ) ) / Fs;
    RR_abp = Kalman( rr_abp, abpsqi );
    max_rr_abp = max( RR_abp );
    hr_max_abp = 60 * Fs / min( diff( ann_abp( n_abp_beats ) ) );
    
    % ABP: calculate low heart rate of 5 consecutive beats for Bradycardia
    low_hr_abp = NaN;
    if ( length(n_abp_beats) >= 5 )
      for i=1:length(n_abp_beats)-4
         low_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+4))-ann_abp(n_abp_beats(i)))/4);
      end
      low_HR_abp = Kalman( low_hr_abp, abpsqi );
      low_hr_abp = min( low_HR_abp );
    end
    
        
    % ABP: calculate high heart reate of 17 consecutive beats for Tachycardia
    high_hr_abp=NaN;
    if ( length( n_abp_beats ) >= 17 )
        for i=1:length(n_abp_beats)-16
            high_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+16))-ann_abp(n_abp_beats(i)))/16);
        end
%         [HRabp, ~] = Kalman( high_hr_abp, abpsqi );
        HRabp = high_hr_abp;
        high_hr_abp = max( HRabp );
    end
end


%% 

% Alarm threshold (seconds)
ASY_th = 4;
BRA_th = 40;
TAC_th = 140;
VTA_th = 100;
VFB_th = 250;
tolerance = 5; % tolerance = 5 bmp

%% ں
consqi = 0;
max_rr = [];
high_hr = [];
low_hr = [];

if  ( ( ~isempty(hr_max_abp) ) && ( ~isempty(hr_max_ecg) ) )
%     qe = ( Recg / ecg_sqi ) * ( Recg / ecg_sqi );
%     qa = ( Rabp / abpsqi ) * ( Rabp / abpsqi );
%     max_hr = qa / ( qe + qa ) * hr_max_ecg + qe / ( qa + qe ) * hr_max_abp;
%     min_hr = qa / ( qe + qa ) * hr_min_ecg + qe / ( qa + qe ) * hr_min_abp;
    consqi = max( ecg_sqi, abpsqi );
    hr_max = max( hr_max_abp, hr_max_ecg );
    max_rr = min( max_rr_abp, max_rr_ecg );
    high_hr = max( high_hr_abp, high_hr_ecg );
    low_hr = min( low_hr_abp, low_hr_ecg );
else if ~isempty( hr_max_ecg )
        consqi = ecg_sqi;
        high_hr = high_hr_ecg;
        low_hr = low_min_ecg;
        max_rr = max_rr_ecg;
    else if ~isempty( hr_max_abp )
            consqi = abpsqi;
            high_hr = high_hr_abp;
            low_hr = low_hr_abp;
            max_rr = max_rr_abp;
        end
    end
end



%%
switch alarm_type
    case 'Asystole'
        % if the signal quality is good enough and the maximum RR interval
        % is less than the Asystole threshold, set the alarm as 'F'
        sqi_th = 0.5;
        if ( consqi >= sqi_th && max_rr < ASY_th) || ( ppgsqi >= sqi_th && max_rr_ppg < ASY_th )
            alarmResult = 0;
        end
    case 'Bradycardia'
        % if the signal quality is good enough and the low heart rate
        % is greater than the Bradycardia threshold, set the alarm as 'F'
        sqi_th = 0.5;
        if ( consqi >= sqi_th && low_hr - tolerance > BRA_th ) || ( ppgsqi >= sqi_th && low_hr_ppg-tolerance > BRA_th )
            alarmResult = 0;
        end
    case 'Tachycardia'
        % if the signal quality is good enough and the high heart rate
        % is less than the Tachycardia threshold, set the alarm as 'F'
        sqi_th = 0.9;
        if ( consqi >= sqi_th && high_hr + tolerance < TAC_th ) || ( ppgsqi >= sqi_th && high_hr_ppg + tolerance < TAC_th)
            alarmResult = 0;
        end
    case 'Ventricular_Tachycardia'
        % suppress false alarm using hr_max & sqi
        sqi_th = 0.5;
        if ( consqi >= sqi_th )
            if ( hr_max + tolerance < VTA_th )
                alarmResult = 0;
            else if( ~isempty( breadth ) && max( breadth ) <= 0.12  )
                alarmResult = 0;
                end
            end
        else if  ( ppgsqi >= sqi_th && hr_max_ppg + tolerance < VTA_th )
                alarmResult = 0;
            end
        end
%         if ( consqi >= sqi_th && max_hr + tolerance < VTA_th) || ( ppgsqi >= sqi_th && hr_max_ppg + tolerance < VTA_th )
%             alarmResult=0;
%         end
    case 'Ventricular_Flutter_Fib'
        % suppress false alarm using max_hr & sqi
        sqi_th = 0.5;
        if ( consqi >= sqi_th && hr_max + tolerance < VFB_th ) || ( ppgsqi >= sqi_th && hr_max_ppg + tolerance < VFB_th )
            alarmResult = 0;
        end
    otherwise
        error(['Unknown alarm type: ' alarm_type])
end

% Write result to answers.txt
fid = fopen(answers, 'a');
if (fid == -1)
    error('Could not open answer file');
end

% Get base name of record (without directories)
i = strfind(recordName, filesep);
if (~isempty(i))
    basename = recordName(i(end)+1 : end);
else
    basename = recordName;
end

fprintf(fid, '%s,%d\n', basename, alarmResult);
fclose(fid);

end

%%%%%%%%%%%% Helper Functions %%%%%%%%%%%%%%%%%%%%%
function ind=get_index(description,pattern)
M=length(description);
tmp_ind=strfind(description,pattern);
ind=[];
for m=1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1)=m;
    end
end
end
