function [HRout] = Kalman ( HRin, SQI )
%   [BEATQ, R] = JSQI(FEATURES, ONSET, ABP) returns a binary signal quality
%   assessment of each beat in ABP.  This algorithm relies on detecting
%   abnormalities of numeric values in FEATURES and ONSET.
%
%   In:   HRin    <nx1>  --- HeartRates       
%         SQI     <1x1>  --- Signal Quality Index
%
%   Out:  BEATQ    <nx1> --- HeartRates through Kalman Filter
%         R        <1x1> --- Residual
% 
%   Usage:
%
%   2015/3/20

HRout = HRin;
% r = NaN;
N = length( HRin );
if( N >= 2 )
%%%%%%%%%%%%%%%kalman filter%%%%%%%%%%%%%%%%%%%%%%
x       = zeros( N, 1 );
x(1)    = HRin( 1 );
P       = 1;                                  %initial optimal covariance
R0      = 1;                                 %
Q       = 0.1;
SQIth   = 0.5;
if SQI > SQIth
    R = R0 * exp( 1 / ( SQI * SQI ) - 1 );  %observed convariance
else
    R = R0;
end
%%%%%%%%%%%%%%recursive process%%%%%%%%%%%%%%%%%%%
for i = 2 : N
    estimate = x( i - 1 );              %process evaluate value
    P        = P + Q;                   %process convariance
    Kg       = P / ( P + R );           %Kalamn Gain
    x( i )   = min( estimate, HRin( i ) ) + Kg * abs( HRin( i ) - estimate );       %optimal object value
    P        = ( 1 - Kg ) * P;          %optimal value convariance
end
HRout = x;
% r = Kg;

end
end
