function [breadth, Qonset, Peroid ,Ronset] = ECG_breadth( ECGin,  Fs )
%   [BEATQ, R] = JSQI(FEATURES, ONSET, ABP) returns a binary signal quality
%   assessment of each beat in ABP.  This algorithm relies on detecting
%   abnormalities of numeric values in FEATURES and ONSET.
%
%   In:   ECGin             --- Signal       
%         R_peak     <nx1>  
%
%   Out:  breadth    <nx1>  --- Second
% 
%   Usage:
%
%   2015/3/20

if nargin<2
Fs=125;
end


R_peak = diffhold( ECGin, Fs );
% 
% if ( length( R_peak ) < length( ECGin ) / 200 )
%     R_peak = diffhold( ( -ECGin ), Fs );
% end

Ronset = R_peak;

%% szq
 [c,l]=wavedec(ECGin,8,'coif4');   % ѡȡsym8Сź8ֽ
 
    cA8=appcoef(c,l,'coif4',8);
    cD8=detcoef(c,l,8);
    cD7=detcoef(c,l,7);
    cD6=detcoef(c,l,6);
    cD5=detcoef(c,l,5);
    cD4=detcoef(c,l,4);
    cD3=detcoef(c,l,3);
    cD2=detcoef(c,l,2);
    cD1=detcoef(c,l,1);
    % cA8cD1cD2cD3ˣ㣩
    cA8(:,1)=0;
    cD1(:,1)=0;
    cD2(:,1)=0;
    cD3(:,1)=0;
    re_c=[cA8;cD8;cD7;cD6;cD5;cD4;cD3;cD2;cD1];
    S2=waverec(re_c,l,'coif4'); %ع

    ECGin = S2;


%% 
len_peak = length( R_peak );            %ecgθ
len_sig  = length( ECGin );             %

B        = zeros( len_sig, 1 );
C        = zeros( len_sig, 1 );
D        = zeros( len_sig, 1 );
D( 1 )   = ECGin( 1 );
D( len_sig ) = ECGin( len_sig );
% иĽtompkins任
if ( len_sig >= 3 )
    for i = 2:len_sig-1
        y2     = ECGin( i + 1 );
        y1     = ECGin( i );
        y0     = ECGin( i - 1 );
        B(i)   = y2 - y1;
        C(i)   = y2 - 2 * y1 + y0;
        B(i)   = B(i) * B(i);
        C(i)   = C(i) * C(i);
        D(i)   = B(i) + C(i);
    end
    
% disp('ѰRֵ' );    
    Find = D;
    
    %ѰҽӽR ҷֵ
    Window = 7;
%     [ LeftDomain RightDomain ] = init( zeros( len_sig, Window ) );
    LeftDomin = zeros( len_peak, Window );
    RightDomin = zeros( len_peak, Window );
    for i = 1:Window
        LeftDomain( :, i )  = R_peak - i + 1;
        RightDomain( :, i ) = R_peak + i - 1;
    end
    LeftDomain( LeftDomain < 1 ) = 1;  % Error protection
    RightDomain( RightDomain > len_sig ) = len_sig;

% 
    Left_peak   = zeros( len_peak, 1 );
    Right_peak  = zeros( len_peak, 1 );
    Lindex      = zeros( len_peak, 1 );
    Rindex      = zeros( len_peak, 1 );

    for i = 1:len_peak
        Left_peak( i ) = Find( LeftDomain( i, 1 ) );
        Lindex( i ) = 1;
        Right_peak( i ) = Find( RightDomain( i, 1 ) );
        Rindex( i ) = 1;
        for j = 2:Window
            if ( Find( LeftDomain( i, j ) ) > Left_peak( i ) )
                Left_peak( i ) = Find( LeftDomain( i, j ) );
                Lindex( i ) = j;
            end
            if ( Find( RightDomain( i, j ) ) > Right_peak( i ) )
                Right_peak( i ) = Find( RightDomain( i, j ) );
                Rindex( i ) = j;
            end
        end
    end
%     [ Left_peak, Lindex ]  = max( Find( LeftDomain ),[],2 );
%     [ Right_peak,  Rindex ]  = max( Find( RightDomain ),[],2 );
    
    Lindex = R_peak - Lindex ;
    Rindex = R_peak + Rindex ;
    % RҲصļֵ

    Left_threshold = Left_peak / 30;
    Right_threshold = Right_peak / 30;
    
    
% disp( ' Ѱ ' ) ;   
    Stend = D;
    % ѰQRSҲ
    Window = 5;      % ѰҷΧ30ms
%     [ LeftDomain, RightDomain ] = init( zeros( len_sig, Window ) );
    QonsetDomin = zeros( len_peak, Window );
    SonsetDomin = zeros( len_peak, Window );
    
    for i = 1:len_peak
        for j = Window:1
            k = round( Lindex( i ) - j + 1 );
            if ( k < 1 )
                k = 1;
            end
            QonsetDomin( i, j ) = Stend( k );
            
            k = round( Rindex( i ) + j - 1 );
            if ( k > len_sig )
                k = len_sig;
            end
            SonsetDomin( i, j ) = Stend( k );
        end
    end
    
%     for i = 1:Window
%         k = round( Lindex - i + 1 );
%         if ( k < 1 )    
%             k = 1;
%         end
%         QonsetDomin( :, i ) = Stend( k );
%         
%         
%         k = round( Rindex + i - 1 );
%         if ( k > len_sig )    
%             k = len_sig;
%         end
%         SonsetDomin( :, i ) = Stend( k );
%     end
    
    Qindex = zeros( len_peak, 1 );
    Sindex = zeros( len_peak, 1 );
    
%     [ ~, Qindex ]  = min( RonsetDomin > Left_threshold,[],2);
%     %ÿпûҵֵֵ ɾάȵĲһ
%     [ ~,  Sindex ]  = min( SonsetDomin > Right_threshold,[],2);
    
    for i = 1:len_peak
        lock1 = 0;
        lock2 = 0;
        Qindex(i) = 1;
        Sindex(i) = 1;
        for j = 1:Window
            if ( QonsetDomin( i, j ) > Left_threshold( i )  && lock1 == 0 )  
                Qindex( i ) = j;
                lock1 = 1;
            end
            if ( SonsetDomin( i, j ) > Right_threshold( i ) && lock2 == 0 )  
                Sindex( i ) = j;
                lock2 = 1;
            end
        end
    end
    

    Qindex = Lindex - Window + Qindex - 1;
    Sindex = Rindex + Window - Sindex + 1;
%{
    LeftPeak = zeros( len_peak, Window );
    RightPeak = zeros( len_peak, Window );
    for i = 1:Window
       LeftPeak( :, i )  = Lindex - i + 1;
       RightPeak( :, i ) = Lindex + i - 1;
    end       
    
    Qindex = zeros( len_peak, 1 );
    Sindex = zeros( len_peak, 1 );
    for i = 1:len_peak
        lock1 = 0;
        lock2 = 0;
        Qindex(i) = LeftPeak( i, 1 );
        Sindex(i) = RightPeak( i, 1 );
        for j = 1:Window
            if ( Stend( LeftPeak( i, j ) ) > Left_threshold( i )  && lock1 == 0 )  
                Qindex( i ) = LeftPeak( i, j );
                lock1 = 1;
            end
            if ( Stend( RightPeak( i, j ) ) < Right_threshold( i ) && lock2 == 0 )  
                Sindex( i ) = RightPeak( i, j );
                lock2 = 1;
            end
        end
    end
%     [ ~, Lindex ]  = min( ECGin( LeftDomain ),[],2);
%     [ ~,  Rindex ]  = min( ECGin( RightDomain ),[],2);
%}
    
    Qindex = Qindex + 5;
    Sindex = Sindex - 5;
    breadth = Sindex - Qindex;
    Peroid = breadth;
    %
    
    
    for i=1:length(Peroid)
        if Peroid(i) <4
        Peroid(i) = 4;
        end
    end
    %
    breadth = breadth / 125;
    Qonset = Qindex;
%     Sonset = Sindex;
    Qonset( Qonset < 1 ) = 1;  % Error protection
%     Sonset( Sonset > len_sig ) = len_sig;
end

end
    