function ECG_SQI = ecgsqi( Ronset_one, Ronset_two, frontedge, rearedge )

len_one = length( Ronset_one );
len_two = length( Ronset_two );

scale = 0.5;
sqi_part1 = 0;
if ( len_one > 0 && len_two > 0 )
    len_max = max( len_one, len_two );
    len_min = min( len_one, len_two );
    sqi_one = len_min / len_max * scale;
    len_anast = anastomose( Ronset_one, Ronset_two, 5 );
    sqi_two = len_anast / ( len_one + len_two - len_anast ) * scale;
    sqi_part1 = sqi_one + sqi_two;
end

Ronset_one = Ronset_one( Ronset_one >= frontedge );
Ronset_one = Ronset_one( Ronset_one <= rearedge );
Ronset_two = Ronset_two( Ronset_two >= frontedge );
Ronset_two = Ronset_two( Ronset_two <= rearedge );
sqi_part2 = 0;

len_one = length( Ronset_one );
len_two = length( Ronset_two );
if ( len_one > 0 && len_two > 0 )
    len_max = max( len_one, len_two );
    len_min = min( len_one, len_two );
    sqi_one = len_min / len_max * scale;
    len_anast = anastomose( Ronset_one, Ronset_two, 5 );
    sqi_two = len_anast / ( len_one + len_two - len_anast ) * scale;
    sqi_part2 = sqi_one + sqi_two;
end

scale2 = 0.4;
sqi_con = sqi_part1 * scale2 + sqi_part2 * ( 1 - scale2 );

ECG_SQI = sqi_con;

end


    
