function [version, libs, cflags] = wfdb_config;
% function [version, libs, cflags] = wfdb_config
% Return the WFDB library version and configuration information.
%
% Three values are returned, as strings: the version of the WFDB
% library used (the native library, underneath the MATLAB and Java
% code); the linker information that would be needed to link
% against the library; and the "cflags," the options needed to
% compile code that uses this library.
%
% No arguments
%
% It is fairly unlikely that anything aside from the version string
% would be used here, within MATLAB.
%
% See also wfdb-config(1) man page
%
% Copyright (c) 2009 by Michael Craig, All Rights Reserved
% Contact M. Craig (mic@mit.edu)
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
%    02111-1307  USA
%
% wfdb_config.m and its dependencies are freely available from Physionet -
% http://www.physionet.org/ - please report any bugs to the authors above.


%
%
LoadWFDBJava.load;

%
%
version = char(wfdb.wfdb.wfdbversion);
libs =    char(wfdb.wfdb.wfdbldflags);
cflags =  char(wfdb.wfdb.wfdbcflags);

