function [arr] = struct2javaarray(str, javaClass);
% function [arr] = struct2javaarray(str, javaClass)
% Convert a 1xN struct array to a Java array of objects of the
% given class.
%
% It is expected that the public fields of the class
% match the fields of the struct, and that the class has a default
% (zero-argument) constructor. After constructing each object, the
% public fields are filled in to match those of the struct, but
% nothing else is done.
%
% The argument javaClass may be either a Java Class object, or a
% MATLAB string (char array) giving the name of the class.
%
% NOTE: struct arrays with either dimension 0 are not supported.
%
% Examples
%
%    % convert a 1x3 struct array, with the proper fields, into a Java
%    % array of element-type Dimension
%    a = struct2javaarray(struct('width',{5,10,15},'height',{10,20,30}), ...
%                         java.lang.Class.forName('java.awt.Dimension'))
%
%    a =
%
%    java.awt.Dimension[]:
%        [java.awt.Dimension]
%        [java.awt.Dimension]
%        [java.awt.Dimension]
%
%
%
% See also DEEPCONVERT
%
% Copyright (c) 2009 by Michael Craig, All Rights Reserved
% Contact M. Craig (mic@mit.edu)
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
%    02111-1307  USA
%
% struct2javaarray.m and its dependencies are freely available from Physionet -
% http://www.physionet.org/ - please report any bugs to the authors above.


%
% FIXME: may want to change these to assert, but need to include an
%        assert function (not available on old MATLABs)
%
if ~isstruct(str)
  error('wfdbSwigMatlab:struct2javaarray:str_not_struct', ...
        'Argument str is not a struct');
end
if size(str, 1) ~= 1
  error('wfdbSwigMatlab:struct2javaarray:str_not_row_vector', ...
        'Argument str is not a row vector');
end


%
% javaClass can either be a Java Class, or its string name;
% in the latter case, turn it into the actual Class object.
%
if ischar(javaClass)
  % FIXME: catch the exception
  javaClass = ...
      java.lang.ClassLoader.getSystemClassLoader.loadClass(javaClass);
end


%
%
%
strfnames = sort(fieldnames(str));

% FIXME: would like to use javaClass.getFields instead
objfnames = sort(fieldnames(javaClass.newInstance));

if (size(strfnames) ~= size(objfnames)) ...
      | ~all(strcmp(strfnames, objfnames))
  error('wfdbSwigMatlab:struct2javaarray:struct_mismatch', ...
        'The fields of the struct and the java Class do not match');
end


%
% FIXME: may need to optimize this
%
arr = javaArray(char(javaClass.getCanonicalName), length(str));
for i = 1 : arr.length
  arr(i) = javaClass.newInstance;
  for j = 1 : length(strfnames)
    setfield(arr(i), strfnames{j}, getfield(str(i), strfnames{j}));
  end
end

