function [] = setwfdb(varargin)
% function [] = setwfdb
% function [] = setwfdb(path)
% Set the search path fo WFDB input files to the default list of
% locations, or to a new list of locations.
%
% The WFDB tools, when searching for input files, look through an
% ordered list of locations, i.e. the WFDB path. This path is
% stored in the environment variable "WFDB".
%
% When called with no arguments, SETWFDB restores this path to
% its default value (determined at compile time.)
% 
% When called with one argument, SETWFDB sets this path to that
% of the argument. The path should be a space-separated string
% (Java String or char row vector.)
%
% Bugs
%
%   This behaves slightly differently from the original WFDB
%   app. setwfdb, in that it does not restore "WFDBCAL" to its
%   default value.
%
% See also setwfdb(1) man page
%
% Copyright (c) 2009 by Michael Craig, All Rights Reserved
% Contact M. Craig (mic@mit.edu)
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
%    02111-1307  USA
%
% setwfdb.m and its dependencies are freely available from Physionet -
% http://www.physionet.org/ - please report any bugs to the authors above.

%
% FIXME: WFDBCAL does not get set; this doesn't matter much, though;
%        all that matters is that calopen(), in WFDB, be called
%        with the proper path, when it is called
%
% FIXME: have it return the new path
%

%
LoadWFDBJava.load;

%
switch length(varargin)
  case 0
    wfdb.wfdb.setwfdb(wfdb.wfdb.wfdbdefwfdb);
  case 1
    wfdb.wfdb.setwfdb(varargin{1});
  otherwise
    error('wfdbSwigMatlab:setwfdb:invalid_args', ...
          'Too many arguments were passed');
end


% %
% setenv('WFDB', char(wfdb.wfdb.wfdbdefwfdb));
% setenv('WFDBCAL', char(wfdb.wfdb.wfdbdefwfdbcal));
