function [S] = rdsamp_stream(record, varargin)
% function [S] = rdsamp_stream(record, ...)
%
% FIXME: description
%
%
% Copyright (c) 2009 by Michael Craig, All Rights Reserved
% Contact M. Craig (mic@mit.edu)
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
%    02111-1307  USA
%
% rdsamp_stream.m and its dependencies are freely available from Physionet -
% http://www.physionet.org/ - please report any bugs to the authors above.


%
%LoadWFDBJava.load;


%
argsInfo = struct('begin',     { {[]},    '1', 'string'  }, ...
                  'maxt',      { {[]},    '1', 'string'  }, ...
                  'stop',      { {[]},    '1', 'string'  }, ...
                  'hires',     { {false}, '1', 'boolean' }, ...
                  'phys',      { {false}, '1', 'boolean' }, ...
                  'sigs',      { {},      '*', 'uint32'  }, ...
                  'blocksize', { {16384}, '1', 'uint32'  });

%
p = varargin2struct(varargin, argsInfo(1), argsInfo(2));
verify_params(p, argsInfo(2:3));

%
blockSize = p.blocksize{1};
if blockSize <= 0
  error('wfdbSwigMatlab:rdsamp_stream:block_size_too_small', ...
        'Block size must be a positive integer');
end
  
%
rdsampStream = rdsampMatlab.newStreamState(record, ...
                                           p.begin{1}, ...
                                           p.maxt{1}, ...
                                           p.stop{1}, ...
                                           p.hires{1}, ...
                                           p.phys{1}, ...
                                           cell2mat(p.sigs), ...
                                           blockSize);

%
rdsampStream.open;
width = rdsampStream.getWidth;
S = zeros(blockSize, width);
currentLength = blockSize;
currentFill = 0;

%
% the goal here is to read in large records without filling up
% the JVM's heap. this is accomplished by keeping a stateful java
% "reader" that has a method that returns fixed-size blocks of the
% record. matlab is then used to piece the blocks together.
%
% the naive concatenation of blocks onto the end of a matlab matrix
% is far too slow, because of memory management costs. this code
% helps out matlab by doubling the matrix as necessary; we only do
% log(N) allocs. for a record of length N (and note that total time
% spent is still Theta(N)).
%
% FIXME: we should probably try to use wfdbdesc, even if it's not
%        necessarily accurate.
%
while true
  n = rdsampStream.readNextBlock;
  if n == 0
    break;
  else
    block = rdsampStream.getBlock;
    
    % since we init. S to have length of blockSize, this can be
    % just "if" instead of "while", but we're being safe
    while (currentFill + n) > currentLength
      currentLength = 2 * currentLength;
      St = [S(1:currentFill,:); zeros(currentLength - currentFill, width)];
      S = St;
    end
    
    S((currentFill+1):(currentFill+n),:) = block(1:n,:);
    currentFill = currentFill + n;
  end
end

if currentFill < currentLength
  S = S(1:currentFill,:);
end

%
wfdb.wfdb.wfdbquit;
