/*
 * Decompiled with CFR 0.152.
 */
import installer.common.Controller;
import installer.common.MatlabRunner;
import installer.common.ProcessExecutionException;
import installer.common.ProcessOutputAnalyzer;
import installer.common.ProcessRunner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsTempFileMatlabRunner
extends MatlabRunner {
    private static final WindowsTempFileMatlabRunner runner = new WindowsTempFileMatlabRunner();

    private WindowsTempFileMatlabRunner() {
    }

    private static File createTempDirectory(String string, String string2, File file) throws IOException {
        File file2 = File.createTempFile(string, string2, file);
        if (!file2.delete()) {
            throw new IOException("Unable to delete temporary file: " + file2.getAbsolutePath());
        }
        if (!file2.mkdir()) {
            throw new IOException("Unable to create temporary directory: " + file2.getAbsolutePath());
        }
        return file2;
    }

    public static WindowsTempFileMatlabRunner get() {
        return runner;
    }

    public void launch(File file, String string, File file2) throws IOException {
        File file3 = new File(new File(file, "bin"), "matlab.bat");
        if (!file3.exists()) {
            throw new IOException("Expected MATLAB executable " + file3.getAbsolutePath() + " " + "does not exist");
        }
        String[] stringArray = new String[]{file3.getAbsolutePath(), "-desktop", "-r", string};
        Runtime.getRuntime().exec(stringArray, null, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResultType> ResultType run(File file, String string, File file2, ProcessOutputAnalyzer<ResultType> processOutputAnalyzer) throws IOException, ProcessExecutionException {
        Object object;
        block18: {
            Logger logger = Logger.getLogger("controller");
            File file3 = new File(new File(file, "bin"), "matlab.bat");
            if (!file3.exists()) {
                throw new IOException("Expected MATLAB executable " + file3.getAbsolutePath() + " " + "does not exist");
            }
            boolean bl = false;
            if (file2 == null && processOutputAnalyzer != null) {
                bl = true;
                file2 = File.createTempFile("wsm", null);
            }
            Vector<String> vector = new Vector<String>();
            vector.add(file3.getAbsolutePath());
            vector.add("-nodesktop");
            vector.add("-nosplash");
            vector.add("-wait");
            if (file2 != null) {
                vector.add("-logfile");
                vector.add(file2.getAbsolutePath());
            }
            vector.add("-r");
            vector.add("wfdbtmp");
            String[] stringArray = vector.toArray(new String[0]);
            logger.info("Running MATLAB (" + file3.getAbsolutePath() + ") with " + (file2 != null ? "log file " + file2.getAbsolutePath() + " and " : "") + "command: " + string + " ...\n");
            File file4 = WindowsTempFileMatlabRunner.createTempDirectory("wsm", null, null);
            File file5 = new File(file4, "wfdbtmp.m");
            try {
                if (!file5.createNewFile()) {
                    throw new IOException("Unable to create file: " + file5.getAbsolutePath() + "\n");
                }
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file5)));
                bufferedWriter.write(string + "\n" + "exit;\n");
                bufferedWriter.close();
                ProcessRunner.runWithWorkingDirectory(null, (File)file4, (String[])stringArray);
                try {
                    if (processOutputAnalyzer != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
                        try {
                            object = processOutputAnalyzer.analyzeOutput(bufferedReader);
                            break block18;
                        }
                        catch (ProcessOutputAnalyzer.UnexpectedOutputException unexpectedOutputException) {
                            throw new ProcessExecutionException(stringArray, unexpectedOutputException.getMessage());
                        }
                    }
                    object = null;
                }
                finally {
                    if (file2 != null && bl && file2.exists() && !file2.delete()) {
                        logger.warning("Unable to delete temporary file: " + file2.getAbsolutePath() + " " + "(not a fatal error.)\n");
                    }
                }
            }
            finally {
                try {
                    Controller.removeDirectory((File)file4);
                }
                catch (IOException iOException) {
                    logger.warning("Unable to remove directory: " + file4.getAbsolutePath() + " " + "(not a fatal error.)\n");
                }
            }
        }
        return (ResultType)object;
    }
}

