/*
 * Decompiled with CFR 0.152.
 */
import installer.common.MatlabRunner;
import installer.common.ProcessExecutionException;
import installer.common.ProcessOutputAnalyzer;
import installer.common.ProcessRunner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsCommandLineMatlabRunner
extends MatlabRunner {
    private static final WindowsCommandLineMatlabRunner runner = new WindowsCommandLineMatlabRunner();

    private WindowsCommandLineMatlabRunner() {
    }

    public static WindowsCommandLineMatlabRunner get() {
        return runner;
    }

    public void launch(File file, String string, File file2) throws IOException {
        File file3 = new File(new File(file, "bin"), "matlab.exe");
        if (!file3.exists()) {
            throw new IOException("Expected MATLAB binary " + file3.getAbsolutePath() + " " + "does not exist");
        }
        String[] stringArray = new String[]{file3.getAbsolutePath(), "-desktop", "-r", string};
        Runtime.getRuntime().exec(stringArray, null, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResultType> ResultType run(File file, String string, File file2, ProcessOutputAnalyzer<ResultType> processOutputAnalyzer) throws IOException, ProcessExecutionException {
        Object object;
        block10: {
            Logger logger = Logger.getLogger("controller");
            File file3 = new File(new File(file, "bin"), "matlab.exe");
            if (!file3.exists()) {
                throw new IOException("Expected MATLAB binary " + file3.getAbsolutePath() + " " + "does not exist");
            }
            boolean bl = false;
            if (file2 == null && processOutputAnalyzer != null) {
                bl = true;
                file2 = File.createTempFile("wsm", null);
            }
            Vector<String> vector = new Vector<String>();
            vector.add(file3.getAbsolutePath());
            vector.add("-nodesktop");
            vector.add("-nosplash");
            vector.add("-wait");
            vector.add("-automation");
            if (file2 != null) {
                vector.add("-logfile");
                vector.add(file2.getAbsolutePath());
            }
            vector.add("-r");
            vector.add(string);
            String[] stringArray = vector.toArray(new String[0]);
            logger.info("Running MATLAB (" + file3.getAbsolutePath() + ") with " + (file2 != null ? "log file " + file2.getAbsolutePath() + " and " : "") + "command: " + string + " ...\n");
            ProcessRunner.run(null, (String[])stringArray);
            try {
                if (processOutputAnalyzer != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
                    try {
                        object = processOutputAnalyzer.analyzeOutput(bufferedReader);
                        break block10;
                    }
                    catch (ProcessOutputAnalyzer.UnexpectedOutputException unexpectedOutputException) {
                        throw new ProcessExecutionException(stringArray, unexpectedOutputException.getMessage());
                    }
                }
                object = null;
            }
            finally {
                if (file2 != null && bl && file2.exists() && !file2.delete()) {
                    logger.warning("Unable to delete temporary file: " + file2.getAbsolutePath() + " " + "(not a fatal error.)\n");
                }
            }
        }
        return (ResultType)object;
    }
}

