/*
 * Decompiled with CFR 0.152.
 */
import installer.common.Controller;
import installer.common.InstallerGUI;
import installer.common.NoSuperuserPasswordException;
import installer.common.ProcessExecutionException;
import installer.common.ProcessOutputAnalyzer;
import installer.common.ProcessRunner;
import installer.common.ResourceNotFoundException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeController
extends Controller {
    static final String nativeI386BinaryListFileName = "native-lib-files-i386.txt";
    static final String nativeX86_64BinaryListFileName = "native-lib-files-x86_64.txt";
    static final String nativePPCBinaryListFileName = "native-lib-files-ppc.txt";
    static final String withttyPPCNameFileName = "withtty-ppc-name.txt";
    static final String withttyI386NameFileName = "withtty-i386-name.txt";
    static final String withttyX86_64NameFileName = "withtty-x86_64-name.txt";
    private String suPath = null;
    private String sudoPath = null;
    private String withttyName = null;
    private File withttyPath = null;
    private boolean nativeSpecificFilesCopied = false;

    /*
     * Exception decompiling
     */
    protected void copyFile(File var1_1, File var2_2) throws IOException, NoSuperuserPasswordException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void copyNativeSpecificFilesFromPackageToHost(String string) throws IOException, ProcessExecutionException, ResourceNotFoundException {
        Set set;
        if (this.nativeSpecificFilesCopied) {
            return;
        }
        if (string.equals("i386")) {
            set = NativeController.getResourceNamesFromTextFileResource((String)withttyI386NameFileName);
        } else if (string.equals("ppc")) {
            set = NativeController.getResourceNamesFromTextFileResource((String)withttyPPCNameFileName);
        } else if (string.equals("x86_64")) {
            set = NativeController.getResourceNamesFromTextFileResource((String)withttyX86_64NameFileName);
        } else {
            throw new IOException("unavailable arch. requested for withtty: " + string);
        }
        assert (set.size() == 1);
        this.withttyName = (String)set.iterator().next();
        this.withttyPath = new File(this.getActiveConfigDirectory(), NativeController.localizeRelativePath((String)this.withttyName));
        this.copyResourceToLocalFile(this.withttyName, this.withttyPath);
        this.makeFileExecutable(this.withttyPath);
        this.nativeSpecificFilesCopied = true;
    }

    private Set<File> findMatlabPaths() {
        File file = new File("/Applications");
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("MATLAB");
            }
        });
        HashSet<File> hashSet = new HashSet<File>();
        for (String string : stringArray) {
            hashSet.add(new File(file, string));
        }
        return hashSet;
    }

    public Map<File, InstallerGUI.MatlabInstallation> findMatlabPathsAndVersions() {
        this.logger.info("Looking for MATLAB paths...\n");
        Set<File> set = this.findMatlabPaths();
        HashMap<File, InstallerGUI.MatlabInstallation> hashMap = new HashMap<File, InstallerGUI.MatlabInstallation>();
        for (File file : set) {
            InstallerGUI.MatlabInstallation matlabInstallation = this.verifyMatlabPathAndGetVersion(file);
            if (matlabInstallation == null) {
                this.logger.severe("Unable to verify MATLAB installation in " + file.getAbsolutePath() + "\n");
                continue;
            }
            hashMap.put(file, matlabInstallation);
        }
        return hashMap;
    }

    protected boolean gatherPlatformDependentConfigurationInformation(List<String> list) {
        this.suPath = null;
        this.sudoPath = null;
        boolean bl = true;
        try {
            this.suPath = (String)ProcessRunner.run((ProcessOutputAnalyzer)new ProcessOutputAnalyzer.LastLine(), (String[])new String[]{"which", "su"}).outputResult;
        }
        catch (ProcessExecutionException processExecutionException) {
            bl = false;
            list.add("Unable to get location of su: " + processExecutionException.getMessage());
        }
        try {
            this.sudoPath = (String)ProcessRunner.run((ProcessOutputAnalyzer)new ProcessOutputAnalyzer.LastLine(), (String[])new String[]{"which", "sudo"}).outputResult;
        }
        catch (ProcessExecutionException processExecutionException) {
            bl = false;
            list.add("Unable to get location of sudo: " + processExecutionException.getMessage());
        }
        return bl;
    }

    protected File getMatlabUserpathGuess() {
        return new File(this.getUserHomeDirectory(), "matlab");
    }

    protected Set<String> getNativeBinaryFileNames(String string) throws IOException {
        if (string.equals("ppc")) {
            return NativeController.getResourceNamesFromTextFileResource((String)nativePPCBinaryListFileName);
        }
        if (string.equals("i386")) {
            return NativeController.getResourceNamesFromTextFileResource((String)nativeI386BinaryListFileName);
        }
        if (string.equals("x86_64")) {
            return NativeController.getResourceNamesFromTextFileResource((String)nativeX86_64BinaryListFileName);
        }
        throw new IOException("Unsupported arch. libs. requested (this is a bug!)");
    }

    protected boolean isFileReadOnly(File file) throws IOException {
        return false;
    }

    protected boolean isSupportedArch(String string) {
        return string.equals("ppc") || string.equals("i386") || string.equals("x86_64");
    }

    protected boolean isSupportedMatlabVersion(String string) {
        return true;
    }

    protected void launchMatlabWithCommand(File file, String string, File file2) throws IOException {
        MacOSXMatlabRunner.get().launch(file, string, file2);
    }

    private void makeFileExecutable(File file) throws ProcessExecutionException {
        String[] stringArray = new String[]{"chmod", "+x", file.getAbsolutePath()};
        ProcessRunner.Result result = ProcessRunner.run(null, (String[])stringArray);
        if (result.processReturnResult != 0) {
            throw new ProcessExecutionException(stringArray, "chmod didn't return 0");
        }
    }

    private <OutputType> ProcessRunner.Result<OutputType> runAsRoot(ProcessOutputAnalyzer<OutputType> processOutputAnalyzer, String ... stringArray) throws ProcessExecutionException {
        String[] stringArray2 = null;
        if (!this.withttyPath.exists()) {
            this.withttyPath = new File(this.getActiveConfigDirectory(), this.withttyName);
        }
        switch (this.getSuperuserPassword().authenticationMethod) {
            case SU: {
                int n;
                stringArray2 = new String[7 + stringArray.length];
                stringArray2[0] = this.withttyPath.getAbsolutePath();
                stringArray2[1] = "su";
                stringArray2[2] = "DUMMY_PROMPT";
                stringArray2[3] = "/bin/sh";
                stringArray2[4] = "-c";
                stringArray2[5] = this.suPath + " -s /bin/sh -c \"";
                for (n = 1; n <= stringArray.length; ++n) {
                    stringArray2[5] = stringArray2[5] + " $" + n;
                }
                stringArray2[5] = stringArray2[5] + "\"";
                stringArray2[6] = "su";
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[7 + n] = stringArray[n];
                }
                break;
            }
            case SUDO: {
                int n;
                stringArray2 = new String[7 + stringArray.length];
                stringArray2[0] = this.withttyPath.getAbsolutePath();
                stringArray2[1] = "sudo";
                stringArray2[2] = "WSM_INSTALL_SUDO_PROMPT";
                stringArray2[3] = "/bin/sh";
                stringArray2[4] = "-c";
                stringArray2[5] = this.sudoPath + " -K; " + this.sudoPath + " -p WSM_INSTALL_SUDO_PROMPT";
                for (n = 1; n <= stringArray.length; ++n) {
                    stringArray2[5] = stringArray2[5] + " $" + n;
                }
                stringArray2[6] = "sudo";
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[7 + n] = stringArray[n];
                }
                break;
            }
        }
        return ProcessRunner.run((char[])(this.getSuperuserPassword().passwordText + "\n").toCharArray(), processOutputAnalyzer, (String[])stringArray2);
    }

    public <ResultType> ResultType runMatlabCommand(File file, String string, File file2, ProcessOutputAnalyzer<ResultType> processOutputAnalyzer) throws IOException, ProcessExecutionException {
        return MacOSXMatlabRunner.get().run(file, string, file2, processOutputAnalyzer);
    }

    protected void setFileReadOnly(File file, boolean bl) throws IOException {
    }

    protected boolean verifySuperuserPassword(Controller.Password password) {
        return false;
    }
}

