/*
 * Decompiled with CFR 0.152.
 */
import installer.common.MatlabRunner;
import installer.common.ProcessExecutionException;
import installer.common.ProcessOutputAnalyzer;
import installer.common.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacOSXMatlabRunner
extends MatlabRunner {
    private static final MacOSXMatlabRunner runner = new MacOSXMatlabRunner();

    private MacOSXMatlabRunner() {
    }

    public static MacOSXMatlabRunner get() {
        return runner;
    }

    public void launch(File file, String string, File file2) throws IOException {
        File file3 = new File(new File(file, "bin"), "matlab");
        if (!file3.exists()) {
            throw new IOException("Expected MATLAB binary " + file3.getAbsolutePath() + " " + "does not exist");
        }
        String[] stringArray = new String[]{file3.getAbsolutePath(), "-desktop", "-r", string};
        Runtime.getRuntime().exec(stringArray, null, file2);
    }

    public <ResultType> ResultType run(File file, String string, File file2, ProcessOutputAnalyzer<ResultType> processOutputAnalyzer) throws IOException, ProcessExecutionException {
        Logger logger = Logger.getLogger("controller");
        File file3 = new File(new File(file, "bin"), "matlab");
        if (!file3.exists()) {
            throw new IOException("Expected MATLAB binary " + file3.getAbsolutePath() + " " + "does not exist");
        }
        Vector<String> vector = new Vector<String>();
        vector.add(file3.getAbsolutePath());
        vector.add("-nodesktop");
        vector.add("-nodisplay");
        vector.add("-nosplash");
        if (file2 != null) {
            vector.add("-logfile");
            vector.add(file2.getAbsolutePath());
        }
        vector.add("-r");
        vector.add(string);
        logger.info("Running MATLAB (" + file3.getAbsolutePath() + ") with " + (file2 != null ? "log file " + file2.getAbsolutePath() + " and " : "") + "command: " + string + " ...\n");
        ProcessRunner.Result result = ProcessRunner.run(processOutputAnalyzer, (String[])vector.toArray(new String[0]));
        logger.info("MATLAB finished running.\n");
        return (ResultType)result.outputResult;
    }
}

