/*
 * Decompiled with CFR 0.152.
 */
import installer.common.Controller;
import installer.common.InstallerGUI;
import installer.common.NoSuperuserPasswordException;
import installer.common.ProcessExecutionException;
import installer.common.ProcessOutputAnalyzer;
import installer.common.ProcessRunner;
import installer.common.ResourceNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeController
extends Controller {
    static final String nativeI386BinaryListFileName = "native-lib-files-i386.txt";
    static final String nativeAMD64BinaryListFileName = "native-lib-files-amd64.txt";
    static final String withttyAMD64NameFileName = "withtty-amd64-name.txt";
    static final String withttyI386NameFileName = "withtty-i386-name.txt";
    private String suPath = null;
    private String sudoPath = null;
    private String withttyName = null;
    private File withttyPath = null;
    private boolean nativeSpecificFilesCopied = false;

    protected void copyFile(File file, File file2) throws IOException, NoSuperuserPasswordException, ProcessExecutionException {
        String[] stringArray = new String[]{"/bin/cp", file.getAbsolutePath(), file2.getAbsolutePath()};
        ProcessRunner.Result result = ProcessRunner.run(null, (String[])stringArray);
        if (result.processReturnResult != 0) {
            this.logger.info("Tried to copy " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + ", but failed.\n");
            this.ensureSuperuserPasswordAvailable();
            result = this.runAsRoot(null, stringArray);
            if (result.processReturnResult != 0) {
                throw new IOException("Unable to copy " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + ", even as superuser (command return value was " + result.processReturnResult + ")");
            }
            this.logger.info("Copied " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + " successfully.\n");
        } else {
            this.logger.info("Copied " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + " successfully.\n");
        }
    }

    protected void copyNativeSpecificFilesFromPackageToHost(String string) throws IOException, ProcessExecutionException, ResourceNotFoundException {
        Set set;
        if (this.nativeSpecificFilesCopied) {
            return;
        }
        if (string.equals("i386")) {
            set = NativeController.getResourceNamesFromTextFileResource((String)withttyI386NameFileName);
        } else if (string.equals("amd64")) {
            set = NativeController.getResourceNamesFromTextFileResource((String)withttyAMD64NameFileName);
        } else {
            throw new IOException("unavailable arch. requested for withtty: " + string);
        }
        assert (set.size() == 1);
        this.withttyName = (String)set.iterator().next();
        this.withttyPath = new File(this.getActiveConfigDirectory(), NativeController.localizeRelativePath((String)this.withttyName));
        this.copyResourceToLocalFile(this.withttyName, this.withttyPath);
        this.makeFileExecutable(this.withttyPath);
        this.nativeSpecificFilesCopied = true;
    }

    private Set<File> findMatlabPaths() throws ProcessExecutionException {
        ProcessOutputAnalyzer.FirstLineOnly firstLineOnly = new ProcessOutputAnalyzer.FirstLineOnly((ProcessOutputAnalyzer)new ProcessOutputAnalyzer.LastLine());
        ProcessRunner.Result result = ProcessRunner.run((ProcessOutputAnalyzer)firstLineOnly, (String[])new String[]{"bash", "-c", "matlab -e | sed '/^MATLAB=\\(.*\\)$/s/^MATLAB=\\(.*\\)$/\\1/p;d'"});
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(new File((String)result.outputResult));
        return hashSet;
    }

    public Map<File, InstallerGUI.MatlabInstallation> findMatlabPathsAndVersions() {
        Set<File> set;
        HashMap<File, InstallerGUI.MatlabInstallation> hashMap = new HashMap<File, InstallerGUI.MatlabInstallation>();
        try {
            this.logger.info("Looking for MATLAB paths...\n");
            set = this.findMatlabPaths();
            this.logger.info("Done looking for MATLAB paths.\n");
        }
        catch (ProcessExecutionException processExecutionException) {
            this.logger.warning("Unable to find MATLAB paths: " + processExecutionException.getMessage() + "\n");
            return hashMap;
        }
        for (File file : set) {
            InstallerGUI.MatlabInstallation matlabInstallation = this.verifyMatlabPathAndGetVersion(file);
            if (matlabInstallation == null) {
                this.logger.severe("Unable to verify MATLAB installation in " + file.getAbsolutePath() + "\n");
                continue;
            }
            hashMap.put(file, matlabInstallation);
        }
        return hashMap;
    }

    protected boolean gatherPlatformDependentConfigurationInformation(List<String> list) {
        this.suPath = null;
        this.sudoPath = null;
        boolean bl = true;
        try {
            this.suPath = (String)ProcessRunner.run((ProcessOutputAnalyzer)new ProcessOutputAnalyzer.LastLine(), (String[])new String[]{"which", "su"}).outputResult;
        }
        catch (ProcessExecutionException processExecutionException) {
            bl = false;
            list.add("Unable to get location of su: " + processExecutionException.getMessage());
        }
        try {
            this.sudoPath = (String)ProcessRunner.run((ProcessOutputAnalyzer)new ProcessOutputAnalyzer.LastLine(), (String[])new String[]{"which", "sudo"}).outputResult;
        }
        catch (ProcessExecutionException processExecutionException) {
            bl = false;
            list.add("Unable to get location of sudo: " + processExecutionException.getMessage());
        }
        return bl;
    }

    protected File getMatlabUserpathGuess() {
        return new File(this.getUserHomeDirectory(), "matlab");
    }

    protected Set<String> getNativeBinaryFileNames(String string) throws IOException {
        if (string.equals("i386")) {
            return NativeController.getResourceNamesFromTextFileResource((String)nativeI386BinaryListFileName);
        }
        if (string.equals("amd64")) {
            return NativeController.getResourceNamesFromTextFileResource((String)nativeAMD64BinaryListFileName);
        }
        throw new IOException("Unsupported arch. libs. requested (this is a bug!)");
    }

    protected boolean isFileReadOnly(File file) throws IOException {
        return false;
    }

    protected boolean isSupportedArch(String string) {
        return string.equals("i386") || string.equals("amd64");
    }

    protected boolean isSupportedMatlabVersion(String string) {
        return true;
    }

    protected void launchMatlabWithCommand(File file, String string, File file2) throws IOException {
        LinuxMatlabRunner.get().launch(file, string, file2);
    }

    private void makeFileExecutable(File file) throws ProcessExecutionException {
        String[] stringArray = new String[]{"chmod", "+x", file.getAbsolutePath()};
        ProcessRunner.Result result = ProcessRunner.run(null, (String[])stringArray);
        if (result.processReturnResult != 0) {
            throw new ProcessExecutionException(stringArray, "chmod didn't return 0");
        }
    }

    private <OutputType> ProcessRunner.Result<OutputType> runAsRoot(ProcessOutputAnalyzer<OutputType> processOutputAnalyzer, String ... stringArray) throws ProcessExecutionException {
        String[] stringArray2 = null;
        if (!this.withttyPath.exists()) {
            this.withttyPath = new File(this.getActiveConfigDirectory(), this.withttyName);
        }
        switch (this.getSuperuserPassword().authenticationMethod) {
            case SU: {
                int n;
                stringArray2 = new String[7 + stringArray.length];
                stringArray2[0] = this.withttyPath.getAbsolutePath();
                stringArray2[1] = "su";
                stringArray2[2] = "DUMMY_PROMPT";
                stringArray2[3] = "/bin/sh";
                stringArray2[4] = "-c";
                stringArray2[5] = this.suPath + " -s /bin/sh -c \"";
                for (n = 1; n <= stringArray.length; ++n) {
                    stringArray2[5] = stringArray2[5] + " $" + n;
                }
                stringArray2[5] = stringArray2[5] + "\"";
                stringArray2[6] = "su";
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[7 + n] = stringArray[n];
                }
                break;
            }
            case SUDO: {
                int n;
                stringArray2 = new String[7 + stringArray.length];
                stringArray2[0] = this.withttyPath.getAbsolutePath();
                stringArray2[1] = "sudo";
                stringArray2[2] = "WSM_INSTALL_SUDO_PROMPT";
                stringArray2[3] = "/bin/sh";
                stringArray2[4] = "-c";
                stringArray2[5] = this.sudoPath + " -K; " + this.sudoPath + " -p WSM_INSTALL_SUDO_PROMPT";
                for (n = 1; n <= stringArray.length; ++n) {
                    stringArray2[5] = stringArray2[5] + " $" + n;
                }
                stringArray2[6] = "sudo";
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[7 + n] = stringArray[n];
                }
                break;
            }
        }
        return ProcessRunner.run((char[])this.getSuperuserPassword().passwordText, processOutputAnalyzer, (String[])stringArray2);
    }

    public <ResultType> ResultType runMatlabCommand(File file, String string, File file2, ProcessOutputAnalyzer<ResultType> processOutputAnalyzer) throws IOException, ProcessExecutionException {
        return LinuxMatlabRunner.get().run(file, string, file2, processOutputAnalyzer);
    }

    protected void setFileReadOnly(File file, boolean bl) throws IOException {
    }

    protected boolean verifySuperuserPassword(Controller.Password password) {
        switch (password.authenticationMethod) {
            case SU: {
                ProcessRunner.Result result;
                String[] stringArray = new String[]{this.withttyPath.getAbsolutePath(), "su", "DUMMY_PROMPT", this.suPath, "-s", "/bin/sh", "-c", "exit"};
                try {
                    result = ProcessRunner.run((char[])password.passwordText, null, (String[])stringArray);
                }
                catch (ProcessExecutionException processExecutionException) {
                    this.logger.severe("su (under withtty) failed to run properly: " + processExecutionException.getMessage() + "\n");
                    return false;
                }
                return result.processReturnResult == 0;
            }
            case SUDO: {
                ProcessRunner.Result result;
                String[] stringArray = new String[]{this.withttyPath.getAbsolutePath(), "sudo", "WSM_INSTALL_SUDO_PROMPT", "/bin/sh", "-c", this.sudoPath + " -K; " + this.sudoPath + " -p WSM_INSTALL_SUDO_PROMPT /bin/sh -c exit"};
                try {
                    result = ProcessRunner.run((char[])password.passwordText, null, (String[])stringArray);
                }
                catch (ProcessExecutionException processExecutionException) {
                    this.logger.severe("sudo (under withtty) failed to run properly: " + processExecutionException.getMessage() + "\n");
                    return false;
                }
                return result.processReturnResult == 0;
            }
        }
        return false;
    }
}

