%WRANN write annotations for WFDB records into annotation files
% function [] = wrann(annots, record, annotator)
% Given a column vector of annotations, write a new annotation file
% for a record.
%
% The annotation file is written locally, using the record name as
% the base of the file name, and the annotator name as the
% extension.
%
% Nothing is returned.
%
% Three required arguments:
% annots: a column-vector struct array holding the annotations to
%    write out; the format of the struct array should be exactly
%    the same as that returned by RDANN(), and is described further
%    below.
% record: the name of the record for which to write the annotation
%    file
% annotator: the name of the annotator; it is also the suffix of
%    the annotation file
%
% The annots struct array should have the following fields:
% timeInSeconds (number): the time of the annotation in seconds
% sampleNumber (uint): the time of the annotation in samples
% typeMnemonic (string): the mnemonic for the type of the annotation
% subtype (uint8): the annotation's subtyp field
% chan (uint8): the annotation's chan field
% num (uint8): the annotation's num field
% auxInfo (string): a string of auxiliary information for the annotation
%
% Note that, in addition to the type restrictions given in
% parentheses above, the following restriction applies: auxInfo
% should not exceed 127 characters in length.
%
% Examples
%
%    % just get some existing annotations
%    a = rdann('mitdb/100', 'atr');
%
%    % write annotations for the record 'mitdb/100', to the local
%    % annotation file mitdb/100.atr2 
%    wrann(a, 'mitdb/100', 'atr2');
%
%    % write annotations for the record '101', to the local
%    % annotation file 101.dupatr
%    wrann(a, '101', 'dupatr');
%
% See also RDANN, WFDB_LICENSE wrann(1) man page
%
% Copyright (c) 2009 by Michael Craig, All Rights Reserved
% Contact M. Craig (mic@mit.edu)
%

% Modified by Ikaro Silva, 6/2012 

%
% FIXME: need to verify that the fields of annots are typed
%        properly (e.g. subtype, chan, and num fit properly in
%        bytes).
%
% FIXME: the length of auxInfo definitely also needs to be checked:
%        i don't see it documented anywhere, but it cannot exceed 127.


%
LoadWFDBJava.load;
wfdb.wfdb.wfdbquit;

%
%
wrannMatlab.wrann(struct2javaarray(annots, 'Annotation'), ...
                  record, ...
                  annotator);

