function [varargout] = wfdb_config
%[lib_version, libs, cflags] = wfdb_config
%
% WFDB_CONFIG returns version and compilation information about the WFDB Toolbox,
% and the WFDB library version and configuration information.
%
% Four values are returned, as strings: the version of the WFDB MATLAB
% Toolbox the version of the WFDB library used (the native library, 
% underneath the MATLAB and Java code); the linker information that would 
% be needed to link against the library; and the "cflags," the options needed to
% compile code that uses this library.
%
%
% It is fairly unlikely that anything aside from the version string
% would be used here, within MATLAB.
%
% See also wfdb-config(1), WFDB_LICENSE, WFDBUPDATE

%   Copyright 2009-2011 PhysioNet written by Michael Craig
%   modified by Ikaro  Silva 2011
%   $Revision: 1.0 $  $Date: 2011/11/1 $


%
%
LoadWFDBJava.load;
wfdb.wfdb.wfdbquit;

%
%
lib_version = char(wfdb.wfdb.wfdbversion);
libs =    char(wfdb.wfdb.wfdbldflags);
cflags =  char(wfdb.wfdb.wfdbcflags);
out={lib_version,libs,cflags};
varargout(1:nargout)=out(1:nargout); 
