function [s] = time2sec(time, varargin)
%TIME2SEC convert WFDB-format time intervals into seconds
% Convert a time-format string into number of seconds.
%
% If the given time-format string is enclosed in brackets (e.g. as
% '[9:0:0]') and if a record is given (as an optional argument),
% then the value returned is the elapsed time in seconds from the
% beginning of that record.
%
% One required argument:
% time: the time-format string indicating the time to convert
%
% One optional argument:
% 'record' (string): the record on which to base the conversion, if
%    time-of-day conversion is requested, as described above.
%
% Examples
% 
%    % convert '00:05:00'; returns 300
%    time2sec('00:05:00')
%
%    % convert 9:00 am into elapsed time from the beginning of the
%    % record 'mitdb/100'
%    time2sec('[09:00:00]', 'record', 'mitdb/100')
%
%	See also WFDB_LICENSE
%    
% Copyright (c) 2009 by Michael Craig, All Rights Reserved
% Contact M. Craig (mic@mit.edu)

% Modified by Ikaro Silva, 6/2012 

% FIXME: it makes more sense for the user NOT to use varargin2struct +
%        verify_params here.

% FIXME: test this further!
%

% FIXMEFIXME: give better examples in the help docs! (use a better record)
%

%
LoadWFDBJava.load;
wfdb.wfdb.wfdbquit;

%
argsInfo = struct('record', { {[]}, '1', 'string' });

p = varargin2struct(varargin, argsInfo(1), argsInfo(2));
verify_params(p, argsInfo(2:3));

%
s = time2secMatlab.time2sec(time, p.record{1});

