function [fp] = wfdbwhich(varargin)
%WFDBWHICH find the location of files belonging to WFDB records
% function [fp] = wfdbwhich(filename, 'record', substRecord)
% function [fp] = wfdbwhich(filetype, record)
% Search the WFDB path for the file with a specific file name,
% or for the file with a given file type in a given record.
%
% WFDBWHICH() may be called in three ways. WFDBWHICH(filename)
% searches the WFDB path and returns the full location of the
% filename, if it is found. WFDBWHICH(filetype, record) searches
% for a file that has the extension given by filetype (a string),
% in the given record. WFDBWHICH(filename, 'record', substRecord)
% can be used when the WFDB path (accessible by getenv('WFDB'))
% contains the string '%r', in which case it behaves like
% WFDBWHICH(filename) except that it substitutes substRecord for
% '%r' in the path.
%
% For any of the three cases, if a path is not found, null ([]) is
% returned.
%
% Bugs
%
%   The man page seems to indicate the existence of a fourth type
%   of call, in which a file type, a record by which to look for
%   it, and a substitute record are all given; but the original
%   wfdbwhich command does not actually support this call, so it is
%   not supported here, either.
%
% Examples
%
%    % find the file named '100.dat'
%    fp = wfdbwhich('100.dat')
%
%    fp =
%
%    http://physionet.org/physiobank/database/mitdb/100.dat
%
%
%
%    % find the file of type 'hea' (header), in the
%    % record 'mitdb/100'
%    fp = wfdbwhich('hea', 'mitdb/100')
%
%    fp =
%
%    http://physionet.org/physiobank/database/mitdb/100.hea
%
%
%
% See also wfdbwhich(1) man page
%
% Copyright (c) 2009 by Michael Craig, All Rights Reserved
% Contact M. Craig (mic@mit.edu)
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
%    02111-1307  USA
%
% wfdbwhich.m and its dependencies are freely available from Physionet -
% http://www.physionet.org/ - please report any bugs to the authors above.

% FIXME: include an example using '%r'
%

% FIXME: i'm not a big fan of this calling convention, i just don't
%        see a better way of doing it right now. should it use
%        varargin2struct, at the risk of making relatively simple
%        calls more verbose? or a mixture?


%
%
fp = [];

%
LoadWFFDBJava.load;
wfdb.wfdb.wfdbquit;

%
%
switch length(varargin)
  case 1
    fp = deepconvert(wfdbwhichMatlab.wfdbwhichWithSubst(varargin{1}, []));
  case 2
    fp = deepconvert(wfdbwhichMatlab.wfdbwhich(varargin{1}, varargin{2}));
  case 3
    if varargin{2} ~= 'record'
      error('wfdbSwigMatlab:wfdbwhich:invalid_args', ...
            ['Three args. were passed, so the second one should' ...
             ' have been "-r", but it was not']);
    end
    fp = deepconvert(wfdbwhichMatlab.wfdbwhichWithSubst(varargin{1}, varargin{3}));
  otherwise
    error('wfdbSwigMatlab:wfdbwhich:invalid_args', ...
          'Either too few or too many arguments were passed');
end
