function [s] = time2sec(time, varargin)
%TIME2SEC convert WFDB-format time intervals into seconds
% Convert a time-format string into number of seconds.
%
% If the given time-format string is enclosed in brackets (e.g. as
% '[9:0:0]') and if a record is given (as an optional argument),
% then the value returned is the elapsed time in seconds from the
% beginning of that record.
%
% One required argument:
% time: the time-format string indicating the time to convert
%
% One optional argument:
% 'record' (string): the record on which to base the conversion, if
%    time-of-day conversion is requested, as described above.
%
% Examples
% 
%    % convert '00:05:00'; returns 300
%    time2sec('00:05:00')
%
%    % convert 9:00 am into elapsed time from the beginning of the
%    % record 'mitdb/100'
%    time2sec('[09:00:00]', 'record', 'mitdb/100')
%
% Copyright (c) 2009 by Michael Craig, All Rights Reserved
% Contact M. Craig (mic@mit.edu)
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
%    02111-1307  USA
%
% time2sec.m and its dependencies are freely available from Physionet -
% http://www.physionet.org/ - please report any bugs to the authors above.

% FIXME: it makes more sense for the user NOT to use varargin2struct +
%        verify_params here.

% FIXME: test this further!
%

% FIXMEFIXME: give better examples in the help docs! (use a better record)
%

%
LoadWFDBJava.load;
wfdb.wfdb.wfdbquit;

%
argsInfo = struct('record', { {[]}, '1', 'string' });

p = varargin2struct(varargin, argsInfo(1), argsInfo(2));
verify_params(p, argsInfo(2:3));

%
s = time2secMatlab.time2sec(time, p.record{1});

