%TEST_WFDB test WFD installation
% function [success] = test_wfdb
% This is a simple function to test that the WFDB-SWIG-MATLAB package was
% properly installed. Returns 1 on success, 0 on failure.
%
% Copyright (c) 2009 by Michael Craig, All Rights Reserved
% Contact M. Craig (mic@mit.edu)
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
%    02111-1307  USA
%
% test_wfdb.m and its dependencies are freely available from Physionet -
% http://www.physionet.org/ - please report any bugs to the authors above.

%
success = 0;

try

  %
  data = rdsamp('mitdb/101', 'begin', '00:00:20', 'maxt', ...
      '00:00:10');
  
  %
  crc32 = java.util.zip.CRC32;
  for i=1:size(data,1)
    crc32.update(data(i,1));
    crc32.update(data(i,2));
    crc32.update(data(i,3));
  end
  
  if uint32(crc32.getValue) == 1801886120
    success = 1;
  else
    success = 0;
  end

catch
  
  success = 0;
  
end

% fprintf(1, '%d\n', success);



