// wfdb2txt.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "../wfdbwrapper/WFDBLib/wfdb.h"
#include "../wfdbwrapper/WFDBLib/wfdblib.h"

void ConvertDataFile(const char *fname);
void ConvertAnnFile(const char *fname);
extern string Extension(const char *strECGFileName);

int _tmain(int argc, _TCHAR* argv[])
{
  if (argc != 2)
  {
    std::cout << "wfdb2txt converts WFDB data and annotation files into text\n";
    std::cout << "wfdb2txt expects exactly one parameter - filename with path\n";
    std::cout << "wfdb2txt treats all .dat files as WFDB data files and all other extensions as WFDB annotation files";
    return 0;
  }

  TCHAR CurDir[MAX_PATH];
  ::GetCurrentDirectory(MAX_PATH, CurDir);

  wfdb_addtopath(CurDir);                

  TCHAR fname[MAX_PATH];
  strcpy_s(fname, MAX_PATH, argv[1]);

  string ext = Extension(fname);

  if (ext == "dat")
    ConvertDataFile(fname);
  else
    ConvertAnnFile(fname);

  return 0;
}

extern void OpenRecord(const char *FileName, long *freq, 
                      vector<string> *signames, long *pnTotPnt);
extern void LoadData(int nFirstPnt, int nPoints, double **pvData);


void ConvertDataFile(const char *fname)
{
  vector<string> signames;
  long freq;
  long nTotPnt;
  OpenRecord(fname, &freq, &signames, &nTotPnt);

  //  write generic information
  string s(fname);                    
  size_t iE = s.find_last_of('.');
  string sFileNameOut = s.substr(0, iE) + ".txt";

  FILE *f;
  fopen_s(&f, sFileNameOut.c_str(), "w");
  fprintf(f, "frequency is %d Hz, values are in mcV\n", freq);
  for (unsigned k = 0; k < signames.size(); k++)
    fprintf(f, "%s\t", signames[k].c_str());
  fprintf(f, "\n");

  //  read and write data
  const int portion = 1000;
  double vData[WFDB_MAXSIG][portion];
  double *pvData[WFDB_MAXSIG];
  for (int i = 0; i < WFDB_MAXSIG; i++)
    pvData[i] = vData[i];

  for(long i = 0; i <= (nTotPnt - 1) / portion; i++)
  {
    int len = min(portion, nTotPnt - i * portion);
    LoadData(i * portion, len, pvData);
    for (int j = 0; j < len; j++)
    {
      for (unsigned k = 0; k < signames.size(); k++)
        fprintf(f, "%.2f\t", vData[k][j]);
      fprintf(f, "\n");
    }
  }

  fclose(f);
  wfdbquit();

  std::cout << "Successfully converted to " << sFileNameOut << "\n";
}

extern string RecordName(const char *FileName);
void ConvertAnnFile(const char *fname)
{
  //	add file path to db path
  wfdbquit();
  wfdb_addtopath(fname);

  WFDB_Anninfo anninfo;
  string ext = Extension(fname);
  anninfo.name = ext.c_str();
  anninfo.stat = WFDB_READ;

  string record = RecordName(fname);
  if (annopen(record.c_str(), &anninfo, 1) < 0)
  {
    cout << "Can't open annotation file";
    exit(0);
  }

  string s(fname);                    
  size_t iE = s.find_last_of('.');
  string sFileNameOut = s.substr(0, iE) + "_" + s.substr(iE + 1) + ".txt";
  FILE *f;
  fopen_s(&f, sFileNameOut.c_str(), "w");

  fprintf(f, "time\tanntyp\tsubtyp\tchan\tnum\taux\n");

  WFDB_Annotation ann;
  const char *empty = "";
  while (getann(0, &ann) == 0)                    
    fprintf(f, "%d\t%d\t%d\t%d\t%d\t%s\n", ann.time, ann.anntyp, ann.subtyp, ann.chan, ann.num, 
    ann.aux ? ann.aux : empty);
 
  fclose(f);
  wfdbquit();

  std::cout << "Successfully converted to " << sFileNameOut << "\n";
}