#include "StdAfx.h"

#include "..\wfdbwrapper\WFDBlib\wfdblib.h"
#include "..\wfdbwrapper\WFDBlib\wfdb.h"

enum { RET_OK = 0, RET_UNKNOWNTYPE = -1, RET_OPEN = -2, RET_READ = -3, RET_BADFILE = -4, RET_NOCOPY_HEAD = -5 };


string RecordName(const char *FileName)
//	get record name - no path, no extension
{
  string s(FileName);

  size_t iS = s.find_last_of('\\');
  size_t iE = s.find_last_of('.');
  string ss = s.substr(iS + 1, iE - iS - 1);
  return ss;
}

string Extension(const char *strECGFileName)
{
  string s(strECGFileName);
  size_t iE = s.find_last_of('.');
  return s.substr(iE + 1);
}

vector<WFDB_Siginfo> vsinfo;

void OpenRecord(const char *FileName, long *freq, 
                                                vector<string> *signames, long *pnTotPnt)
{
  //	add file path to db path
  wfdbquit();
  wfdb_addtopath(FileName);

  string record = RecordName(FileName);

  *freq = (long)sampfreq(record.c_str());
  //	open signal file
  int nsig = isigopen(record.c_str(), 0, 0);
  if (nsig <= 0)
  {
    cout << "Can't open data file";
    exit(0);
  }
  vsinfo.resize(nsig);
  isigopen(record.c_str(), &vsinfo[0], nsig);

  signames->resize(nsig);
  for (int i = 0; i < nsig; i++)
    (*signames)[i].assign(vsinfo[i].desc);      

  *pnTotPnt = vsinfo.front().nsamp;
}

void LoadData(int nFirstPnt, int nPoints, double **pvData)
{
  LONG pnt = vsinfo.front().nsamp;
  //	fill in the points with correct indices
  int nStart = max(0, nFirstPnt);
  int nEnd = min(pnt, nFirstPnt + nPoints);

	vector<WFDB_Sample> vSmp(vsinfo.size());
  
	//	Read data
	if (isigsettime(nStart) < 0)
		return;
	for (int i = nStart; i < nEnd; i++)
	{
		if (getvec(&vSmp[0]) < 0)
			return;
    for (unsigned nChan = 0; nChan < vsinfo.size(); nChan++)
      pvData[nChan][i - nFirstPnt] = vSmp[nChan] * 1000./ vsinfo[nChan].gain;
	}
}
