function DrawAltSeries
% DrawAltSeries.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Draws the alternant series (subplot 3)

    global lead QRSRelInd TimePoint graph TWARes Param Align

    subplot(graph(3)); cla

    if (isempty(TWARes) || ~Align.validleads(lead))
        return;
    end;

    global Param
    color = {'b', 'g', 'r'};
    leg = cellstr({});

    % Plot the alternant series for lomb if present
    if ~isempty(strfind(Param.MethodForEctopy, 'lomb'))
        leg{length(leg) + 1} = 'lomb'; 

        subplot(graph(3)); 
        plot(TWARes.lomb.at_lead(lead).times, TWARes.lomb.at_lead(lead).series(:, TimePoint) - TWARes.lomb.at_lead(lead).series(1, TimePoint), ...
            color{length(leg)}); hold on;        
    end;
    
    % Plot the alternant series for others if present
    names = cellstr({'standard', 'differences'});
    for i = 1:length(names)
        if ~isempty(strfind(Param.MethodForEctopy, names{i}))
            leg{length(leg) + 1} = names{i};
            subplot(graph(3)); 
            if (i == 2)
                sub = 0;
            else
                sub = TWARes.(names{i}).at_lead(lead).series(1, TimePoint);
            end;
            plot(TWARes.(names{i}).at_lead(lead).series(:, TimePoint) - sub, color{length(leg)}); hold on;
        end;
    end;

    % draw cursor
    subplot(graph(3))
    hold on;
    global hAltS QRSRelInd
    if (ishandle(hAltS))
        delete(hAltS);
    end;
    x = QRSRelInd + 1;
    hAltS = plot([x x], get(gca, 'YLim'), 'k');
    hold off;
    
    % draw labels
    subplot(graph(3))
    legend(leg);
    ylabel(['amplitude']); title('Alternan Series'); hold off;

return;
