function DisplaySignal
% DisplaySignal.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Read data from a file and display it

    close all;
    clear all;

    global record

    [fname, pathname] = uigetfile('*.*');
    if ~fname
        return;
    end;
    record = fname(1:strfind(fname, '.') - 1);
    
    Annotator = 'vf';
    if (~exist(strcat(record, '.', Annotator),'file'))      
        Annotator = 'pu';
    end;

    readsignalfromwfdb(record, Annotator);

   
    global lead
    lead = 1;
    
    BuildInterfaceSpectral(0, 0, 0);

    global recordbtn record
    set(recordbtn, 'String', record);

    DrawECG;
    
return;
    
