function [ecg, freq] = ConvertAndReadECG(fname)

fname = deblank(fname);

ecg = [];
freq = [];

w2tpath = FindFile('wfdb2txt.exe');
if isempty(w2tpath)
    return;
end;

remove = false;
if strcmp(fname(end - 3: end), '.dat')
    ss = sprintf('%s %s', w2tpath, fname);
    disp(ss);
    system(ss);
    fname = strrep(fname, '.dat', '.txt');
    remove = true;
end;

disp(' ');

f = fopen(fname);
if f == -1
    disp(['Couldn''t convert data file to .txt. Be sure to move files to a location that doesn''t' ...
    ' contain spaces, dots, non-english characters, etc.']);
    return;
end;

freq = fscanf(f, 'frequency is %d Hz, values are in mcV\n');

s = fgets(f);
s = fgets(f);
[pt, nChan] = sscanf(s, '%f ');
ecg = fscanf(f, '%f ', [nChan inf])';


fclose(f);
if remove
    system(sprintf('del %s', fname));
end;
return;