function ann = ConvertAndReadAnn(fname)

fname = deblank(fname);
ann = [];

w2tpath = FindFile('wfdb2txt.exe');
if isempty(w2tpath)
    return;
end;

remove = false;
if ~strcmp(fname(end - 3: end), '.txt')
    k = findstr(fname, '.');
    ss = sprintf('%s %s', w2tpath, fname);
    disp(ss);
    system(ss);
    fname = [fname(1:k(length(k)) - 1) '_' fname(k(length(k)) + 1:end) '.txt'];
    remove = true;
end;
disp(' ');

f = fopen(fname);
if (f == -1)
    disp(['Couldn''t convert annotation file to .txt. Be sure to move files to a location that doesn''t' ...
    ' contain spaces, dots, non-english characters, etc.']);
    return;
end;

for i = 1:6
    titles{i} = fscanf(f, ' %s', 1);
end;

s = fgets(f);
s = fgets(f);
ann = struct(titles{1}, 0, titles{2}, 0, titles{3}, 0, titles{4}, 0, titles{5}, 0, titles{6}, '');

ind = 1;
while s ~= -1
    for i = 1:5
        [v, s] = strtok(s);
        ann(ind).(titles{i}) = str2num(v);
    end;
    if ~isempty(s)
        ann(ind).(titles{6}) = strtok(s);
    end;

    s = fgets(f);
    ind = ind + 1;
end;

fclose(f);
if remove
    system(sprintf('del %s', fname));
end;

return;