function BuildInterfaceMMA(ECGCallb, TrendCallb)
% BuildInterfaceMMA.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Contructs interface to view MMA analysis
    global graph;

    f = figure('Units','normalized','Position',[0.05 0.3 0.9 0.65]);
        
    graph(1) = subplot('Position',[0.05 0.52 0.91 0.43]);

    
    graph(2) = subplot('Position',[0.05 0.05 0.19 0.4]);
    graph(3) = subplot('Position',[0.29 0.05 0.19 0.4]);
    graph(4) = subplot('Position',[0.53 0.05 0.19 0.4]);
    graph(5) = subplot('Position',[0.77 0.05 0.19 0.4]);

    set(f, 'WindowButtonDownFcn', {@BtnDownCallback, graph, ECGCallb, TrendCallb})
    
    global stext;
    stext = uicontrol('Style', 'text', 'Units', 'normalized', 'Position',[0.05 0.95 0.9 0.05], ...
      'String','');
  
    global lead
    leadbtn = uicontrol('Style', 'pushbutton', 'Units', 'normalized', 'Position',[0.91 0.96 0.05 0.04], ...
        'String', ['lead is ' num2str(lead)], 'Callback', 'LeadBtnCallback');
    global record recordbtn
    recordbtn = uicontrol('Style', 'pushbutton', 'Units', 'normalized', 'Position',[0.70 0.96 0.2 0.04], ...
        'String',record, 'Callback', 'DoTWAbyMMA');

    set(gcf, 'Toolbar', 'figure');
    
return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function BtnDownCallback(obj, eventdata, graph, ECGCallb, TrendCallb)

    if (gca == graph(1))
        feval(ECGCallb);
    elseif (gca == graph(3))
        feval(TrendCallb);
    end;    
return;