function DrawVAltTrend
% DrawVAltTrend.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Draws the trend of MMA alternans values

    global graph TWARes lead

if (~TWARes.successfull)
    return;
end;

    subplot(graph(3));
    
    plot(TWARes.VAltTrend(:, lead));

    hold on;

    SetAxisLimits;
    
    %%%%%%%%%%%%% cursor
    global hTrend
    if (ishandle(hTrend))
        delete(hTrend);
    end;    
    global CurResIndex
    hTrend = plot([CurResIndex CurResIndex], get(gca, 'YLim'), 'k');
    hold off;
    
return;

function SetAxisLimits
    global TWARes lead
    set(gca, 'XLim', [-1 size(TWARes.VAltTrend, 1) + 1]);
    yl = get(gca, 'YLim');
    set(gca, 'YLim', [-0.1 * max(TWARes.VAltTrend(:, lead)) yl(2)]);
return;
