function DrawECG
% DrawECG.m
% Author: Alexander Khaustov; alexander dot khaustov at gmail dot com 
% Copyright (C) 2008 St.-Petersburg Institute of Cardiological Technics (Incart), www.incart.ru
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).
% 
% Draws the graphs associated with the ECG data (subplot 1), and
% the corresponding landmarks; q, s, Tend and fiducial points

    global graph
    subplot(graph(1));

    global ecg q s tend Align lead Param
    
    SaveAxisLimits;

    plot(ecg(:, lead)); hold on;
    amp = zeros(1,length(q));
    for i=1:length(q)
        amp(i) = (max(ecg(q(i):s(i))) - min(ecg(q(i):s(i)))) / 5;
        plot([s(i) s(i)], [ecg(s(i), lead) - amp(i), ecg(s(i), lead) + amp(i)], 'k');
        plot([q(i) q(i)], [ecg(q(i), lead) - amp(i) / 2, ecg(q(i), lead) + amp(i) / 2], 'k');
    end;
    if ~isempty(Align)
%       for i=1:min([length(Align.fidBase), length(amp)])
%             plot([Align.fidBase(i) Align.fidBase(i)], [ecg(Align.fidBase(i), lead) - amp(i), ecg(Align.fidBase(i), lead) + amp(i)], 'g');
%       end;
        for i=1:min([length(amp), length(Align.fid)])
            if (Align.fid(i))
                plot([Align.fid(i) Align.fid(i)], [ecg(Align.fid(i), lead) - amp(i), ecg(Align.fid(i), lead) + amp(i)], 'm');
            end;
        end;
    end;
    
    for i=1:min(length(tend), length(amp))
        plot([tend(i) tend(i)], [ecg(tend(i), lead) - amp(i), ecg(tend(i), lead) + amp(i)], 'r');
    end;
    
    if ~isempty(Param)
        if (strcmp(Param.Metric, 'MMA'))
            global CurResIndex q s TWARes
            qrs = TWARes.res(CurResIndex).StartQRSInd;
            x = (q(qrs) + s(qrs)) / 2;
        else
            global StartQRSInd QRSRelInd s
            x = s(StartQRSInd + QRSRelInd);
        end;
        global hecg;
        if (ishandle(hecg))
            delete(hecg);
        end;
        hecg = plot([x x], get(gca, 'YLim'), 'k');
    end;
        

    ylabel('amplitude (mCV)')

    hold off;
    
    RestoreAxisLimits;
	
return;
