/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.theme;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.properties.WindowBarProperties;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.gui.colorprovider.ColorMultiplier;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.tabbedpanel.border.OpenContentBorder;
import net.infonode.tabbedpanel.border.TabAreaLineBorder;
import net.infonode.tabbedpanel.theme.GradientTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class GradientDockingTheme
extends DockingWindowsTheme {
    private boolean opaqueTabArea;
    private boolean shadowEnabled;
    private boolean highlightedBold;
    private boolean focusHighlighterEnabled;
    private Color borderColor;
    private Color tabAreaBackgroundColor;
    private RootWindowProperties rootProperties;

    public GradientDockingTheme() {
        this(true, true, false, true);
    }

    public GradientDockingTheme(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(bl, bl2, bl3, bl4, Color.BLACK);
    }

    public GradientDockingTheme(boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color) {
        this(bl, bl2, bl3, bl4, color, GradientTheme.DEFAULT_TAB_AREA_BACKGROUND_COLOR);
    }

    public GradientDockingTheme(boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color, Color color2) {
        this.opaqueTabArea = bl;
        this.shadowEnabled = bl2;
        this.highlightedBold = bl3;
        this.focusHighlighterEnabled = bl4;
        this.borderColor = color;
        this.tabAreaBackgroundColor = color2;
        GradientTheme gradientTheme = new GradientTheme(bl, bl2, color);
        this.rootProperties = new RootWindowProperties();
        this.createRootWindowProperties(gradientTheme);
        this.createWindowBarProperties(gradientTheme);
    }

    private void createRootWindowProperties(GradientTheme gradientTheme) {
        this.rootProperties.getTabWindowProperties().getTabbedPanelProperties().addSuperObject(gradientTheme.getTabbedPanelProperties());
        this.rootProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().addSuperObject(gradientTheme.getTitledTabProperties());
        this.rootProperties.getTabWindowProperties().getCloseButtonProperties().setVisible(false);
        if (!this.shadowEnabled) {
            this.rootProperties.getWindowAreaProperties().setInsets(new Insets(6, 6, 6, 6));
        }
        this.rootProperties.getWindowAreaShapedPanelProperties().setComponentPainter(new GradientComponentPainter(UIManagerColorProvider.DESKTOP_BACKGROUND, new ColorMultiplier(UIManagerColorProvider.DESKTOP_BACKGROUND, 0.9f), new ColorMultiplier(UIManagerColorProvider.DESKTOP_BACKGROUND, 0.9f), new ColorMultiplier(UIManagerColorProvider.DESKTOP_BACKGROUND, 0.8f)));
        this.rootProperties.getWindowAreaProperties().setBorder(new LineBorder(Color.BLACK));
        if (this.tabAreaBackgroundColor != null) {
            this.rootProperties.getComponentProperties().setBackgroundColor(this.tabAreaBackgroundColor);
        }
        if (!this.shadowEnabled) {
            this.rootProperties.getSplitWindowProperties().setDividerSize(6);
        }
        TitledTabProperties titledTabProperties = this.rootProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties();
        titledTabProperties.getNormalProperties().setIconVisible(false);
        titledTabProperties.getHighlightedProperties().setIconVisible(true);
        if (!this.highlightedBold) {
            titledTabProperties.getHighlightedProperties().getComponentProperties().getMap().createRelativeRef(ComponentProperties.FONT, titledTabProperties.getNormalProperties().getComponentProperties().getMap(), ComponentProperties.FONT);
        }
        if (this.focusHighlighterEnabled) {
            titledTabProperties.getHighlightedProperties().getComponentProperties().setBorder(new CompoundBorder(this.opaqueTabArea ? new TabAreaLineBorder(false, false, true, true) : new TabAreaLineBorder(this.borderColor), gradientTheme.getTabAreaComponentsGradientBorder()));
            this.rootProperties.getTabWindowProperties().getTabProperties().getFocusedProperties().getComponentProperties().setBorder(new CompoundBorder(this.opaqueTabArea ? new TabAreaLineBorder(false, false, true, true) : new TabAreaLineBorder(this.borderColor), gradientTheme.getHighlightedTabGradientBorder()));
        }
        this.rootProperties.getTabWindowProperties().getTabbedPanelProperties().getTabAreaComponentsProperties().getComponentProperties().setInsets(this.opaqueTabArea ? new Insets(0, 3, 0, 3) : new Insets(1, 3, 1, 3));
        this.rootProperties.getTabWindowProperties().getTabProperties().getHighlightedButtonProperties().getCloseButtonProperties().setVisible(false);
        this.rootProperties.getTabWindowProperties().getTabProperties().getHighlightedButtonProperties().getMinimizeButtonProperties().setVisible(true);
        this.rootProperties.getTabWindowProperties().getTabProperties().getHighlightedButtonProperties().getRestoreButtonProperties().setVisible(true);
    }

    private void createWindowBarProperties(GradientTheme gradientTheme) {
        WindowBarProperties windowBarProperties = this.rootProperties.getWindowBarProperties();
        windowBarProperties.getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getComponentProperties().setBorder(new OpenContentBorder(Color.BLACK, 1));
        windowBarProperties.getTabWindowProperties().getTabProperties().getNormalButtonProperties().getCloseButtonProperties().setVisible(false);
        windowBarProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().getNormalProperties().setIconVisible(true).getComponentProperties().setBorder(new CompoundBorder(new TabAreaLineBorder(), gradientTheme.getTabAreaComponentsGradientBorder()));
        windowBarProperties.getTabWindowProperties().getTabProperties().getFocusedProperties().getComponentProperties().setBorder(new CompoundBorder(new TabAreaLineBorder(Color.BLACK), gradientTheme.getHighlightedTabGradientBorder()));
        windowBarProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().getHighlightedProperties().getComponentProperties().setBorder(new CompoundBorder(new TabAreaLineBorder(Color.BLACK), gradientTheme.getHighlightedTabGradientBorder()));
        windowBarProperties.getTabWindowProperties().getTabbedPanelProperties().setTabSpacing(-1);
        windowBarProperties.getTabWindowProperties().getTabbedPanelProperties().getTabAreaProperties().getComponentProperties().setBorder(null).setBackgroundColor(null);
    }

    public String getName() {
        String string = (this.opaqueTabArea ? "" : "Transparent Tab Area, ") + (this.shadowEnabled ? "" : "No Shadow, ") + (this.focusHighlighterEnabled ? "" : "No Focus Highlight, ") + (this.highlightedBold ? "Highlighted Bold, " : "");
        return "Gradient Theme" + (string.length() > 0 ? " - " + string.substring(0, string.length() - 2) : "");
    }

    public RootWindowProperties getRootWindowProperties() {
        return this.rootProperties;
    }
}

