/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.Parameter;
import edu.mit.lcp.ParameterPanel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterTableModel
extends AbstractTableModel {
    private static final int COL_NAME = 0;
    public static final int COL_VALUE = 1;
    private static final int COL_UNITS = 2;
    private static final int COL_SELECTED = 3;
    private static final String[] columnNames = new String[]{"Name", "Value", "Units", "Select"};
    private List<Parameter> parameterList;
    private Hashtable<Parameter, Boolean> parametersSelected;
    private List<Parameter> displayList;
    public List<Parameter> highlightList;
    private String _categoryFilter;
    private String _typeFilter;
    private ParameterPanel _parent;
    public int centerRow;

    public ParameterTableModel(List list, ParameterPanel parameterPanel) {
        this._parent = parameterPanel;
        this.parameterList = list;
        this.displayList = new ArrayList<Parameter>(this.parameterList);
        this.highlightList = new ArrayList<Parameter>();
        this.parametersSelected = new Hashtable();
        for (Parameter parameter : this.parameterList) {
            this.parametersSelected.put(parameter, new Boolean(false));
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.displayList.size();
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object;
        switch (n2) {
            case 0: {
                object = this.displayList.get(n).getName();
                break;
            }
            case 1: {
                if (this._parent.getDisplayMode().equals("Default")) {
                    object = this.displayList.get(n).getValue().toString();
                    break;
                }
                object = this.displayList.get(n).getPercent().toString();
                break;
            }
            case 2: {
                if (this._parent.getDisplayMode().equals("Default")) {
                    object = this.displayList.get(n).getUnits();
                    break;
                }
                object = "%";
                break;
            }
            case 3: {
                object = this.isParameterSelected(this.displayList.get(n));
                break;
            }
            default: {
                object = new String("Invalid Column Lookup");
            }
        }
        return object;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1 || n2 == 3;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            try {
                if (this._parent.getDisplayMode().equals("Default")) {
                    this.displayList.get(n).setValue(Double.valueOf(object.toString()));
                } else if (this._parent.getDisplayMode().equals("Patient")) {
                    this.displayList.get(n).setPercent(Double.valueOf(object.toString()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n2 == 3) {
            this.setParameterSelected(this.displayList.get(n), (Boolean)object);
        }
        this.fireTableCellUpdated(n, n2);
    }

    public void setCategoryFilter(String string) {
        this._categoryFilter = string;
        this.highlightList.clear();
        this.updateDisplayList();
    }

    public void setTypeFilter(String string) {
        this._typeFilter = string;
        this.highlightList.clear();
        this.updateDisplayList();
    }

    public void updateDisplayList() {
        System.out.println("updateDisplayList(): category: " + this._categoryFilter + " -- type: " + this._typeFilter);
        this.displayList.clear();
        for (Parameter parameter : this.parameterList) {
            if (this._categoryFilter != null && !this._categoryFilter.equals(parameter.getCategory()) || this._typeFilter != null && !this._typeFilter.equals(parameter.getType())) continue;
            this.displayList.add(parameter);
        }
        this.fireTableDataChanged();
    }

    public int updateHighlightList(String string) {
        this.centerRow = 1;
        this.highlightList.clear();
        if (string != null) {
            for (Parameter parameter : this.parameterList) {
                if (!string.equals(parameter.getCategory())) continue;
                this.highlightList.add(parameter);
            }
            this.centerRow = this.displayList.indexOf(this.highlightList.get(this.highlightList.size() / 2));
        }
        this.fireTableDataChanged();
        return this.centerRow;
    }

    public List<String> getCategoryNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter parameter : this.parameterList) {
            String string = parameter.getCategory();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getParameterTypeNames() {
        return this.getFilteredParameterTypeNames(null);
    }

    public List<String> getFilteredParameterTypeNames() {
        return this.getFilteredParameterTypeNames(this._categoryFilter);
    }

    public List<String> getFilteredParameterTypeNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter parameter : this.parameterList) {
            String string2;
            if (string != null && !string.equals(parameter.getCategory()) || arrayList.contains(string2 = parameter.getType())) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public Boolean isParameterSelected(Parameter parameter) {
        return this.parametersSelected.get(parameter);
    }

    public void setParameterSelected(Parameter parameter, Boolean bl) {
        this.parametersSelected.put(parameter, bl);
        int n = this.displayList.indexOf(parameter);
        if (n >= 0) {
            this.fireTableCellUpdated(n, 3);
        }
    }

    public List<Parameter> getSelectedParameterList() {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (Parameter parameter : this.parametersSelected.keySet()) {
            if (!this.isParameterSelected(parameter).booleanValue()) continue;
            arrayList.add(parameter);
        }
        return arrayList;
    }

    public List<Parameter> getParameterList() {
        return this.parameterList;
    }

    public List<Parameter> getFilteredParameterList() {
        return this.displayList;
    }
}

