/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.SimulationOutputVariable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutputVariableTableModel
extends AbstractTableModel {
    private static final int COL_NAME = 0;
    private static final int COL_UNITS = 1;
    private static final int COL_SELECTED = 2;
    private static final String[] columnNames = new String[]{"Name", "Units", "Select"};
    private List<SimulationOutputVariable> outputList;
    private Hashtable<SimulationOutputVariable, Boolean> outputsSelected;
    private List<SimulationOutputVariable> displayList;
    private String _categoryFilter;
    private String _typeFilter;

    public OutputVariableTableModel(List<SimulationOutputVariable> list) {
        this.outputList = list;
        this.displayList = new ArrayList<SimulationOutputVariable>(this.outputList);
        this.outputsSelected = new Hashtable();
        for (SimulationOutputVariable simulationOutputVariable : this.outputList) {
            this.outputsSelected.put(simulationOutputVariable, new Boolean(false));
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.displayList.size();
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object;
        switch (n2) {
            case 0: {
                object = this.displayList.get(n).getDescription();
                break;
            }
            case 1: {
                object = this.displayList.get(n).getUnits();
                break;
            }
            case 2: {
                object = this.isOutputSelected(this.displayList.get(n));
                break;
            }
            default: {
                object = new String("Invalid Column Lookup");
            }
        }
        return object;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.setOutputSelected(this.displayList.get(n), (Boolean)object);
        this.fireTableCellUpdated(n, n2);
    }

    public void setCategoryFilter(String string) {
        this._categoryFilter = string;
        this.updateDisplayList();
    }

    public void setTypeFilter(String string) {
        this._typeFilter = string;
        this.updateDisplayList();
    }

    private void updateDisplayList() {
        System.out.println("updateDisplayList(): category: " + this._categoryFilter + " -- type: " + this._typeFilter);
        this.displayList.clear();
        for (SimulationOutputVariable simulationOutputVariable : this.outputList) {
            if (this._categoryFilter != null && !this._categoryFilter.equals(simulationOutputVariable.getCategory()) || this._typeFilter != null && !this._typeFilter.equals(simulationOutputVariable.getType())) continue;
            this.displayList.add(simulationOutputVariable);
        }
        this.fireTableDataChanged();
    }

    public List<String> getCategoryNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SimulationOutputVariable simulationOutputVariable : this.outputList) {
            String string = simulationOutputVariable.getCategory();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getOutputTypeNames() {
        return this.getFilteredOutputTypeNames(null);
    }

    public List<String> getFilteredOutputTypeNames() {
        return this.getFilteredOutputTypeNames(this._categoryFilter);
    }

    public List<String> getFilteredOutputTypeNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SimulationOutputVariable simulationOutputVariable : this.outputList) {
            String string2;
            if (string != null && !string.equals(simulationOutputVariable.getCategory()) || arrayList.contains(string2 = simulationOutputVariable.getType())) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public Boolean isOutputSelected(SimulationOutputVariable simulationOutputVariable) {
        return this.outputsSelected.get(simulationOutputVariable);
    }

    public void setOutputSelected(SimulationOutputVariable simulationOutputVariable, Boolean bl) {
        this.outputsSelected.put(simulationOutputVariable, bl);
        int n = this.displayList.indexOf(simulationOutputVariable);
        if (n >= 0) {
            this.fireTableCellUpdated(n, 2);
        }
    }

    public List<SimulationOutputVariable> getSelectedOutputList() {
        ArrayList<SimulationOutputVariable> arrayList = new ArrayList<SimulationOutputVariable>();
        for (SimulationOutputVariable simulationOutputVariable : this.outputsSelected.keySet()) {
            if (!this.isOutputSelected(simulationOutputVariable).booleanValue()) continue;
            arrayList.add(simulationOutputVariable);
        }
        return arrayList;
    }

    public List<SimulationOutputVariable> getOutputList() {
        return this.outputList;
    }

    public List<SimulationOutputVariable> getFilteredOutputList() {
        return this.displayList;
    }
}

