/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.OutputFile;
import edu.mit.lcp.Parameter;
import edu.mit.lcp.SimulationOutputVariable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class LogPanel
extends JPanel {
    private JLabel label = new JLabel("Logging: ");
    private JButton onButton;
    private JButton offButton;
    private JLabel logFileLabel;
    private Action startLoggingAction = new StartLoggingSelectedVariablesToFileAction(this);
    private Action stopLoggingAction;
    private JToolBar toolBar;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private List<String> logList;
    private List<Parameter> parameterList;
    private List<SimulationOutputVariable> outputList;
    private OutputFile outputFile;

    public LogPanel() {
        this.onButton = new JButton(this.startLoggingAction);
        this.stopLoggingAction = new StopLoggingSelectedVariablesToFileAction();
        this.offButton = new JButton(this.stopLoggingAction);
        this.logFileLabel = new JLabel("");
        this.logFileLabel.setFont(new Font("monospaced", 0, 10));
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.add(this.label);
        this.toolBar.add(this.onButton);
        this.toolBar.add(this.offButton);
        this.toolBar.add(this.logFileLabel);
        this.logList = new ArrayList<String>();
        this.textArea = new JTextArea(5, 20);
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.scrollPane, "Center");
    }

    private class StopLoggingSelectedVariablesToFileAction
    extends AbstractAction {
        StopLoggingSelectedVariablesToFileAction() {
            super("Stop");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            LogPanel.this.startLoggingAction.setEnabled(true);
            LogPanel.this.logFileLabel.setText("");
            LogPanel.this.outputFile.stopLogging();
            LogPanel.this.outputFile = null;
        }
    }

    private class StartLoggingSelectedVariablesToFileAction
    extends AbstractAction {
        private JFileChooser fc;
        private Component pc;

        public StartLoggingSelectedVariablesToFileAction(Component component) {
            super("Start");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LogPanel.this.textArea.setText(null);
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            ArrayList<SimulationOutputVariable> arrayList2 = new ArrayList<SimulationOutputVariable>();
            LogPanel.this.parameterList = CVSim.gui.parameterPanel.model.getSelectedParameterList();
            LogPanel.this.outputList = CVSim.gui.outputPanel.model.getSelectedOutputList();
            for (SimulationOutputVariable object2 : CVSim.sim.getOutputVariables()) {
                if (!LogPanel.this.outputList.contains(object2)) continue;
                arrayList2.add(object2);
            }
            for (Parameter parameter : CVSim.sim.getParameterList()) {
                if (!LogPanel.this.parameterList.contains(parameter)) continue;
                arrayList.add(parameter);
            }
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddyyyy_HHmmss");
            String string = String.format("cvsim_output_" + simpleDateFormat.format(date) + ".txt", new Object[0]);
            File file = new File(string);
            File file2 = null;
            this.fc = new JFileChooser();
            this.fc.setSelectedFile(file);
            if (this.fc.showSaveDialog(this.pc) == 0) {
                file2 = this.fc.getSelectedFile();
                try {
                    if (file2.createNewFile()) {
                        if (!file2.canWrite()) {
                            JOptionPane.showMessageDialog(this.pc, "Cannot write to file " + file2.toString(), "File Error", 0);
                            file2 = null;
                        }
                    } else {
                        int n = JOptionPane.showConfirmDialog(this.pc, file2.toString() + " Already Exists. Do you want to overwrite the file?", "Overwrite File?", 0, 3);
                        if (n == 0 && !file2.canWrite()) {
                            JOptionPane.showMessageDialog(this.pc, "Cannot write to file " + file2.toString(), "File Error", 0);
                            file2 = null;
                        }
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.pc, "Cannot write to file " + file2.toString(), "File Error", 0);
                    file2 = null;
                }
                if (file2 != null) {
                    this.setEnabled(false);
                    LogPanel.this.stopLoggingAction.setEnabled(true);
                    LogPanel.this.logFileLabel.setText(file2.toString());
                    LogPanel.this.outputFile = new OutputFile(arrayList, arrayList2, file2);
                    LogPanel.this.outputFile.startLogging();
                    LogPanel.this.textArea.append("Logging the following variables:\n\n");
                    if (arrayList2.size() > 0) {
                        LogPanel.this.textArea.append("Outputs:\n");
                        for (SimulationOutputVariable simulationOutputVariable : arrayList2) {
                            LogPanel.this.textArea.append(simulationOutputVariable.getDescription() + "\n");
                        }
                    }
                    if (arrayList.size() > 0) {
                        LogPanel.this.textArea.append("\nParameters:\n");
                        for (Parameter parameter : arrayList) {
                            LogPanel.this.textArea.append(parameter.getName() + "\n");
                        }
                    }
                }
            }
        }
    }
}

