/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ControlToolBar
extends JToolBar {
    private JToggleButton _startButton;
    private JToggleButton _stopButton;
    public JToggleButton _abReflexOnButton;
    public JToggleButton _abReflexOffButton;
    public JToggleButton _cpReflexOnButton;
    public JToggleButton _cpReflexOffButton;

    public ControlToolBar() {
        this.setRollover(true);
        this.setFloatable(false);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/icons/go.gif"));
        this._startButton = new JToggleButton(imageIcon);
        this._startButton.addActionListener(new StartSimulationAction(this));
        this._startButton.setToolTipText("Start Simulation");
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/icons/stop.gif"));
        this._stopButton = new JToggleButton(imageIcon2);
        this._stopButton.addActionListener(new StopSimulationAction(this));
        this._stopButton.setToolTipText("Stop Simulation");
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("/icons/ABgo.gif"));
        this._abReflexOnButton = new JToggleButton(imageIcon3);
        this._abReflexOnButton.addActionListener(new ABReflexOnAction(this));
        this._abReflexOnButton.setToolTipText("Arterial Baroreflex Control System On");
        ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("/icons/ABstop.gif"));
        this._abReflexOffButton = new JToggleButton(imageIcon4);
        this._abReflexOffButton.addActionListener(new ABReflexOffAction(this));
        this._abReflexOffButton.setToolTipText("Arterial Baroreflex Control System Off");
        ImageIcon imageIcon5 = new ImageIcon(this.getClass().getResource("/icons/CPgo.gif"));
        this._cpReflexOnButton = new JToggleButton(imageIcon5);
        this._cpReflexOnButton.addActionListener(new CPReflexOnAction(this));
        this._cpReflexOnButton.setToolTipText("Cardiopulmonary Reflex Control System On");
        ImageIcon imageIcon6 = new ImageIcon(this.getClass().getResource("/icons/CPstop.gif"));
        this._cpReflexOffButton = new JToggleButton(imageIcon6);
        this._cpReflexOffButton.addActionListener(new CPReflexOffAction(this));
        this._cpReflexOffButton.setToolTipText("Cardiopulmonary Reflex Control System Off");
        this.add(this._startButton);
        this.add(this._stopButton);
        this.add(this._abReflexOnButton);
        this.add(this._abReflexOffButton);
        this.add(this._cpReflexOnButton);
        this.add(this._cpReflexOffButton);
    }

    public JMenu createSimulationMenu() {
        JMenu jMenu = new JMenu("Simulation");
        jMenu.add(new StartSimulationAction(this));
        jMenu.add(new StopSimulationAction(this));
        jMenu.add(new ABReflexOnAction(this));
        jMenu.add(new ABReflexOffAction(this));
        jMenu.add(new CPReflexOnAction(this));
        jMenu.add(new CPReflexOffAction(this));
        return jMenu;
    }

    private class CPReflexOffAction
    extends AbstractAction {
        private Component pc;

        public CPReflexOffAction(Component component) {
            super("Cardiopulmonary Reflex Control System OFF");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlToolBar.this._cpReflexOffButton.setSelected(true);
            ControlToolBar.this._cpReflexOnButton.setSelected(false);
            CVSim.sim.setCPReflex(false);
            System.out.println("CP Reflex OFF");
        }
    }

    private class CPReflexOnAction
    extends AbstractAction {
        private Component pc;

        public CPReflexOnAction(Component component) {
            super("Cardiopulmonary Reflex Control System ON");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlToolBar.this._cpReflexOnButton.setSelected(true);
            ControlToolBar.this._cpReflexOffButton.setSelected(false);
            CVSim.sim.setCPReflex(true);
            System.out.println("CP Reflex ON");
        }
    }

    private class ABReflexOffAction
    extends AbstractAction {
        private Component pc;

        public ABReflexOffAction(Component component) {
            super("Arterial Baroreflex Control System OFF");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlToolBar.this._abReflexOffButton.setSelected(true);
            ControlToolBar.this._abReflexOnButton.setSelected(false);
            CVSim.sim.setABReflex(false);
            System.out.println("AB Reflex OFF");
        }
    }

    private class ABReflexOnAction
    extends AbstractAction {
        private Component pc;

        public ABReflexOnAction(Component component) {
            super("Arterial Baroreflex Control System ON");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlToolBar.this._abReflexOnButton.setSelected(true);
            ControlToolBar.this._abReflexOffButton.setSelected(false);
            CVSim.sim.setABReflex(true);
            System.out.println("AB Reflex ON");
        }
    }

    private class StopSimulationAction
    extends AbstractAction {
        private Component pc;

        public StopSimulationAction(Component component) {
            super("Stop Simulation");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlToolBar.this._stopButton.setSelected(true);
            ControlToolBar.this._startButton.setSelected(false);
            CVSim.simThread.stop();
            System.out.println("Stop");
        }
    }

    private class StartSimulationAction
    extends AbstractAction {
        private Component pc;

        public StartSimulationAction(Component component) {
            super("Start Simulation");
            this.pc = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ControlToolBar.this._startButton.setSelected(true);
            ControlToolBar.this._stopButton.setSelected(false);
            CVSim.simThread.setPeriod(10L);
            CVSim.simThread.start();
            System.out.println("Start");
        }
    }
}

