/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.TabWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.icon.button.RestoreIcon;

public final class RestoreParentWithAbortWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final RestoreParentWithAbortWindowAction INSTANCE = new RestoreParentWithAbortWindowAction();
    private static final Icon icon = new RestoreIcon(10);

    private RestoreParentWithAbortWindowAction() {
    }

    public String getName() {
        return "Restore";
    }

    public boolean isPerformable(DockingWindow dockingWindow) {
        if (dockingWindow.isMinimized() && dockingWindow.isRestorable()) {
            return true;
        }
        TabWindow tabWindow = DockingUtil.getTabWindowFor(dockingWindow);
        return tabWindow != null && tabWindow.isMaximized() && tabWindow.isRestorable();
    }

    public void perform(DockingWindow dockingWindow) {
        if (dockingWindow != null && dockingWindow.isMinimized()) {
            RestoreParentWithAbortWindowAction.restore(dockingWindow);
        } else {
            TabWindow tabWindow = DockingUtil.getTabWindowFor(dockingWindow);
            if (tabWindow != null && tabWindow.isMaximized()) {
                RestoreParentWithAbortWindowAction.restore(tabWindow);
            }
        }
    }

    public Icon getIcon() {
        return icon;
    }

    private static void restore(DockingWindow dockingWindow) {
        try {
            if (dockingWindow != null && dockingWindow.isRestorable()) {
                dockingWindow.restoreWithAbort();
            }
        }
        catch (OperationAbortedException operationAbortedException) {
            // empty catch block
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

