/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.Trace;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceListModel
extends AbstractListModel
implements Iterable<Trace> {
    private List<Trace> _traceList = new CopyOnWriteArrayList<Trace>();
    public List<Color> colorList = new ArrayList<Color>();
    private PropertyChangeListener tracePropertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Trace trace = (Trace)propertyChangeEvent.getSource();
            TraceListModel.this.fireContentsChanged(this, TraceListModel.this._traceList.indexOf(trace), TraceListModel.this._traceList.indexOf(trace));
        }
    };

    TraceListModel() {
        this.colorList.add(Color.RED);
        this.colorList.add(Color.BLUE);
        this.colorList.add(Color.GREEN);
        this.colorList.add(Color.CYAN);
        this.colorList.add(Color.MAGENTA);
        this.colorList.add(Color.ORANGE);
    }

    public void add(Trace<?, ?> trace) {
        this._traceList.add(trace);
        this.fireIntervalAdded(this, this._traceList.size() - 1, this._traceList.size() - 1);
        trace.addPropertyChangeListener(this.tracePropertyChangeListener);
    }

    public void remove(Trace<?, ?> trace) {
        int n = this._traceList.size();
        int n2 = this._traceList.indexOf(trace);
        if (n2 >= 0) {
            this._traceList.remove(trace);
            this.fireIntervalRemoved(this, n2, n2);
            trace.removePropertyChangeListener(this.tracePropertyChangeListener);
        }
    }

    public void clear() {
        int n = this._traceList.size();
        this._traceList.clear();
        this.fireIntervalRemoved(this, 0, n - 1);
    }

    @Override
    public Trace<?, ?> getElementAt(int n) {
        return this._traceList.get(n);
    }

    public Trace<?, ?> get(int n) {
        return this.getElementAt(n);
    }

    public int indexOf(Trace trace) {
        return this._traceList.indexOf(trace);
    }

    public boolean isEmpty() {
        return this._traceList.isEmpty();
    }

    @Override
    public int getSize() {
        return this._traceList.size();
    }

    public int size() {
        return this.getSize();
    }

    public Color getNextColor() {
        ArrayList<Color> arrayList = new ArrayList<Color>(this.colorList);
        for (Trace trace : this._traceList) {
            arrayList.remove(trace.getColor());
        }
        if (arrayList.isEmpty()) {
            return Color.BLACK;
        }
        return (Color)arrayList.get(0);
    }

    @Override
    public Iterator<Trace> iterator() {
        return this._traceList.iterator();
    }
}

