/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.CVSim;
import edu.mit.lcp.PlotComponent;
import edu.mit.lcp.PlotPanel;
import edu.mit.lcp.PlotPoints;
import edu.mit.lcp.Range;
import edu.mit.lcp.SimulationOutputVariable;
import edu.mit.lcp.SimulationOutputVariableBuffer;
import edu.mit.lcp.SimulationOutputVariableListModel;
import edu.mit.lcp.Trace;
import edu.mit.lcp.TraceListModel;
import edu.mit.lcp.VariableRecorderInterface;
import edu.mit.lcp.yScaleComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotPanelStripChart
extends PlotPanel {
    private static final int NUM_TICKS = 5;
    private int traceBufferSize;
    private TraceListModel traceList;
    private JLabel titleLabel;
    private yScaleComponent xScale;
    private JSlider speedSlider;
    private AddStripChartTraceComponent addComponent;
    private VariableRecorderInterface<Double> timeAxisBuffer;
    private double secondsPerUnit;
    public double xMax = 0.0;
    public double xMin = 0.0;
    public double yMax = 0.0;
    public double yMin = 0.0;
    public boolean showTitle = true;
    public boolean showXScale = false;
    public boolean showYScale = true;
    public PlotComponent plot;

    public PlotPanelStripChart(TraceListModel traceListModel) {
        this.traceList = traceListModel;
        this.titleLabel = new JLabel("Plot Title");
        this.traceList.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        CVSim.sim.addPropertyChangeListener("COMPRESSION", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlotPanelStripChart.this.updateTraceBufferSizes();
            }
        });
        this.plot = new PlotComponent(this.traceList, 1, 2);
        this.plot.setBorder(new CompoundBorder(new MatteBorder(14, 0, 14, 0, this.getBackground()), new LineBorder(Color.BLACK, 1)));
        this.plot.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PlotPanelStripChart.this.updateTraceBufferSizes();
            }
        });
        this.plot.addMouseListener(new PlotMouseListener());
        this.yScale = new yScaleComponent(this.traceList, 15, 5, this);
        ArrayList<SimulationOutputVariable> arrayList = new ArrayList<SimulationOutputVariable>(CVSim.sim.getOutputVariables());
        arrayList.remove(CVSim.sim.getOutputVariable("TIME"));
        final JComboBox jComboBox = new JComboBox(new SimulationOutputVariableListModel(arrayList));
        JButton jButton = new JButton("Add Trace");
        jButton.setMargin(new Insets(1, 2, 2, 2));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotPanelStripChart.this.createNewTrace((SimulationOutputVariable)jComboBox.getSelectedItem());
            }
        });
        this.speedSlider = new JSlider(1, 100, 5);
        this.speedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    System.out.println("New Paper Speed: " + (double)jSlider.getValue());
                    PlotPanelStripChart.this.setPaperSpeed((double)jSlider.getValue() / 10.0);
                }
            }
        });
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Plot Speed");
        titledBorder.setTitleJustification(2);
        this.speedSlider.setBorder(titledBorder);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JLabel("Y: "));
        jPanel.add(jComboBox);
        jPanel.add(jButton);
        jPanel.add(this.speedSlider);
        jPanel.add(this.multipleYScalesCheckBox);
        jPanel.setPreferredSize(new Dimension(25, 75));
        this.setLayout(new BorderLayout());
        this.add("First", jPanel);
        this.add("Before", this.yScale);
        this.add("Center", this.plot);
        this.sourceDataChanged = new ChangeListener(){
            int count = 0;

            public void stateChanged(ChangeEvent changeEvent) {
                if (this.count++ % 4 == 0) {
                    PlotPanelStripChart.this.updateTraceTransforms();
                    PlotPanelStripChart.this.plot.repaint();
                }
            }
        };
        this.secondsPerUnit = 1.0;
        this.calculateTraceBufferSize();
    }

    @Override
    public void setMultipleYScales(boolean bl) {
        boolean bl2 = this.getMultipleYScales();
        this.multipleYScales = bl;
        this.yScale._changes.firePropertyChange("MULTISCALES", bl2, bl);
    }

    @Override
    public PlotComponent getPlot() {
        return this.plot;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.yScale.getPreferredSize().width, this.yScale.getPreferredSize().width * 8);
    }

    private void createTimeAxisBuffer() {
        this.timeAxisBuffer = new SimulationOutputVariableBuffer<Double>(this.traceBufferSize, CVSim.sim.getOutputVariable("TIME"), new Double(0.0), 2);
        CVSim.sim.addVariableRecorder(this.timeAxisBuffer);
    }

    public void createNewTrace(SimulationOutputVariable simulationOutputVariable) {
        if (this.timeAxisBuffer == null) {
            this.createTimeAxisBuffer();
        }
        SimulationOutputVariableBuffer<Double> simulationOutputVariableBuffer = new SimulationOutputVariableBuffer<Double>(this.traceBufferSize, simulationOutputVariable, new Double(0.0));
        Trace trace = new Trace(this.timeAxisBuffer, simulationOutputVariableBuffer, this.traceList.getNextColor());
        this.addTrace(trace);
    }

    @Override
    public void addTrace(Trace<?, ?> trace) {
        this.traceList.add(trace);
        CVSim.sim.addVariableRecorder(trace.getYVar());
    }

    @Override
    public void removeTrace(Trace<?, ?> trace) {
        this.traceList.remove(trace);
        CVSim.sim.removeVariableRecorder(trace.getYVar());
        if (this.traceList.isEmpty() && this.timeAxisBuffer != null) {
            CVSim.sim.removeVariableRecorder(this.timeAxisBuffer);
            this.timeAxisBuffer = null;
        }
    }

    @Override
    public void removeAllTraces() {
        for (Trace trace : this.traceList) {
            this.removeTrace(trace);
        }
    }

    private int calculateTraceBufferSize() {
        int n = CVSim.sim.getDataCompressionFactor();
        double d = this.secondsPerUnit * this.plot.getScaledPlotBounds().getWidth();
        this.traceBufferSize = (int)(1000.0 * d) / n;
        return this.traceBufferSize;
    }

    private SimulationOutputVariableBuffer resizeBuffer(SimulationOutputVariableBuffer simulationOutputVariableBuffer, int n) {
        SimulationOutputVariableBuffer simulationOutputVariableBuffer2;
        if (simulationOutputVariableBuffer.getSize() == n) {
            simulationOutputVariableBuffer2 = simulationOutputVariableBuffer;
        } else {
            CVSim.sim.removeVariableRecorder(simulationOutputVariableBuffer);
            simulationOutputVariableBuffer2 = new SimulationOutputVariableBuffer(this.traceBufferSize, simulationOutputVariableBuffer);
            CVSim.sim.addVariableRecorder(simulationOutputVariableBuffer2);
        }
        return simulationOutputVariableBuffer2;
    }

    private void updateTraceBufferSizes() {
        boolean bl = false;
        int n = this.traceBufferSize;
        this.calculateTraceBufferSize();
        if (n != this.traceBufferSize) {
            if (CVSim.simThread.isRunning()) {
                bl = true;
                CVSim.simThread.stop();
            }
            if (this.timeAxisBuffer != null) {
                Iterator<Trace> iterator = this.resizeBuffer((SimulationOutputVariableBuffer)this.timeAxisBuffer, this.traceBufferSize);
                this.timeAxisBuffer = iterator;
            }
            for (Trace trace : this.traceList) {
                trace.setXVar(this.timeAxisBuffer);
            }
            for (Trace trace : this.traceList) {
                SimulationOutputVariableBuffer simulationOutputVariableBuffer = this.resizeBuffer((SimulationOutputVariableBuffer)trace.getYVar(), this.traceBufferSize);
                trace.setYVar(simulationOutputVariableBuffer);
            }
            if (bl) {
                CVSim.simThread.start();
            }
        }
    }

    private Dimension getTitleSize() {
        return this.showTitle ? this.titleLabel.getSize() : new Dimension(0, 0);
    }

    private Dimension getYScaleSize() {
        return this.showYScale ? this.yScale.getSize() : new Dimension(0, 0);
    }

    private Dimension getXScaleSize() {
        return this.showXScale ? this.xScale.getSize() : new Dimension(0, 0);
    }

    public ListModel getListModel() {
        return this.traceList;
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    private void updateTraceTransforms() {
        AffineTransform affineTransform = this.plot.getPlotTransform();
        Rectangle2D rectangle2D = this.plot.getScaledPlotBounds();
        for (Trace trace : this.traceList) {
            AffineTransform affineTransform2 = trace.getTransform();
            if (!trace.isEnabled() || affineTransform2 == null) continue;
            affineTransform2.setTransform(affineTransform);
            Range range = trace.getXDataRange();
            Range range2 = trace.getYRange();
            Double d = ((Number)range.upper).doubleValue() - ((Number)range.lower).doubleValue();
            Double d2 = ((Number)range2.upper).doubleValue() - ((Number)range2.lower).doubleValue();
            affineTransform2.scale(-1.0 / this.secondsPerUnit, 1.0 / d2);
            affineTransform2.translate(-((Number)range.upper).doubleValue(), -((Number)range2.lower).doubleValue());
        }
    }

    public void setPaperSpeed(double d) {
        this.secondsPerUnit = 1.0 / d;
        this.updateTraceBufferSizes();
    }

    class PlotMouseListener
    implements MouseListener {
        PlotMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!CVSim.simThread.isRunning()) {
                PlotPoints plotPoints = new PlotPoints(mouseEvent.getX(), mouseEvent.getY());
                Point point = mouseEvent.getPoint();
                try {
                    if (PlotPanelStripChart.this.getMultipleYScales()) {
                        Trace<?, ?> trace = PlotPanelStripChart.this.traceList.get(0);
                        Point2D point2D = PlotPanelStripChart.this.getScaledPoint(trace.getTransform(), point);
                        String string = String.format("%.2f, %.2f", point2D.getX(), point2D.getY());
                        plotPoints.add(string, trace.getColor());
                        for (Trace trace2 : PlotPanelStripChart.this.traceList) {
                            point2D = PlotPanelStripChart.this.getScaledPoint(trace2.getTransform(), point);
                            string = String.format("%.2f, %.2f", point2D.getX(), point2D.getY());
                            if (plotPoints.getString(0).equals(string)) continue;
                            plotPoints.add(string, trace2.getColor());
                        }
                    } else {
                        Point2D point2D = PlotPanelStripChart.this.getScaledPoint(PlotPanelStripChart.this.traceList.get(0).getTransform(), point);
                        String string = String.format("%.2f, %.2f", point2D.getX(), point2D.getY());
                        plotPoints.add(string, Color.BLACK);
                    }
                    plotPoints.setEnabled(true);
                    PlotPanelStripChart.this.plot.pointList.add(plotPoints);
                    PlotPanelStripChart.this.plot.repaint();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    System.out.println("PlotPanel.java: NoninvertibleTransformException");
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddStripChartTraceComponent
    extends JComponent {
        private JComboBox yTraceBox;
        PlotPanelStripChart plotPanel;

        AddStripChartTraceComponent(PlotPanelStripChart plotPanelStripChart2, List<SimulationOutputVariable> list) {
            this.setLayout(new FlowLayout(3, 0, 0));
            this.plotPanel = plotPanelStripChart2;
            this.yTraceBox = new JComboBox(new SimulationOutputVariableListModel(list));
            JButton jButton = new JButton("Add Trace");
            jButton.setMargin(new Insets(1, 2, 2, 2));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AddStripChartTraceComponent.this.plotPanel.createNewTrace((SimulationOutputVariable)AddStripChartTraceComponent.this.yTraceBox.getSelectedItem());
                }
            });
            this.add(new JLabel("Plot Variable: "));
            this.add(this.yTraceBox);
            this.add(jButton);
        }
    }
}

