/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme.internal.laftheme;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.infonode.gui.DynamicUIManager;
import net.infonode.gui.DynamicUIManagerListener;
import net.infonode.tabbedpanel.theme.internal.laftheme.PaneHandlerListener;
import net.infonode.tabbedpanel.theme.internal.laftheme.PanePainter;
import net.infonode.util.Direction;

public class PaneHandler {
    private JFrame frame;
    private PanePainter[] panePainters;
    private PaneHandlerListener listener;
    private DynamicUIManagerListener uiListener = new DynamicUIManagerListener(){

        public void lookAndFeelChanged() {
            PaneHandler.this.doUpdate();
        }

        public void propertiesChanging() {
            PaneHandler.this.listener.updating();
        }

        public void propertiesChanged() {
            PaneHandler.this.doUpdate();
        }

        public void lookAndFeelChanging() {
            PaneHandler.this.listener.updating();
        }
    };

    PaneHandler(PaneHandlerListener paneHandlerListener) {
        this.listener = paneHandlerListener;
        DynamicUIManager.getInstance().addPrioritizedListener(this.uiListener);
        Direction[] directionArray = Direction.getDirections();
        this.panePainters = new PanePainter[directionArray.length];
        JPanel jPanel = new JPanel(null);
        for (int i = 0; i < directionArray.length; ++i) {
            this.panePainters[i] = new PanePainter(directionArray[i]);
            jPanel.add(this.panePainters[i]);
            this.panePainters[i].setBounds(0, 0, 600, 600);
        }
        this.frame = new JFrame();
        this.frame.getContentPane().add((Component)jPanel, "Center");
        this.frame.pack();
    }

    void dispose() {
        if (this.frame != null) {
            DynamicUIManager.getInstance().removePrioritizedListener(this.uiListener);
            this.frame.removeAll();
            this.frame.dispose();
            this.frame = null;
        }
    }

    PanePainter getPainter(Direction direction) {
        for (int i = 0; i < this.panePainters.length; ++i) {
            if (this.panePainters[i].getDirection() != direction) continue;
            return this.panePainters[i];
        }
        return null;
    }

    JFrame getFrame() {
        return this.frame;
    }

    void update() {
        this.listener.updating();
        this.doUpdate();
    }

    private void doUpdate() {
        SwingUtilities.updateComponentTreeUI(this.frame);
        this.listener.updated();
    }
}

