/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.PlotWindow;
import edu.mit.lcp.Trace;
import edu.mit.lcp.TraceLegendTableModel;
import edu.mit.lcp.TraceListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TraceLegendTableComponent
extends JComponent {
    JTable table;
    PlotWindow parentPlotWindow;
    TraceListModel traceModel;

    TraceLegendTableComponent(PlotWindow plotWindow, TraceListModel traceListModel) {
        this.traceModel = traceListModel;
        this.parentPlotWindow = plotWindow;
        this.setLayout(new BorderLayout());
        this.setBorder(LineBorder.createGrayLineBorder());
        this.table = new JTable(new TraceLegendTableModel(this.traceModel));
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setDefaultEditor(Color.class, new ColorEditor());
        this.table.getColumnModel().getColumn(4).setCellEditor(new RemoveButtonCellEditor());
        this.table.getColumnModel().getColumn(4).setCellRenderer(new RemoveButtonCellRenderer());
        this.table.setCellSelectionEnabled(false);
        this.add((Component)this.table.getTableHeader(), "First");
        this.add((Component)this.table, "Center");
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean bl) {
            this.isBordered = bl;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = (Color)object;
            this.setBackground(color);
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            this.setToolTipText("RGB value: " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue());
            return this;
        }
    }

    public class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        JColorChooser colorChooser;
        JDialog dialog;
        protected static final String EDIT = "edit";

        public ColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            this.colorChooser = new JColorChooser();
            this.colorChooser.setPreviewPanel(new JPanel());
            this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, this, null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                this.button.setBackground(this.currentColor);
                this.colorChooser.setColor(this.currentColor);
                this.dialog.setVisible(true);
                this.fireEditingStopped();
            } else {
                this.currentColor = this.colorChooser.getColor();
            }
        }

        public Object getCellEditorValue() {
            return this.currentColor;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentColor = (Color)object;
            return this.button;
        }
    }

    public class RemoveButtonCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JButton button;
        int tableRow;

        public RemoveButtonCellEditor() {
            this.button = new JButton(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = TraceLegendTableComponent.this.traceModel.getElementAt(RemoveButtonCellEditor.this.tableRow);
                    TraceLegendTableComponent.this.parentPlotWindow.getPlot().removeTrace((Trace<?, ?>)object);
                    RemoveButtonCellEditor.this.fireEditingStopped();
                }
            });
        }

        public Object getCellEditorValue() {
            return new Boolean(true);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tableRow = n;
            return this.button;
        }
    }

    public class RemoveButtonCellRenderer
    extends JButton
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText((String)object);
            return this;
        }
    }
}

