/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcp;

import edu.mit.lcp.Range;
import edu.mit.lcp.VariableRecorderInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trace<xVarType extends Number, yVarType extends Number>
implements Iterable<Point2D.Double>,
Shape {
    public static final String PROP_COLOR = "COLOR";
    public static final String PROP_STROKE = "STROKE";
    public static final String PROP_ENABLED = "ENABLED";
    public static final String PROP_XRANGE = "XRANGE";
    public static final String PROP_YRANGE = "YRANGE";
    private boolean _enabled;
    private Color _color;
    private Stroke _stroke;
    private AffineTransform transform;
    private VariableRecorderInterface<xVarType> xVar;
    private VariableRecorderInterface<yVarType> yVar;
    private Range xRange;
    private Range yRange;
    private PropertyChangeSupport _changes = new PropertyChangeSupport(this);

    public Trace(VariableRecorderInterface variableRecorderInterface, VariableRecorderInterface variableRecorderInterface2, Color color) {
        this(variableRecorderInterface, variableRecorderInterface2, color, new BasicStroke());
    }

    public Trace(VariableRecorderInterface variableRecorderInterface, VariableRecorderInterface variableRecorderInterface2, Color color, Stroke stroke) {
        this.xVar = variableRecorderInterface;
        this.yVar = variableRecorderInterface2;
        this._color = color;
        this._stroke = stroke;
        this.transform = new AffineTransform();
        this._enabled = true;
        this.xRange = new Range<xVarType>(this.xVar.getTypicalRange());
        this.yRange = new Range<yVarType>(this.yVar.getTypicalRange());
    }

    public void setColor(Color color) {
        Color color2 = this._color;
        this._color = color;
        this._changes.firePropertyChange(PROP_COLOR, color2, color);
    }

    public Color getColor() {
        return this._color;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this._stroke;
        this._stroke = stroke;
        this._changes.firePropertyChange(PROP_STROKE, stroke2, stroke);
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this._enabled;
        this._enabled = bl;
        this._changes.firePropertyChange(PROP_ENABLED, bl2, bl);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public String getXName() {
        return this.xVar.getName();
    }

    public String getYName() {
        return this.yVar.getName();
    }

    public String getXDescription() {
        return this.xVar.getDescription();
    }

    public String getYDescription() {
        return this.yVar.getDescription();
    }

    public String getXUnits() {
        return this.xVar.getUnits();
    }

    public String getYUnits() {
        return this.yVar.getUnits();
    }

    public Range<xVarType> getXRange() {
        return this.xRange;
    }

    public Range<yVarType> getYRange() {
        return this.yRange;
    }

    public Range<xVarType> getXDataRange() {
        return new Range<xVarType>(this.xVar.getMinVal(), this.xVar.getMaxVal());
    }

    public Range<yVarType> getYDataRange() {
        return new Range<yVarType>(this.yVar.getMinVal(), this.yVar.getMaxVal());
    }

    public void setXRange(Range<xVarType> range) {
        Range range2 = this.xRange;
        this.xRange.setBounds(range);
        this._changes.firePropertyChange(PROP_XRANGE, range2, range);
    }

    public void setYRange(Range<yVarType> range) {
        Range range2 = this.yRange;
        this.yRange.setBounds(range);
        this._changes.firePropertyChange(PROP_YRANGE, range2, range);
    }

    public void resetRange() {
        this.setXRange(this.xVar.getTypicalRange());
        this.setYRange(this.yVar.getTypicalRange());
    }

    public VariableRecorderInterface getXVar() {
        return this.xVar;
    }

    public VariableRecorderInterface getYVar() {
        return this.yVar;
    }

    public void setXVar(VariableRecorderInterface variableRecorderInterface) {
        this.xVar = variableRecorderInterface;
    }

    public void setYVar(VariableRecorderInterface variableRecorderInterface) {
        this.yVar = variableRecorderInterface;
    }

    public int getNumPoints() {
        if (this.xVar.getSize() < this.yVar.getSize()) {
            return this.xVar.getSize();
        }
        return this.yVar.getSize();
    }

    public String toString() {
        return this.xVar + " / " + this.yVar;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this._changes.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changes.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Iterator<Point2D.Double> iterator() {
        return new PairedIterator(this.xVar.iterator(), this.yVar.iterator());
    }

    @Override
    public boolean contains(double d, double d2) {
        return ((Number)this.xVar.getMinVal()).doubleValue() <= d && ((Number)this.xVar.getMaxVal()).doubleValue() >= d && ((Number)this.yVar.getMinVal()).doubleValue() <= d2 && ((Number)this.yVar.getMaxVal()).doubleValue() >= d2;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return ((Number)this.xVar.getMinVal()).doubleValue() <= d && ((Number)this.xVar.getMinVal()).doubleValue() <= d + d3 && ((Number)this.xVar.getMaxVal()).doubleValue() >= d && ((Number)this.xVar.getMaxVal()).doubleValue() >= d + d3 && ((Number)this.yVar.getMinVal()).doubleValue() <= d2 && ((Number)this.yVar.getMinVal()).doubleValue() <= d2 + d4 && ((Number)this.yVar.getMaxVal()).doubleValue() >= d2 && ((Number)this.yVar.getMaxVal()).doubleValue() >= d2 + d4;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        int n = rectangle2D.outcode(((Number)this.xVar.getMinVal()).doubleValue(), ((Number)this.yVar.getMinVal()).doubleValue());
        int n2 = rectangle2D.outcode(((Number)this.xVar.getMaxVal()).doubleValue(), ((Number)this.yVar.getMaxVal()).doubleValue());
        return (n & 9) != 0 && (n2 & 6) != 0;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(((Number)this.xVar.getMinVal()).intValue(), ((Number)this.yVar.getMinVal()).intValue(), ((Number)this.xVar.getMaxVal()).intValue() - ((Number)this.xVar.getMinVal()).intValue(), ((Number)this.yVar.getMaxVal()).intValue() - ((Number)this.yVar.getMinVal()).intValue());
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(((Number)this.xVar.getMinVal()).doubleValue(), ((Number)this.yVar.getMinVal()).doubleValue(), ((Number)this.xVar.getMaxVal()).doubleValue() - ((Number)this.xVar.getMinVal()).doubleValue(), ((Number)this.yVar.getMaxVal()).doubleValue() - ((Number)this.yVar.getMinVal()).doubleValue());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new TracePathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) || this.contains(d, d2 + d4) || this.contains(d + d3, d2) || this.contains(d + d3, d2 + d4);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return rectangle2D.intersects(((Number)this.xVar.getMinVal()).doubleValue(), ((Number)this.yVar.getMinVal()).doubleValue(), ((Number)this.xVar.getMaxVal()).doubleValue() - ((Number)this.xVar.getMinVal()).doubleValue(), ((Number)this.yVar.getMaxVal()).doubleValue() - ((Number)this.yVar.getMinVal()).doubleValue());
    }

    private class TracePathIterator
    implements PathIterator {
        private AffineTransform _localAT;
        private Iterator<Point2D.Double> _traceIterator;
        private Point2D.Double _curPoint;
        private int _curSegType;

        TracePathIterator(AffineTransform affineTransform) {
            this._localAT = Trace.this.transform;
            if (this._localAT == null) {
                this._localAT = affineTransform;
            } else if (affineTransform != null) {
                this._localAT = new AffineTransform(Trace.this.transform);
                this._localAT.concatenate(affineTransform);
            }
            this._traceIterator = Trace.this.iterator();
            this._curPoint = this._traceIterator.next();
            this._curSegType = 0;
        }

        public int currentSegment(double[] dArray) {
            dArray[0] = this._curPoint.getX();
            dArray[1] = this._curPoint.getY();
            if (this._localAT != null) {
                this._localAT.transform(dArray, 0, dArray, 0, 1);
            }
            return this._curSegType;
        }

        public int currentSegment(float[] fArray) {
            fArray[0] = (float)this._curPoint.getX();
            fArray[1] = (float)this._curPoint.getY();
            if (this._localAT != null) {
                this._localAT.transform(fArray, 0, fArray, 0, 1);
            }
            return this._curSegType;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return !this._traceIterator.hasNext();
        }

        public void next() {
            this._curPoint = this._traceIterator.next();
            this._curSegType = 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PairedIterator<xVarType extends Number, yVarType extends Number>
    implements Iterator<Point2D.Double> {
        private Point2D.Double point;
        private Iterator<xVarType> _xIter;
        private Iterator<yVarType> _yIter;

        public PairedIterator(Iterator<xVarType> iterator, Iterator<yVarType> iterator2) {
            this._xIter = iterator;
            this._yIter = iterator2;
            this.point = new Point2D.Double();
        }

        @Override
        public boolean hasNext() {
            return this._xIter.hasNext() && this._yIter.hasNext();
        }

        @Override
        public Point2D.Double next() {
            this.point.setLocation(((Number)this._xIter.next()).doubleValue(), ((Number)this._yIter.next()).doubleValue());
            return this.point;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

