/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.menu;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import net.infonode.gui.icon.IconUtil;

public class MenuUtil {
    private MenuUtil() {
    }

    public static void optimizeSeparators(JPopupMenu jPopupMenu) {
        boolean bl = true;
        int n = 0;
        while (n < jPopupMenu.getComponentCount()) {
            if (jPopupMenu.getComponent(n).isVisible() && jPopupMenu.getComponent(n) instanceof JMenu) {
                MenuUtil.optimizeSeparators(((JMenu)jPopupMenu.getComponent(n)).getPopupMenu());
            }
            boolean bl2 = jPopupMenu.getComponent(n) instanceof JPopupMenu.Separator;
            if (bl && bl2) {
                jPopupMenu.remove(n);
            } else {
                ++n;
            }
            bl = bl2;
        }
        if (jPopupMenu.getComponentCount() > 0 && jPopupMenu.getComponent(jPopupMenu.getComponentCount() - 1) instanceof JPopupMenu.Separator) {
            jPopupMenu.remove(jPopupMenu.getComponentCount() - 1);
        }
    }

    public static void align(MenuElement menuElement) {
        Object[] objectArray = menuElement.getSubElements();
        final int n = IconUtil.getMaxIconWidth(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)objectArray[i];
                final Icon icon = abstractButton.getIcon();
                abstractButton.setIcon(new Icon(){

                    public int getIconHeight() {
                        return icon == null ? 1 : icon.getIconHeight();
                    }

                    public int getIconWidth() {
                        return n;
                    }

                    public void paintIcon(Component component, Graphics graphics, int n3, int n2) {
                        if (icon != null) {
                            icon.paintIcon(component, graphics, n3, n2);
                        }
                    }
                });
            }
            MenuUtil.align((MenuElement)objectArray[i]);
        }
    }
}

