/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.hover.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.hover.hoverable.HoverManager;
import net.infonode.gui.hover.hoverable.Hoverable;
import net.infonode.gui.shaped.panel.ShapedPanel;

public class HoverableShapedPanel
extends ShapedPanel
implements Hoverable {
    private HoverListener hoverListener;
    private Component hoveredComponent;
    private boolean hovered = false;

    public HoverableShapedPanel(HoverListener hoverListener) {
        this(new BorderLayout(), hoverListener, null);
    }

    public HoverableShapedPanel(LayoutManager layoutManager, HoverListener hoverListener) {
        this(layoutManager, hoverListener, null);
    }

    public HoverableShapedPanel(LayoutManager layoutManager, HoverListener hoverListener, Component component) {
        super(layoutManager);
        this.hoveredComponent = component != null ? component : this;
        HoverManager.getInstance().addHoverable(this);
        this.setHoverListener(hoverListener);
    }

    public HoverListener getHoverListener() {
        return this.hoverListener;
    }

    public void setHoverListener(HoverListener hoverListener) {
        if (this.hoverListener != hoverListener) {
            HoverListener hoverListener2 = this.hoverListener;
            this.hoverListener = hoverListener;
            if (hoverListener2 != null && hoverListener != null && this.hovered) {
                HoverEvent hoverEvent = new HoverEvent(this.hoveredComponent);
                hoverListener2.mouseExited(hoverEvent);
                hoverListener.mouseEntered(hoverEvent);
            }
        }
    }

    public void hoverEnter() {
        if (this.hoverListener != null) {
            this.hovered = true;
            this.hoverListener.mouseEntered(new HoverEvent(this.hoveredComponent));
        }
    }

    public void hoverExit() {
        if (this.hoverListener != null) {
            this.hovered = false;
            this.hoverListener.mouseExited(new HoverEvent(this.hoveredComponent));
        }
    }

    public Component getHoveredComponent() {
        return this.hoveredComponent;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public boolean acceptHover(ArrayList arrayList) {
        return true;
    }
}

