/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import net.infonode.gui.RotatableLabelUI;
import net.infonode.util.Direction;

public class RotatableLabel
extends JLabel {
    private RotatableLabelUI ui = new RotatableLabelUI(Direction.RIGHT);

    public RotatableLabel(String string) {
        super(string);
        this.init();
    }

    public RotatableLabel(String string, Icon icon) {
        super(string, icon, 2);
        this.init();
    }

    private void init() {
        super.setUI(this.ui);
        super.setOpaque(false);
    }

    public Direction getDirection() {
        return this.ui.getDirection();
    }

    public void setDirection(Direction direction) {
        if (this.ui.getDirection() != direction) {
            this.ui.setDirection(direction);
            this.revalidate();
        }
    }

    public void setMirror(boolean bl) {
        this.ui.setMirror(bl);
        this.revalidate();
    }

    public boolean isMirror() {
        return this.ui.isMirror();
    }

    public void setUI(LabelUI labelUI) {
    }

    private boolean isVertical() {
        return !this.ui.getDirection().isHorizontal();
    }

    private Dimension rotateDimension(Dimension dimension) {
        return dimension == null ? null : (this.isVertical() ? new Dimension(dimension.height, dimension.width) : dimension);
    }

    public Dimension getPreferredSize() {
        return this.rotateDimension(super.getPreferredSize());
    }

    public Dimension getMinimumSize() {
        return this.rotateDimension(super.getMinimumSize());
    }

    public Dimension getMaximumSize() {
        return this.rotateDimension(super.getMaximumSize());
    }

    public void setMinimumSize(Dimension dimension) {
        super.setMinimumSize(this.rotateDimension(dimension));
    }

    public void setMaximumSize(Dimension dimension) {
        super.setMaximumSize(this.rotateDimension(dimension));
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(this.rotateDimension(dimension));
    }

    public void setOpaque(boolean bl) {
    }
}

