/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.WindowBar;
import net.infonode.docking.WindowDecoder;
import net.infonode.docking.action.MaximizeWithAbortWindowAction;
import net.infonode.docking.action.NullWindowAction;
import net.infonode.docking.action.RestoreFocusWindowAction;
import net.infonode.docking.action.RestoreParentWithAbortWindowAction;
import net.infonode.docking.action.RestoreWithAbortWindowAction;
import net.infonode.docking.action.StateDependentWindowAction;
import net.infonode.docking.drop.ChildDropInfo;
import net.infonode.docking.drop.InteriorDropInfo;
import net.infonode.docking.internal.HeavyWeightContainer;
import net.infonode.docking.internal.HeavyWeightDragRectangle;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.RootWindowItem;
import net.infonode.docking.model.SplitWindowItem;
import net.infonode.docking.model.TabWindowItem;
import net.infonode.docking.model.ViewItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.CursorManager;
import net.infonode.gui.DragLabelWindow;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.RectangleComponentPainter;
import net.infonode.gui.layout.BorderLayout2;
import net.infonode.gui.layout.LayoutUtil;
import net.infonode.gui.layout.StretchLayout;
import net.infonode.gui.mouse.MouseButtonListener;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Direction;
import net.infonode.util.ReadWritable;

public class RootWindow
extends DockingWindow
implements ReadWritable {
    private static final int SERIALIZE_VERSION = 4;
    private static final int FLOATING_WINDOW_MIN_WIDTH = 400;
    private static final int FLOATING_WINDOW_MIN_HEIGHT = 300;
    private boolean heavyweightSupport = false;
    private ShapedPanel layeredPane = new ShapedPanel(){

        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    };
    private ShapedPanel windowPanel = new ShapedPanel(new StretchLayout(true, true));
    private SimplePanel mainPanel = new SimplePanel();
    private JFrame dummyFrame;
    private ViewSerializer viewSerializer;
    private DockingWindow window;
    private WindowBar[] windowBars = new WindowBar[Direction.getDirections().length];
    private ArrayList floatingWindows = new ArrayList();
    private DockingWindow maximizedWindow;
    private View focusedView;
    private ArrayList lastFocusedWindows = new ArrayList(4);
    private ArrayList focusedWindows = new ArrayList(4);
    private ArrayList views = new ArrayList();
    private boolean cleanUpModel;
    private Runnable modelCleanUpEvent = new Runnable(){

        public void run() {
            if (RootWindow.this.cleanUpModel) {
                RootWindow.this.cleanUpModel = false;
                RootWindow.this.getWindowItem().cleanUp();
            }
        }
    };
    private JLabel dragTextLabel = new JLabel();
    private Container dragTextContainer;
    private DragLabelWindow dragTextWindow;
    private Component dragRectangle;
    private JRootPane currentDragRootPane;

    public RootWindow(ViewSerializer viewSerializer) {
        this(false, viewSerializer);
    }

    public RootWindow(boolean bl, ViewSerializer viewSerializer) {
        super(new RootWindowItem());
        this.heavyweightSupport = bl;
        this.dragRectangle = bl ? new HeavyWeightDragRectangle() : new ShapedPanel();
        this.getWindowProperties().addSuperObject(this.getRootWindowProperties().getDockingWindowProperties());
        this.mainPanel.setLayout(new BorderLayout2());
        this.mainPanel.add((Component)this.windowPanel, new Point(1, 1));
        this.createWindowBars();
        this.layeredPane.add(this.mainPanel);
        this.layeredPane.setLayout(new SingleComponentLayout());
        this.setComponent(this.layeredPane);
        this.viewSerializer = viewSerializer;
        this.dragTextLabel.setOpaque(true);
        if (bl) {
            this.dragTextContainer = new HeavyWeightContainer(this.dragTextLabel, true);
            this.dragTextContainer.validate();
        } else {
            this.dragTextContainer = this.dragTextLabel;
        }
        this.init();
        FocusManager.getInstance();
        this.addTabMouseButtonListener(new MouseButtonListener(){

            public void mouseButtonEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isConsumed()) {
                    return;
                }
                DockingWindow dockingWindow = (DockingWindow)mouseEvent.getSource();
                if (mouseEvent.getID() == 501 && mouseEvent.getButton() == 1 && !mouseEvent.isShiftDown() && dockingWindow.isShowing()) {
                    RestoreFocusWindowAction.INSTANCE.perform(dockingWindow);
                } else if (mouseEvent.getID() == 500 && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    if (dockingWindow.getWindowParent() instanceof WindowBar && RootWindow.this.getRootWindowProperties().getDoubleClickRestoresWindow()) {
                        RestoreWithAbortWindowAction.INSTANCE.perform(dockingWindow);
                    } else {
                        new StateDependentWindowAction(MaximizeWithAbortWindowAction.INSTANCE, NullWindowAction.INSTANCE, RestoreParentWithAbortWindowAction.INSTANCE).perform(dockingWindow);
                    }
                }
            }
        });
    }

    public RootWindow(ViewSerializer viewSerializer, DockingWindow dockingWindow) {
        this(false, viewSerializer, dockingWindow);
    }

    public RootWindow(boolean bl, ViewSerializer viewSerializer, DockingWindow dockingWindow) {
        this(bl, viewSerializer);
        this.setWindow(dockingWindow);
    }

    public View getFocusedView() {
        return this.focusedView;
    }

    void addFocusedWindow(DockingWindow dockingWindow) {
        for (int i = 0; i < this.lastFocusedWindows.size(); ++i) {
            if (((WeakReference)this.lastFocusedWindows.get(i)).get() != dockingWindow) continue;
            return;
        }
        this.lastFocusedWindows.add(new WeakReference<DockingWindow>(dockingWindow));
    }

    void setFocusedView(View view) {
        DockingWindow dockingWindow;
        int n;
        if (view == this.focusedView) {
            return;
        }
        View view2 = this.focusedView;
        this.focusedView = view;
        block0: for (DockingWindow dockingWindow2 = view; dockingWindow2 != null; dockingWindow2 = dockingWindow2.getWindowParent()) {
            this.focusedWindows.add(new WeakReference<View>((View)dockingWindow2));
            for (int i = 0; i < this.lastFocusedWindows.size(); ++i) {
                if (((WeakReference)this.lastFocusedWindows.get(i)).get() != dockingWindow2) continue;
                this.lastFocusedWindows.remove(i);
                continue block0;
            }
        }
        for (int i = 0; i < this.lastFocusedWindows.size(); ++i) {
            DockingWindow dockingWindow3 = (DockingWindow)((WeakReference)this.lastFocusedWindows.get(i)).get();
            if (dockingWindow3 == null) continue;
            dockingWindow3.setFocused(false);
        }
        ArrayList arrayList = this.lastFocusedWindows;
        this.lastFocusedWindows = this.focusedWindows;
        this.focusedWindows = arrayList;
        for (n = 0; n < this.lastFocusedWindows.size(); ++n) {
            dockingWindow = (DockingWindow)((WeakReference)this.lastFocusedWindows.get(n)).get();
            if (dockingWindow == null) continue;
            dockingWindow.setFocused(true);
        }
        if (view != null) {
            view.childGainedFocus(null, view);
        } else {
            this.clearFocus(null);
        }
        for (n = 0; n < this.focusedWindows.size(); ++n) {
            dockingWindow = (DockingWindow)((WeakReference)this.focusedWindows.get(n)).get();
            if (dockingWindow == null) continue;
            dockingWindow.fireViewFocusChanged(view2, this.focusedView);
        }
        for (n = 0; n < this.lastFocusedWindows.size(); ++n) {
            dockingWindow = (DockingWindow)((WeakReference)this.lastFocusedWindows.get(n)).get();
            if (dockingWindow == null) continue;
            dockingWindow.fireViewFocusChanged(view2, this.focusedView);
        }
        this.focusedWindows.clear();
    }

    public RootWindowProperties getRootWindowProperties() {
        return ((RootWindowItem)this.getWindowItem()).getRootWindowProperties();
    }

    public Direction getClosestWindowBar(DockingWindow dockingWindow) {
        Point point = SwingUtilities.convertPoint(dockingWindow.getParent(), dockingWindow.getLocation(), this);
        int[] nArray = new int[]{this.getWindowBar(Direction.UP).isEnabled() ? point.y + dockingWindow.getHeight() : Integer.MAX_VALUE, this.getWindowBar(Direction.DOWN).isEnabled() ? this.getHeight() - point.y : Integer.MAX_VALUE, this.getWindowBar(Direction.LEFT).isEnabled() ? point.x + dockingWindow.getWidth() : Integer.MAX_VALUE, this.getWindowBar(Direction.RIGHT).isEnabled() ? this.getWidth() - point.x : Integer.MAX_VALUE};
        Direction direction = (new Direction[]{Direction.UP, Direction.DOWN, Direction.LEFT, Direction.RIGHT})[ArrayUtil.findSmallest(nArray)];
        return this.getWindowBar(direction).isEnabled() ? direction : null;
    }

    public WindowBar getWindowBar(Direction direction) {
        return this.windowBars[direction.getValue()];
    }

    public void setWindow(DockingWindow dockingWindow) {
        if (this.window == dockingWindow) {
            return;
        }
        if (this.window == null) {
            DockingWindow dockingWindow2 = this.addWindow(dockingWindow);
            this.doReplace(null, dockingWindow2);
            if (this.getUpdateModel() && dockingWindow2.getWindowItem().getRootItem() != this.getWindowItem()) {
                this.getWindowItem().removeAll();
                this.addWindowItem(dockingWindow2, -1);
            }
        } else if (dockingWindow == null) {
            this.removeChildWindow(this.window);
            this.window = null;
        } else {
            this.replaceChildWindow(this.window, dockingWindow);
        }
    }

    public DockingWindow getWindow() {
        return this.window;
    }

    public FloatingWindow createFloatingWindow(Point point, Dimension dimension, DockingWindow dockingWindow) {
        FloatingWindow floatingWindow = new FloatingWindow(this, dockingWindow, point, dimension);
        this.floatingWindows.add(floatingWindow);
        this.addWindow(floatingWindow);
        return floatingWindow;
    }

    FloatingWindow createFloatingWindow() {
        FloatingWindow floatingWindow = new FloatingWindow(this);
        this.floatingWindows.add(floatingWindow);
        this.addWindow(floatingWindow);
        return floatingWindow;
    }

    FloatingWindow createFloatingWindow(DockingWindow dockingWindow, Point point) {
        Serializable serializable;
        Dimension dimension = dockingWindow.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            serializable = dockingWindow.getPreferredSize();
            dimension = new Dimension(Math.max(400, ((Dimension)serializable).width), Math.max(300, ((Dimension)serializable).height));
        }
        serializable = this.createFloatingWindow(point, dimension, dockingWindow);
        ((JComponent)serializable).getTopLevelAncestor().setVisible(true);
        return serializable;
    }

    void removeFloatingWindow(FloatingWindow floatingWindow) {
        this.floatingWindows.remove(floatingWindow);
        this.removeWindow(floatingWindow);
    }

    public ViewSerializer getViewSerializer() {
        return this.viewSerializer;
    }

    public DockingWindow getChildWindow(int n) {
        return n < 4 ? this.windowBars[n] : (this.window != null ? (n == 4 ? this.window : (DockingWindow)this.floatingWindows.get(n - 5)) : (DockingWindow)this.floatingWindows.get(n - 4));
    }

    public int getChildWindowCount() {
        return 4 + (this.window == null ? 0 : 1) + this.floatingWindows.size();
    }

    public Icon getIcon() {
        return null;
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        this.write(objectOutputStream, true);
    }

    public void write(ObjectOutputStream objectOutputStream, boolean bl) throws IOException {
        int n;
        this.cleanUpModel();
        objectOutputStream.writeInt(4);
        objectOutputStream.writeBoolean(bl);
        WriteContext writeContext = new WriteContext(bl, this.getViewSerializer());
        final ArrayList<View> arrayList = new ArrayList<View>();
        for (int i = 0; i < this.views.size(); ++i) {
            View view = (View)((WeakReference)this.views.get(i)).get();
            if (view == null) continue;
            arrayList.add(view);
        }
        RootWindow.writeViews(arrayList, objectOutputStream, writeContext);
        ViewWriter viewWriter = new ViewWriter(){

            public void writeWindowItem(WindowItem windowItem, ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
                if (windowItem.getRootItem() == RootWindow.this.getWindowItem()) {
                    objectOutputStream.writeBoolean(true);
                    RootWindow.this.writeWindowItemIndex(windowItem, objectOutputStream);
                    objectOutputStream.writeInt(-1);
                } else {
                    objectOutputStream.writeBoolean(false);
                    windowItem.writeSettings(objectOutputStream, writeContext);
                }
            }

            public void writeView(View view, ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (arrayList.get(i) != view) continue;
                    objectOutputStream.writeInt(i);
                    return;
                }
                objectOutputStream.writeInt(-1);
            }
        };
        this.getWindowItem().write(objectOutputStream, writeContext, viewWriter);
        for (n = 0; n < 4; ++n) {
            this.windowBars[n].write(objectOutputStream, writeContext, viewWriter);
        }
        objectOutputStream.writeInt(this.floatingWindows.size());
        for (n = 0; n < this.floatingWindows.size(); ++n) {
            ((FloatingWindow)this.floatingWindows.get(n)).write(objectOutputStream, writeContext, viewWriter);
        }
        this.writeLocations(objectOutputStream);
        if (this.maximizedWindow != null) {
            this.writeMaximized(this.maximizedWindow, objectOutputStream);
        }
        objectOutputStream.writeInt(-1);
    }

    private void writeWindowItemIndex(WindowItem windowItem, ObjectOutputStream objectOutputStream) throws IOException {
        if (windowItem.getParent() == null) {
            return;
        }
        this.writeWindowItemIndex(windowItem.getParent(), objectOutputStream);
        int n = windowItem.getParent().getWindowIndex(windowItem);
        objectOutputStream.writeInt(n);
    }

    private void writeMaximized(DockingWindow dockingWindow, ObjectOutputStream objectOutputStream) throws IOException {
        DockingWindow dockingWindow2 = dockingWindow.getWindowParent();
        if (dockingWindow2 != null) {
            this.writeMaximized(dockingWindow2, objectOutputStream);
            objectOutputStream.writeInt(dockingWindow2.getChildWindowIndex(dockingWindow));
        }
    }

    private static void writeViews(ArrayList arrayList, ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
        objectOutputStream.writeInt(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            ((View)arrayList.get(i)).write(objectOutputStream, writeContext);
        }
    }

    public void read(ObjectInputStream objectInputStream) throws IOException {
        this.read(objectInputStream, true);
    }

    private void oldInternalRead(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        int n;
        this.setWindow(objectInputStream.readBoolean() ? WindowDecoder.decodeWindow(objectInputStream, readContext) : null);
        for (n = 0; n < 4; ++n) {
            objectInputStream.readInt();
            this.windowBars[n].oldRead(objectInputStream, readContext);
        }
        super.oldRead(objectInputStream, readContext);
        this.readLocations(objectInputStream, this, readContext.getVersion());
        if (readContext.getVersion() > 1) {
            n = objectInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                View view = (View)WindowDecoder.decodeWindow(objectInputStream, readContext);
                view.setRootWindow(this);
                view.readLocations(objectInputStream, this, readContext.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newInternalRead(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        RootWindow.beginUpdateModel();
        try {
            int n;
            int n2 = objectInputStream.readInt();
            final View[] viewArray = new View[n2];
            for (int i = 0; i < n2; ++i) {
                viewArray[i] = View.read(objectInputStream, readContext);
                if (viewArray[i] == null) continue;
                viewArray[i].setRootWindow(this);
            }
            ViewReader viewReader = new ViewReader(){

                public ViewItem readViewItem(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
                    View view = this.readView(objectInputStream, readContext);
                    return view == null ? new ViewItem() : (ViewItem)view.getWindowItem();
                }

                public WindowItem readWindowItem(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
                    if (objectInputStream.readBoolean()) {
                        int n;
                        WindowItem windowItem = RootWindow.this.getWindowItem();
                        while ((n = objectInputStream.readInt()) != -1) {
                            windowItem = windowItem.getWindow(n);
                        }
                        return windowItem;
                    }
                    return null;
                }

                public TabWindow createTabWindow(DockingWindow[] dockingWindowArray, TabWindowItem tabWindowItem) {
                    TabWindow tabWindow = new TabWindow(dockingWindowArray, tabWindowItem);
                    tabWindow.updateSelectedTab();
                    return tabWindow;
                }

                public SplitWindow createSplitWindow(DockingWindow dockingWindow, DockingWindow dockingWindow2, SplitWindowItem splitWindowItem) {
                    return new SplitWindow(splitWindowItem.isHorizontal(), splitWindowItem.getDividerLocation(), dockingWindow, dockingWindow2, splitWindowItem);
                }

                public View readView(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
                    int n = objectInputStream.readInt();
                    return n == -1 ? null : viewArray[n];
                }
            };
            this.setWindow(this.getWindowItem().read(objectInputStream, readContext, viewReader));
            for (n = 0; n < 4; ++n) {
                this.windowBars[n].newRead(objectInputStream, readContext, viewReader);
            }
            if (readContext.getVersion() >= 4) {
                n = objectInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    FloatingWindow floatingWindow = this.createFloatingWindow();
                    floatingWindow.read(objectInputStream, readContext, viewReader);
                }
            }
            this.readLocations(objectInputStream, this, readContext.getVersion());
        }
        finally {
            RootWindow.endUpdateModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ObjectInputStream objectInputStream, boolean bl) throws IOException {
        FocusManager.getInstance().startIgnoreFocusChanges();
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.setWindow(null);
            while (this.floatingWindows.size() > 0) {
                ((FloatingWindow)this.floatingWindows.get(0)).close();
            }
            int n = objectInputStream.readInt();
            if (n > 4) {
                throw new IOException("Can't read serialized data because it was written by a later version of InfoNode Docking Windows!");
            }
            ReadContext readContext = new ReadContext(this, n, objectInputStream.readBoolean(), bl);
            if (readContext.getVersion() < 3) {
                this.oldInternalRead(objectInputStream, readContext);
            } else {
                this.newInternalRead(objectInputStream, readContext);
            }
            if (n > 1) {
                this.readMaximized(objectInputStream);
            }
            FocusManager.focusWindow(this);
            PropertyMapManager.getInstance().endBatch();
        }
        catch (Throwable throwable) {
            PropertyMapManager.getInstance().endBatch();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FocusManager.getInstance().stopIgnoreFocusChanges();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void readMaximized(ObjectInputStream objectInputStream) throws IOException {
        int n;
        DockingWindow dockingWindow = this;
        while ((n = objectInputStream.readInt()) != -1) {
            if (n >= ((DockingWindow)dockingWindow).getChildWindowCount()) {
                while (objectInputStream.readInt() != -1) {
                }
                return;
            }
            dockingWindow = ((DockingWindow)dockingWindow).getChildWindow(n);
        }
        if (dockingWindow != this) {
            this.setMaximizedWindow(dockingWindow);
        }
    }

    public DockingWindow getMaximizedWindow() {
        return this.maximizedWindow;
    }

    public void setMaximizedWindow(DockingWindow dockingWindow) {
        if (dockingWindow != null && (dockingWindow.isMinimized() || dockingWindow.isUndocked())) {
            return;
        }
        this.internalSetMaximizedWindow(dockingWindow);
    }

    void addView(View view) {
        int n = this.views.size();
        for (int i = 0; i < this.views.size(); ++i) {
            View view2 = (View)((WeakReference)this.views.get(i)).get();
            if (view2 == view) {
                return;
            }
            if (view2 != null) continue;
            n = i;
        }
        this.views.add(n, new WeakReference<View>(view));
    }

    public void removeView(View view) {
        if (view.getRootWindow() == this) {
            return;
        }
        for (int i = 0; i < this.views.size(); ++i) {
            View view2 = (View)((WeakReference)this.views.get(i)).get();
            if (view2 != view) continue;
            this.views.remove(i);
            break;
        }
        this.getWindowItem().removeWindowRefs(view);
    }

    private void internalSetMaximizedWindow(DockingWindow dockingWindow) {
        if (dockingWindow == this.maximizedWindow) {
            return;
        }
        DockingWindow dockingWindow2 = null;
        if (this.maximizedWindow != null) {
            DockingWindow dockingWindow3 = this.maximizedWindow;
            this.maximizedWindow = null;
            if (dockingWindow3.getWindowParent() != null) {
                dockingWindow3.getWindowParent().restoreWindowComponent(dockingWindow3);
            }
            if (dockingWindow3 != this.window) {
                this.windowPanel.remove(dockingWindow3);
            }
            dockingWindow2 = dockingWindow3;
            this.fireWindowRestored(dockingWindow3);
        }
        this.maximizedWindow = dockingWindow;
        if (this.maximizedWindow != null) {
            if (this.maximizedWindow.getWindowParent() != null) {
                this.maximizedWindow.getWindowParent().removeWindowComponent(this.maximizedWindow);
            }
            if (this.maximizedWindow != this.window) {
                this.windowPanel.add(this.maximizedWindow);
                if (this.window != null) {
                    this.window.setVisible(false);
                }
            }
            this.maximizedWindow.setVisible(true);
            dockingWindow2 = this.maximizedWindow;
            this.fireWindowMaximized(this.maximizedWindow);
        } else if (this.window != null) {
            this.window.setVisible(true);
        }
        if (dockingWindow2 != null) {
            FocusManager.focusWindow(dockingWindow2);
        }
    }

    private void createWindowBars() {
        Direction[] directionArray = Direction.getDirections();
        for (int i = 0; i < directionArray.length; ++i) {
            this.windowBars[i] = new WindowBar(this, directionArray[i]);
            this.windowBars[i].setEnabled(false);
            this.addWindow(this.windowBars[i]);
            this.layeredPane.add(this.windowBars[i].getEdgePanel());
            this.mainPanel.add((Component)this.windowBars[i], new Point(directionArray[i] == Direction.LEFT ? 0 : (directionArray[i] == Direction.RIGHT ? 2 : 1), directionArray[i] == Direction.UP ? 0 : (directionArray[i] == Direction.DOWN ? 2 : 1)));
            this.windowBars[i].addPropertyChangeListener("enabled", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RootWindow.this.updateButtonVisibility();
                }
            });
        }
    }

    JComponent getLayeredPane() {
        return this.layeredPane;
    }

    JComponent getWindowPanel() {
        return this.windowPanel;
    }

    protected void showChildWindow(DockingWindow dockingWindow) {
        if (this.maximizedWindow != null && dockingWindow == this.window) {
            this.setMaximizedWindow(null);
        }
        super.showChildWindow(dockingWindow);
    }

    protected void update() {
        RootWindowProperties rootWindowProperties = this.getRootWindowProperties();
        rootWindowProperties.getComponentProperties().applyTo(this.layeredPane);
        InternalPropertiesUtil.applyTo(rootWindowProperties.getShapedPanelProperties(), this.layeredPane);
        rootWindowProperties.getWindowAreaProperties().applyTo(this.windowPanel);
        InternalPropertiesUtil.applyTo(rootWindowProperties.getWindowAreaShapedPanelProperties(), this.windowPanel);
        rootWindowProperties.getDragLabelProperties().applyTo(this.dragTextLabel);
        if (!this.heavyweightSupport) {
            ShapedPanel shapedPanel = (ShapedPanel)this.dragRectangle;
            InternalPropertiesUtil.applyTo(rootWindowProperties.getDragRectangleShapedPanelProperties(), shapedPanel);
            if (shapedPanel.getComponentPainter() == null) {
                shapedPanel.setComponentPainter(new RectangleComponentPainter(Color.BLACK, Color.WHITE, rootWindowProperties.getDragRectangleBorderWidth()));
            }
        } else {
            HeavyWeightDragRectangle heavyWeightDragRectangle = (HeavyWeightDragRectangle)this.dragRectangle;
            ComponentPainter componentPainter = rootWindowProperties.getDragRectangleShapedPanelProperties().getComponentPainter();
            Color color = componentPainter != null ? componentPainter.getColor(this) : null;
            heavyWeightDragRectangle.setColor(color != null ? color : Color.BLACK);
            heavyWeightDragRectangle.setBorderWidth(rootWindowProperties.getDragRectangleBorderWidth());
        }
    }

    void internalStartDrag(JComponent jComponent) {
        this.currentDragRootPane = this.getRootPane();
        FloatingWindow floatingWindow = DockingUtil.getFloatingWindowFor((DockingWindow)jComponent);
        for (int i = 0; i < this.floatingWindows.size(); ++i) {
            FloatingWindow floatingWindow2 = (FloatingWindow)this.floatingWindows.get(i);
            floatingWindow2.startDrag();
            if (this.dummyFrame == null || floatingWindow2 == floatingWindow) continue;
            ((JDialog)floatingWindow2.getTopLevelAncestor()).toFront();
        }
        if (this.dummyFrame != null && floatingWindow != null) {
            ((JDialog)floatingWindow.getTopLevelAncestor()).toFront();
        }
    }

    void stopDrag() {
        if (this.dragTextContainer.getParent() != null) {
            if (!this.heavyweightSupport) {
                this.dragTextContainer.getParent().repaint(this.dragTextContainer.getX(), this.dragTextContainer.getY(), this.dragTextContainer.getWidth(), this.dragTextContainer.getHeight());
            }
            this.dragTextContainer.getParent().remove(this.dragTextContainer);
        }
        if (this.dragTextWindow != null) {
            this.dragTextWindow.setVisible(false);
            this.dragTextWindow.dispose();
            this.dragTextWindow = null;
        }
        if (this.dragRectangle.getParent() != null) {
            if (!this.heavyweightSupport) {
                this.dragRectangle.getParent().repaint(this.dragRectangle.getX(), this.dragRectangle.getY(), this.dragRectangle.getWidth(), this.dragRectangle.getHeight());
            }
            this.dragRectangle.getParent().remove(this.dragRectangle);
        }
        CursorManager.resetGlobalCursor(this.getCurrentDragRootPane());
        this.currentDragRootPane = null;
        for (int i = 0; i < this.floatingWindows.size(); ++i) {
            ((FloatingWindow)this.floatingWindows.get(i)).stopDrag();
        }
    }

    boolean floatingWindowsContainPoint(Point point) {
        for (int i = 0; i < this.floatingWindows.size(); ++i) {
            FloatingWindow floatingWindow = (FloatingWindow)this.floatingWindows.get(i);
            if (!floatingWindow.isShowing() || !floatingWindow.windowContainsPoint(SwingUtilities.convertPoint(this.getRootPane(), point, floatingWindow))) continue;
            return true;
        }
        return false;
    }

    void setCurrentDragRootPane(JRootPane jRootPane) {
        CursorManager.resetGlobalCursor(this.getCurrentDragRootPane());
        this.currentDragRootPane = jRootPane;
    }

    JRootPane getCurrentDragRootPane() {
        return this.currentDragRootPane == null ? this.getRootPane() : this.currentDragRootPane;
    }

    Component getTopLevelComponent() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof JFrame || container instanceof JDialog) {
            return container;
        }
        if (this.dummyFrame == null) {
            this.dummyFrame = new JFrame("");
            this.dummyFrame.setDefaultCloseOperation(2);
        }
        return this.dummyFrame;
    }

    boolean isHeavyweightSupported() {
        return this.heavyweightSupport;
    }

    private static boolean reparent(Container container, Component component) {
        if (component.getParent() != container) {
            if (component.getParent() != null) {
                component.getParent().remove(component);
            }
            container.add(component);
            return true;
        }
        return false;
    }

    void setDragCursor(Cursor cursor) {
        CursorManager.setGlobalCursor(this.getCurrentDragRootPane(), cursor);
        if (this.dragTextWindow != null) {
            this.dragTextWindow.setCursor(cursor);
        }
    }

    void setDragText(Point point, String string) {
        if (point != null) {
            JRootPane jRootPane = this.getCurrentDragRootPane();
            if (RootWindow.reparent(jRootPane.getLayeredPane(), this.dragTextContainer)) {
                jRootPane.getLayeredPane().setLayer(this.dragTextContainer, JLayeredPane.DRAG_LAYER + (this.heavyweightSupport ? -1 : 1));
            }
            this.dragTextLabel.setText(string);
            this.dragTextContainer.setSize(this.dragTextContainer.getPreferredSize());
            Point point2 = SwingUtilities.convertPoint(jRootPane, point, this.dragTextContainer.getParent());
            int n = this.dragTextLabel.getInsets().bottom;
            this.dragTextContainer.setLocation((int)(point2.getX() - (double)(this.dragTextContainer.getWidth() / 2)), (int)(point2.getY() - (double)this.dragTextContainer.getHeight() + (double)n));
            if (!this.getTopLevelAncestor().contains(SwingUtilities.convertPoint(jRootPane, point, this.getTopLevelAncestor())) && !this.floatingWindowsContainPoint(SwingUtilities.convertPoint(jRootPane, point, this.getRootPane()))) {
                this.dragTextContainer.setVisible(false);
                if (this.dragTextWindow == null) {
                    Component component = this.getTopLevelComponent();
                    if (component instanceof Frame) {
                        this.dragTextWindow = new DragLabelWindow((Frame)component);
                    } else if (component instanceof Dialog) {
                        this.dragTextWindow = new DragLabelWindow((Dialog)component);
                    }
                    if (this.dragTextWindow != null) {
                        this.dragTextWindow.setFocusableWindowState(false);
                        this.dragTextWindow.setFocusable(false);
                        this.getRootWindowProperties().getDragLabelProperties().applyTo(this.dragTextWindow.getLabel());
                    }
                }
                if (this.dragTextWindow != null) {
                    this.dragTextWindow.getLabel().setText(string);
                    SwingUtilities.convertPointToScreen(point, jRootPane);
                    this.dragTextWindow.setLocation(point.x - this.dragTextContainer.getWidth() / 2, point.y - this.dragTextContainer.getHeight() + n);
                    this.dragTextWindow.setVisible(true);
                }
            } else {
                this.dragTextContainer.setVisible(true);
                if (this.heavyweightSupport) {
                    this.dragTextContainer.repaint();
                }
                if (this.dragTextWindow != null) {
                    this.dragTextWindow.setVisible(false);
                }
            }
        } else if (this.dragTextContainer.getParent() != null) {
            this.dragTextContainer.setVisible(false);
            if (this.dragTextWindow != null) {
                this.dragTextWindow.setVisible(false);
            }
        }
    }

    void setDragRectangle(Rectangle rectangle) {
        if (rectangle != null) {
            if (RootWindow.reparent(this.getCurrentDragRootPane().getLayeredPane(), this.dragRectangle)) {
                this.getCurrentDragRootPane().getLayeredPane().setLayer(this.dragRectangle, JLayeredPane.DRAG_LAYER + (this.heavyweightSupport ? -1 : 0));
            }
            this.dragRectangle.setBounds(SwingUtilities.convertRectangle(this, rectangle, this.dragRectangle.getParent()));
            this.dragRectangle.setVisible(true);
        } else if (this.dragRectangle.getParent() != null) {
            this.dragRectangle.setVisible(false);
        }
    }

    protected void doReplace(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        if (dockingWindow == this.window) {
            if (this.window != null) {
                this.windowPanel.remove(this.window);
                this.window.setVisible(true);
            }
            this.window = dockingWindow2;
            if (this.window != null) {
                if (this.maximizedWindow != null) {
                    this.window.setVisible(false);
                }
                this.windowPanel.add(this.window);
                this.windowPanel.revalidate();
            }
        }
    }

    protected void doRemoveWindow(DockingWindow dockingWindow) {
        if (dockingWindow == this.window) {
            this.windowPanel.remove(dockingWindow);
            this.window.setVisible(true);
            this.window = null;
        }
        this.repaint();
    }

    public RootWindow getRootWindow() {
        return this;
    }

    protected boolean acceptsSplitWith(DockingWindow dockingWindow) {
        return false;
    }

    protected DropAction doAcceptDrop(Point point, DockingWindow dockingWindow) {
        DropAction dropAction;
        Point point2;
        if (this.maximizedWindow != null && this.maximizedWindow.contains(point2 = SwingUtilities.convertPoint(this, point, this.maximizedWindow)) && this.getChildDropFilter().acceptDrop(new ChildDropInfo(dockingWindow, this, point, this.maximizedWindow)) && (dropAction = this.maximizedWindow.acceptDrop(point2, dockingWindow)) != null) {
            return dropAction;
        }
        return super.doAcceptDrop(point, dockingWindow);
    }

    protected DropAction acceptInteriorDrop(Point point, DockingWindow dockingWindow) {
        if (this.window != null) {
            return null;
        }
        if (this.getInteriorDropFilter().acceptDrop(new InteriorDropInfo(dockingWindow, this, point))) {
            return new DropAction(){

                public void execute(DockingWindow dockingWindow, MouseEvent mouseEvent) {
                    RootWindow.this.setWindow(dockingWindow);
                }
            };
        }
        return null;
    }

    protected PropertyMap getPropertyObject() {
        return this.getRootWindowProperties().getMap();
    }

    protected PropertyMap createPropertyObject() {
        return new RootWindowProperties().getMap();
    }

    boolean windowBarEnabled() {
        for (int i = 0; i < this.windowBars.length; ++i) {
            if (!this.windowBars[i].isEnabled()) continue;
            return true;
        }
        return false;
    }

    void removeWindowComponent(DockingWindow dockingWindow) {
    }

    void restoreWindowComponent(DockingWindow dockingWindow) {
    }

    protected void cleanUpModel() {
        if (!this.cleanUpModel) {
            this.cleanUpModel = true;
            SwingUtilities.invokeLater(this.modelCleanUpEvent);
        }
    }

    protected boolean isShowingInRootWindow() {
        return true;
    }

    public void updateUI() {
        super.updateUI();
        if (this.floatingWindows != null) {
            int n;
            for (n = 0; n < this.floatingWindows.size(); ++n) {
                SwingUtilities.updateComponentTreeUI(((JComponent)this.floatingWindows.get(n)).getTopLevelAncestor());
            }
            for (n = 0; n < this.views.size(); ++n) {
                View view = (View)((WeakReference)this.views.get(n)).get();
                if (view == null || view.getWindowParent() != null) continue;
                SwingUtilities.updateComponentTreeUI(view);
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    private class SingleComponentLayout
    implements LayoutManager {
        private SingleComponentLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension = LayoutUtil.getInteriorSize(container);
            Insets insets = container.getInsets();
            RootWindow.this.mainPanel.setBounds(insets.left, insets.top, dimension.width, dimension.height);
            int n = ((RootWindow)RootWindow.this).windowBars[Direction.LEFT.getValue()].getPreferredSize().width;
            int n2 = ((RootWindow)RootWindow.this).windowBars[Direction.RIGHT.getValue()].getPreferredSize().width;
            int n3 = ((RootWindow)RootWindow.this).windowBars[Direction.UP.getValue()].getPreferredSize().height;
            int n4 = ((RootWindow)RootWindow.this).windowBars[Direction.DOWN.getValue()].getPreferredSize().height;
            Direction[] directionArray = Direction.getDirections();
            for (int i = 0; i < RootWindow.this.windowBars.length; ++i) {
                int n5;
                int n6;
                Component component = RootWindow.this.windowBars[i].getEdgePanel();
                if (!component.isVisible()) continue;
                Direction direction = directionArray[i];
                int n7 = dimension.width - n - n2;
                int n8 = dimension.height - n3 - n4;
                if (direction == Direction.RIGHT) {
                    n6 = container.getWidth() - insets.right - n2 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().left;
                    n5 = Math.min(component.getPreferredSize().width, n7 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().left);
                    component.setBounds(n6 - n5, insets.top + n3, n5, n8);
                    continue;
                }
                if (direction == Direction.LEFT) {
                    n6 = insets.left + n - ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().right;
                    n5 = Math.min(component.getPreferredSize().width, n7 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().right);
                    component.setBounds(n6, insets.top + n3, n5, n8);
                    continue;
                }
                if (direction == Direction.DOWN) {
                    n6 = container.getHeight() - insets.bottom - n4 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().top;
                    n5 = Math.min(component.getPreferredSize().height, n8 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().top);
                    component.setBounds(insets.left + n, n6 - n5, n7, n5);
                    continue;
                }
                n6 = insets.top + n3 - ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().bottom;
                n5 = Math.min(component.getPreferredSize().height, n8 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().bottom);
                component.setBounds(insets.left + n, n6, n7, n5);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return LayoutUtil.add(RootWindow.this.mainPanel.getMinimumSize(), container.getInsets());
        }

        public Dimension preferredLayoutSize(Container container) {
            return LayoutUtil.add(RootWindow.this.mainPanel.getPreferredSize(), container.getInsets());
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

