/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.WindowDecoder;
import net.infonode.docking.drop.ChildDropInfo;
import net.infonode.docking.drop.InteriorDropInfo;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WindowAncestors;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.FloatingWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.docking.properties.FloatingWindowProperties;
import net.infonode.docking.properties.SplitWindowProperties;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.layout.StretchLayout;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.util.Direction;

public class FloatingWindow
extends DockingWindow {
    private DockingWindow window;
    private JDialog dialog;
    private JPanel dragPanel = new SimplePanel();
    private ShapedPanel shapedPanel;
    private DockingWindow maximizedWindow;
    private Runnable titleUpdater;
    private AWTEventListener awtMouseEventListener;
    private PropertyMapTreeListener propertiesListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            FloatingWindow.this.updateFloatingWindow(map);
        }
    };

    FloatingWindow(RootWindow rootWindow) {
        super(new FloatingWindowItem());
        this.getFloatingWindowProperties().addSuperObject(rootWindow.getRootWindowProperties().getFloatingWindowProperties());
        this.setLayout(new StretchLayout(true, true));
        this.shapedPanel = new ShapedPanel();
        this.setComponent(this.shapedPanel);
        Component component = rootWindow.getTopLevelComponent();
        this.dialog = component instanceof Frame ? new JDialog((Frame)component) : new JDialog((Dialog)component);
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                try {
                    if (FloatingWindow.this.getWindowProperties().getCloseEnabled()) {
                        FloatingWindow.this.closeWithAbort();
                    }
                }
                catch (OperationAbortedException operationAbortedException) {
                    // empty catch block
                }
            }
        });
        JRootPane jRootPane = this.dialog.getRootPane();
        jRootPane.getLayeredPane().add(this.dragPanel);
        jRootPane.getLayeredPane().setLayer(this.dragPanel, JLayeredPane.DRAG_LAYER);
        this.dragPanel.setVisible(false);
        this.dragPanel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                FloatingWindow.this.getRootWindow().setCurrentDragRootPane(FloatingWindow.this.getRootPane());
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (!FloatingWindow.this.dragPanel.contains(mouseEvent.getPoint())) {
                    FloatingWindow.this.getRootWindow().setCurrentDragRootPane(null);
                }
            }
        });
        if (rootWindow.isHeavyweightSupported()) {
            try {
                this.awtMouseEventListener = new AWTEventListener(){

                    public void eventDispatched(AWTEvent aWTEvent) {
                        Component component;
                        if (aWTEvent.getID() == 504 && ComponentUtil.getTopLevelAncestor(component = (Component)aWTEvent.getSource()) == FloatingWindow.this.dialog) {
                            FloatingWindow.this.getRootWindow().setCurrentDragRootPane(FloatingWindow.this.getRootPane());
                        }
                    }
                };
                Toolkit.getDefaultToolkit().addAWTEventListener(this.awtMouseEventListener, 16L);
            }
            catch (SecurityException securityException) {
                this.awtMouseEventListener = null;
            }
        }
        PropertyMapWeakListenerManager.addWeakTreeListener(this.getFloatingWindowProperties().getMap(), this.propertiesListener);
        this.updateFloatingWindow(null);
    }

    FloatingWindow(RootWindow rootWindow, DockingWindow dockingWindow, Point point, Dimension dimension) {
        this(rootWindow);
        this.setWindow(dockingWindow);
        this.setInternalSize(dimension);
        this.dialog.setLocation(point.x, point.y);
    }

    public void setWindow(DockingWindow dockingWindow) {
        if (this.window == dockingWindow) {
            return;
        }
        if (this.window == null) {
            WindowAncestors windowAncestors = dockingWindow.storeAncestors();
            DockingWindow dockingWindow2 = this.addWindow(dockingWindow);
            this.doReplace(null, dockingWindow2);
            dockingWindow.notifyListeners(windowAncestors);
        } else if (dockingWindow == null) {
            this.removeChildWindow(this.window);
            this.window = null;
        } else {
            this.replaceChildWindow(this.window, dockingWindow);
        }
    }

    public DockingWindow getWindow() {
        return this.window;
    }

    public void setMaximizedWindow(DockingWindow dockingWindow) {
        if (dockingWindow == this.maximizedWindow) {
            return;
        }
        if (dockingWindow instanceof FloatingWindow || dockingWindow != null && DockingUtil.getFloatingWindowFor(dockingWindow) != this) {
            return;
        }
        this.internalSetMaximizedWindow(dockingWindow);
    }

    public DockingWindow getMaximizedWindow() {
        return this.maximizedWindow;
    }

    public FloatingWindowProperties getFloatingWindowProperties() {
        return ((FloatingWindowItem)this.getWindowItem()).getFloatingWindowProperties();
    }

    public DockingWindowProperties getWindowProperties() {
        return super.getWindowProperties();
    }

    public void minimize() {
    }

    public void minimize(Direction direction) {
    }

    public boolean isDockable() {
        return false;
    }

    public boolean isMaximizable() {
        return false;
    }

    public boolean isMinimizable() {
        return false;
    }

    public boolean isRestorable() {
        return false;
    }

    public boolean isUndockable() {
        return false;
    }

    public void close() {
        PropertyMapWeakListenerManager.removeWeakTreeListener(this.getFloatingWindowProperties().getMap(), this.propertiesListener);
        RootWindow rootWindow = this.getRootWindow();
        super.close();
        this.dialog.dispose();
        if (rootWindow != null) {
            rootWindow.removeFloatingWindow(this);
        }
        try {
            if (this.awtMouseEventListener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtMouseEventListener);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public Icon getIcon() {
        return this.window == null ? null : this.window.getIcon();
    }

    public DockingWindow getChildWindow(int n) {
        return this.window;
    }

    public int getChildWindowCount() {
        return this.window == null ? 0 : 1;
    }

    public boolean isUndocked() {
        return true;
    }

    void startDrag() {
        JRootPane jRootPane = this.dialog.getRootPane();
        this.dragPanel.setBounds(0, 0, jRootPane.getWidth(), jRootPane.getHeight());
        this.dragPanel.setVisible(true);
    }

    void stopDrag() {
        this.dragPanel.setVisible(false);
    }

    JPanel getDragPanel() {
        return this.dragPanel;
    }

    boolean windowContainsPoint(Point point) {
        return this.getTopLevelAncestor().contains(SwingUtilities.convertPoint(this, point, this.getTopLevelAncestor()));
    }

    private void internalSetMaximizedWindow(DockingWindow dockingWindow) {
        if (dockingWindow == this.maximizedWindow) {
            return;
        }
        DockingWindow dockingWindow2 = null;
        if (this.maximizedWindow != null) {
            DockingWindow dockingWindow3 = this.maximizedWindow;
            this.maximizedWindow = null;
            if (dockingWindow3.getWindowParent() != null) {
                dockingWindow3.getWindowParent().restoreWindowComponent(dockingWindow3);
            }
            if (dockingWindow3 != this.window) {
                this.shapedPanel.remove(dockingWindow3);
            }
            dockingWindow2 = dockingWindow3;
            this.fireWindowRestored(dockingWindow3);
        }
        this.maximizedWindow = dockingWindow;
        if (this.maximizedWindow != null) {
            if (this.maximizedWindow.getWindowParent() != null) {
                this.maximizedWindow.getWindowParent().removeWindowComponent(this.maximizedWindow);
            }
            if (this.maximizedWindow != this.window) {
                this.shapedPanel.add(this.maximizedWindow);
                if (this.window != null) {
                    this.window.setVisible(false);
                }
            }
            this.maximizedWindow.setVisible(true);
            dockingWindow2 = this.maximizedWindow;
            this.fireWindowMaximized(this.maximizedWindow);
        } else if (this.window != null) {
            this.window.setVisible(true);
        }
        if (dockingWindow2 != null) {
            FocusManager.focusWindow(dockingWindow2);
        }
    }

    protected void doReplace(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        if (dockingWindow == this.window) {
            if (this.window != null) {
                this.shapedPanel.remove(this.window);
                this.window.setVisible(true);
            }
            this.window = dockingWindow2;
            if (this.window != null) {
                if (this.maximizedWindow != null) {
                    this.window.setVisible(false);
                }
                this.shapedPanel.add(this.window);
                this.doUpdateTitle();
                this.shapedPanel.revalidate();
            }
        }
        this.updateButtonVisibility();
    }

    protected void doRemoveWindow(DockingWindow dockingWindow) {
        if (dockingWindow != null) {
            this.shapedPanel.remove(dockingWindow);
            this.window.setVisible(true);
            this.window = null;
            this.shapedPanel.repaint();
        }
    }

    protected void afterWindowRemoved(DockingWindow dockingWindow) {
        if (this.getFloatingWindowProperties().getAutoCloseEnabled()) {
            this.close();
        }
    }

    private void doUpdateTitle() {
        if (this.titleUpdater == null) {
            this.titleUpdater = new Runnable(){

                public void run() {
                    if (FloatingWindow.this.dialog != null) {
                        FloatingWindow.this.dialog.setTitle(FloatingWindow.this.window == null ? "" : FloatingWindow.this.window.getTitle());
                    }
                    FloatingWindow.this.titleUpdater = null;
                }
            };
            SwingUtilities.invokeLater(this.titleUpdater);
        }
    }

    protected boolean acceptsSplitWith(DockingWindow dockingWindow) {
        return false;
    }

    protected DropAction doAcceptDrop(Point point, DockingWindow dockingWindow) {
        Point point2;
        DockingWindow dockingWindow2;
        DockingWindow dockingWindow3 = dockingWindow2 = this.maximizedWindow != null ? this.maximizedWindow : this.window;
        if (dockingWindow2 != null && dockingWindow2.contains(point2 = SwingUtilities.convertPoint(this, point, dockingWindow2))) {
            return this.getChildDropFilter().acceptDrop(new ChildDropInfo(dockingWindow, this, point, dockingWindow2)) ? dockingWindow2.acceptDrop(point2, dockingWindow) : null;
        }
        return super.doAcceptDrop(point, dockingWindow);
    }

    protected DropAction acceptInteriorDrop(Point point, DockingWindow dockingWindow) {
        if (this.window != null) {
            return null;
        }
        this.getRootWindow().setDragRectangle(null);
        if (this.getInteriorDropFilter().acceptDrop(new InteriorDropInfo(dockingWindow, this, point))) {
            return new DropAction(){

                public void execute(DockingWindow dockingWindow, MouseEvent mouseEvent) {
                    FloatingWindow.this.setWindow(dockingWindow);
                }
            };
        }
        return null;
    }

    protected void update() {
    }

    void removeWindowComponent(DockingWindow dockingWindow) {
    }

    void restoreWindowComponent(DockingWindow dockingWindow) {
    }

    protected void showChildWindow(DockingWindow dockingWindow) {
        if (this.maximizedWindow != null && dockingWindow == this.window) {
            this.setMaximizedWindow(null);
        }
        super.showChildWindow(dockingWindow);
    }

    protected PropertyMap getPropertyObject() {
        return new SplitWindowProperties().getMap();
    }

    protected PropertyMap createPropertyObject() {
        return new SplitWindowProperties().getMap();
    }

    private void updateFloatingWindow(Map map) {
        ShapedPanelProperties shapedPanelProperties;
        FloatingWindowProperties floatingWindowProperties = this.getFloatingWindowProperties();
        ComponentProperties componentProperties = map == null || map.get(floatingWindowProperties.getComponentProperties().getMap()) != null ? floatingWindowProperties.getComponentProperties() : null;
        ShapedPanelProperties shapedPanelProperties2 = shapedPanelProperties = map == null || map.get(floatingWindowProperties.getShapedPanelProperties().getMap()) != null ? floatingWindowProperties.getShapedPanelProperties() : null;
        if (componentProperties != null) {
            componentProperties.applyTo(this.shapedPanel);
        }
        if (shapedPanelProperties != null) {
            InternalPropertiesUtil.applyTo(shapedPanelProperties, this.shapedPanel);
        }
    }

    protected void fireTitleChanged() {
        super.fireTitleChanged();
        this.doUpdateTitle();
    }

    private void setInternalSize(Dimension dimension) {
        this.dialog.getRootPane().setPreferredSize(dimension);
        this.dialog.pack();
        this.dialog.getRootPane().setPreferredSize(null);
    }

    protected DockingWindow read(ObjectInputStream objectInputStream, ReadContext readContext, ViewReader viewReader) throws IOException {
        this.setInternalSize(new Dimension(objectInputStream.readInt(), objectInputStream.readInt()));
        this.dialog.setLocation(objectInputStream.readInt(), objectInputStream.readInt());
        this.dialog.setVisible(objectInputStream.readBoolean());
        this.getWindowItem().readSettings(objectInputStream, readContext);
        if (objectInputStream.readBoolean()) {
            this.setWindow(WindowDecoder.decodeWindow(objectInputStream, readContext, viewReader));
        }
        return this;
    }

    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
        objectOutputStream.writeInt(this.dialog.getWidth());
        objectOutputStream.writeInt(this.dialog.getHeight());
        objectOutputStream.writeInt(this.dialog.getX());
        objectOutputStream.writeInt(this.dialog.getY());
        objectOutputStream.writeBoolean(this.dialog.isVisible());
        this.getWindowItem().writeSettings(objectOutputStream, writeContext);
        objectOutputStream.writeBoolean(this.window != null);
        if (this.window != null) {
            this.window.write(objectOutputStream, writeContext, viewWriter);
        }
    }
}

