/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.WindowBar;
import net.infonode.docking.WindowDragger;
import net.infonode.docking.WindowPopupMenuFactory;
import net.infonode.docking.WindowTab;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.drop.ChildDropInfo;
import net.infonode.docking.drop.DropFilter;
import net.infonode.docking.drop.SplitDropInfo;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WindowAncestors;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.location.LocationDecoder;
import net.infonode.docking.model.SplitWindowItem;
import net.infonode.docking.model.TabWindowItem;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.DockingWindowProperties;
import net.infonode.docking.title.DockingWindowTitleProvider;
import net.infonode.docking.title.SimpleDockingWindowTitleProvider;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.EventUtil;
import net.infonode.gui.mouse.MouseButtonListener;
import net.infonode.gui.panel.BasePanel;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Direction;

public abstract class DockingWindow
extends BasePanel {
    private static int DROP_FLOATING_YOFFSET = 10;
    private DockingWindow windowParent;
    private WindowTab tab;
    private DockingWindow lastFocusedChildWindow;
    private WindowPopupMenuFactory popupMenuFactory;
    private ArrayList mouseButtonListeners;
    private ArrayList listeners;
    private PropertyMapListener propertiesListener = new PropertyMapListener(){

        public void propertyValuesChanged(PropertyMap propertyMap, Map map) {
            DockingWindow.this.doUpdate();
            DockingWindow.this.updateButtonVisibility();
        }
    };
    private PropertyMapTreeListener propertyObjectTreeListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            DockingWindow.this.doUpdate();
        }
    };
    private static HashSet optimizeWindows = new HashSet();
    private static int optimizeDepth;
    private WindowItem windowItem;
    private WeakReference lastRootWindow = new WeakReference<Object>(null);
    private static int updateModelDepth;

    public abstract Icon getIcon();

    public abstract DockingWindow getChildWindow(int var1);

    public abstract int getChildWindowCount();

    protected abstract void doReplace(DockingWindow var1, DockingWindow var2);

    protected abstract void doRemoveWindow(DockingWindow var1);

    protected abstract void update();

    abstract void removeWindowComponent(DockingWindow var1);

    abstract void restoreWindowComponent(DockingWindow var1);

    protected DockingWindow(WindowItem windowItem) {
        DockingWindow dockingWindow = windowItem.getConnectedWindow();
        if (dockingWindow != null) {
            dockingWindow.setWindowItem(windowItem.copy());
        }
        this.windowItem = windowItem;
        this.windowItem.setConnectedWindow(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    DockingWindow.this.showPopupMenu(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }
        });
    }

    protected void init() {
        PropertyMapWeakListenerManager.addWeakListener(this.getWindowProperties().getMap(), this.propertiesListener);
        PropertyMapWeakListenerManager.addWeakTreeListener(this.getPropertyObject(), this.propertyObjectTreeListener);
        this.doUpdate();
        this.updateWindowItem(this.getRootWindow());
    }

    private void doUpdate() {
        this.update();
        if (this.tab != null) {
            this.tab.windowTitleChanged();
        }
        if (this.windowParent != null && this.windowParent.getChildWindowCount() == 1) {
            this.windowParent.doUpdate();
        }
    }

    protected void addWindowItem(DockingWindow dockingWindow, int n) {
        boolean bl = dockingWindow.getWindowItem().isRestoreWindow();
        this.windowItem.addWindow(dockingWindow.getWindowItem(), n);
        if (!bl) {
            dockingWindow.updateWindowItems();
        }
    }

    protected final void updateWindowItems() {
        this.windowItem.removeAll();
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            boolean bl = this.getChildWindow((int)i).windowItem.isRestoreWindow();
            this.windowItem.addWindow(this.getChildWindow((int)i).windowItem);
            if (bl) continue;
            this.getChildWindow(i).updateWindowItems();
        }
    }

    public void setPreferredMinimizeDirection(Direction direction) {
        this.windowItem.setLastMinimizedDirection(direction);
    }

    public Direction getPreferredMinimizeDirection() {
        return this.windowItem.getLastMinimizedDirection();
    }

    private ArrayList getMouseButtonListeners() {
        return this.mouseButtonListeners;
    }

    private void setMouseButtonListeners(ArrayList arrayList) {
        this.mouseButtonListeners = arrayList;
    }

    private ArrayList getListeners() {
        return this.listeners;
    }

    private void setListeners(ArrayList arrayList) {
        this.listeners = arrayList;
    }

    public boolean isUndocked() {
        return this.windowParent != null && this.windowParent.isUndocked();
    }

    public void addTabMouseButtonListener(MouseButtonListener mouseButtonListener) {
        if (this.getMouseButtonListeners() == null) {
            this.setMouseButtonListeners(new ArrayList(2));
        }
        this.getMouseButtonListeners().add(mouseButtonListener);
    }

    public void removeTabMouseButtonListener(MouseButtonListener mouseButtonListener) {
        if (this.getMouseButtonListeners() != null && this.getMouseButtonListeners().remove(mouseButtonListener) && this.getMouseButtonListeners().size() == 0) {
            this.setMouseButtonListeners(null);
        }
    }

    void fireTabWindowMouseButtonEvent(MouseEvent mouseEvent) {
        this.fireTabWindowMouseButtonEvent(this, EventUtil.convert(mouseEvent, this));
    }

    void fireTabWindowMouseButtonEvent(DockingWindow dockingWindow, MouseEvent mouseEvent) {
        if (this.getMouseButtonListeners() != null) {
            MouseButtonListener[] mouseButtonListenerArray = this.getMouseButtonListeners().toArray(new MouseButtonListener[this.getMouseButtonListeners().size()]);
            for (int i = mouseButtonListenerArray.length - 1; i >= 0; --i) {
                mouseButtonListenerArray[i].mouseButtonEvent(mouseEvent);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireTabWindowMouseButtonEvent(dockingWindow, mouseEvent);
        }
    }

    public void addListener(DockingWindowListener dockingWindowListener) {
        if (this.getListeners() == null) {
            this.setListeners(new ArrayList(2));
        }
        this.getListeners().add(dockingWindowListener);
    }

    public void removeListener(DockingWindowListener dockingWindowListener) {
        if (this.getListeners() != null) {
            this.getListeners().remove(dockingWindowListener);
            if (this.getListeners().size() == 0) {
                this.setListeners(null);
            }
        }
    }

    public DockingWindow getWindowParent() {
        return this.windowParent;
    }

    public SplitWindow split(final DockingWindow dockingWindow, final Direction direction, final float f) {
        final SplitWindow splitWindow = new SplitWindow(direction == Direction.RIGHT || direction == Direction.LEFT);
        DockingWindow.optimizeAfter(dockingWindow.getWindowParent(), new Runnable(){

            public void run() {
                DockingWindow.this.getWindowParent().replaceChildWindow(DockingWindow.this, splitWindow);
                splitWindow.setWindows(direction == Direction.DOWN || direction == Direction.RIGHT ? DockingWindow.this : dockingWindow, direction == Direction.UP || direction == Direction.LEFT ? DockingWindow.this : dockingWindow);
                splitWindow.setDividerLocation(f);
                splitWindow.getWindowParent().optimizeWindowLayout();
            }
        });
        return splitWindow;
    }

    public DockingWindowDragger startDrag(RootWindow rootWindow) {
        return new WindowDragger(this, rootWindow);
    }

    public DockingWindowProperties getWindowProperties() {
        return this.getWindowItem().getDockingWindowProperties();
    }

    public RootWindow getRootWindow() {
        return this.windowParent == null ? null : this.windowParent.getRootWindow();
    }

    public void restoreWithAbort() throws OperationAbortedException {
        this.fireWindowRestoring(this);
        this.restore();
    }

    public void restore() {
        if (this.isMaximized()) {
            this.doRestoreFromMaximize();
        } else if (this.isMinimized() || this.getRootWindow() == null) {
            int n;
            ArrayList arrayList = new ArrayList();
            this.findViews(arrayList);
            ArrayList<DockingWindow[]> arrayList2 = new ArrayList<DockingWindow[]>();
            for (n = 0; n < arrayList.size(); ++n) {
                arrayList2.add(((DockingWindow)arrayList.get(n)).getAncestors());
            }
            this.restoreViews(arrayList);
            for (n = 0; n < arrayList.size(); ++n) {
                DockingWindow dockingWindow = (DockingWindow)arrayList.get(n);
                dockingWindow.doFireWindowRestored(dockingWindow);
                DockingWindow[] dockingWindowArray = (DockingWindow[])arrayList2.get(n);
                for (int i = 0; i < dockingWindowArray.length; ++i) {
                    dockingWindowArray[i].doFireWindowRestored(dockingWindow);
                }
            }
            this.restoreFocus();
        }
        this.updateButtonVisibility();
    }

    private DockingWindow doRestoreFromMaximize() {
        DockingWindow dockingWindow = null;
        if (this.isUndocked()) {
            FloatingWindow floatingWindow = DockingUtil.getFloatingWindowFor(this);
            if (floatingWindow != null) {
                floatingWindow.setMaximizedWindow(null);
                dockingWindow = floatingWindow;
            }
        } else {
            RootWindow rootWindow = this.getRootWindow();
            if (rootWindow != null) {
                rootWindow.setMaximizedWindow(null);
                dockingWindow = rootWindow;
            }
        }
        return dockingWindow;
    }

    private ArrayList doRestore() {
        ArrayList arrayList = new ArrayList();
        this.findViews(arrayList);
        this.restoreViews(arrayList);
        return arrayList;
    }

    public void close() {
        if (this.windowParent != null) {
            DockingWindow[] dockingWindowArray = this.getAncestors();
            DockingWindow.optimizeAfter(this.windowParent, new Runnable(){

                public void run() {
                    DockingWindow.this.windowParent.removeChildWindow(DockingWindow.this);
                }
            });
            for (int i = dockingWindowArray.length - 1; i >= 0; --i) {
                dockingWindowArray[i].fireWindowClosed(this);
            }
        }
    }

    public void closeWithAbort() throws OperationAbortedException {
        this.fireWindowClosing(this);
        this.close();
    }

    public FloatingWindow undock(Point point) {
        FloatingWindow floatingWindow = this.getRootWindow().createFloatingWindow(this, point);
        return floatingWindow;
    }

    public FloatingWindow undockWithAbort(Point point) throws OperationAbortedException {
        this.fireWindowUndocking(this);
        return this.undock(point);
    }

    public void dock() {
        if (this.isUndocked()) {
            ArrayList arrayList = this.doRestore();
            this.updateButtonVisibility();
            this.fireWindowDocked(arrayList);
            if (arrayList.size() > 0 && ((DockingWindow)arrayList.get(0)).getRootWindow() != null) {
                FocusManager.focusWindow((DockingWindow)arrayList.get(0));
            }
        }
    }

    public void dockWithAbort() throws OperationAbortedException {
        if (this.isUndocked()) {
            this.fireWindowDocking(this);
            this.dock();
        }
    }

    public int getChildWindowIndex(DockingWindow dockingWindow) {
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            if (this.getChildWindow(i) != dockingWindow) continue;
            return i;
        }
        return -1;
    }

    public WindowPopupMenuFactory getPopupMenuFactory() {
        return this.popupMenuFactory;
    }

    public void setPopupMenuFactory(WindowPopupMenuFactory windowPopupMenuFactory) {
        this.popupMenuFactory = windowPopupMenuFactory;
    }

    public boolean isMinimized() {
        return this.windowParent != null && this.windowParent.isMinimized();
    }

    public DockingWindow getLastFocusedChildWindow() {
        return this.lastFocusedChildWindow;
    }

    public final void maximize() {
        if (this.isUndocked()) {
            FloatingWindow floatingWindow = DockingUtil.getFloatingWindowFor(this);
            if (floatingWindow != null) {
                floatingWindow.setMaximizedWindow(this);
            }
        } else {
            RootWindow rootWindow = this.getRootWindow();
            if (rootWindow != null) {
                rootWindow.setMaximizedWindow(this);
            }
        }
        this.updateButtonVisibility();
    }

    public void maximizeWithAbort() throws OperationAbortedException {
        if (!this.isMaximized()) {
            this.fireWindowMaximizing(this);
            this.maximize();
        }
    }

    public boolean isMaximized() {
        RootWindow rootWindow;
        FloatingWindow floatingWindow;
        DockingWindow dockingWindow = this.isUndocked() ? ((floatingWindow = DockingUtil.getFloatingWindowFor(this)) != null ? floatingWindow.getMaximizedWindow() : null) : ((rootWindow = this.getRootWindow()) != null ? rootWindow.getMaximizedWindow() : null);
        return dockingWindow == this;
    }

    public void minimize() {
        this.getOptimizedWindow().doMinimize();
    }

    public void minimize(Direction direction) {
        this.doMinimize(direction);
    }

    public void minimizeWithAbort() throws OperationAbortedException {
        if (!this.isMinimized() && this.getRootWindow().getClosestWindowBar(this) != null) {
            this.fireWindowMinimizing(this);
            this.minimize();
        }
    }

    public void minimizeWithAbort(Direction direction) throws OperationAbortedException {
        if (!this.isMinimized() && this.getRootWindow().getWindowBar(direction) != null) {
            this.fireWindowMinimizing(this);
            this.minimize(direction);
        }
    }

    private void doMinimize() {
        this.doMinimize(this.windowItem.getLastMinimizedDirection() != null && this.getRootWindow().getWindowBar(this.windowItem.getLastMinimizedDirection()).isEnabled() ? this.windowItem.getLastMinimizedDirection() : this.getRootWindow().getClosestWindowBar(this));
    }

    private void doMinimize(Direction direction) {
        DockingWindow dockingWindow = this.getOptimizedWindow();
        if (direction == null || dockingWindow.isMinimized()) {
            return;
        }
        WindowBar windowBar = this.getRootWindow().getWindowBar(direction);
        if (windowBar != null) {
            windowBar.addTab(dockingWindow);
            this.updateButtonVisibility();
        }
    }

    public boolean isMinimizable() {
        return this.getOptimizedWindow().getWindowProperties().getMinimizeEnabled() && !this.isUndocked() && this.getRootWindow() != null && this.getRootWindow().windowBarEnabled();
    }

    public boolean isMaximizable() {
        return !this.isMinimized() && this.getOptimizedWindow().getWindowProperties().getMaximizeEnabled();
    }

    public boolean isClosable() {
        return this.getOptimizedWindow().getWindowProperties().getCloseEnabled();
    }

    public boolean isRestorable() {
        return this.getOptimizedWindow().getWindowProperties().getRestoreEnabled();
    }

    public boolean isUndockable() {
        return this.getOptimizedWindow().getWindowProperties().getUndockEnabled();
    }

    public boolean isDockable() {
        return this.getOptimizedWindow().getWindowProperties().getDockEnabled();
    }

    public void replaceChildWindow(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        if (dockingWindow == dockingWindow2) {
            return;
        }
        DockingWindow dockingWindow3 = this.internalReplaceChildWindow(dockingWindow, dockingWindow2);
        if (this.getUpdateModel()) {
            dockingWindow.windowItem.replaceWith(dockingWindow3.getWindowItem());
            this.cleanUpModel();
        }
    }

    protected DockingWindow internalReplaceChildWindow(final DockingWindow dockingWindow, final DockingWindow dockingWindow2) {
        final WindowAncestors windowAncestors = dockingWindow2.storeAncestors();
        final DockingWindow dockingWindow3 = dockingWindow2.getContentWindow(this);
        DockingWindow.optimizeAfter(dockingWindow2, new Runnable(){

            public void run() {
                if (dockingWindow3 == dockingWindow) {
                    return;
                }
                if (dockingWindow3.getWindowParent() != null) {
                    dockingWindow3.getWindowParent().removeChildWindow(dockingWindow3);
                }
                dockingWindow3.setWindowParent(DockingWindow.this);
                if (dockingWindow.isShowingInRootWindow()) {
                    dockingWindow.fireWindowHidden(dockingWindow);
                }
                dockingWindow.setWindowParent(null);
                if (dockingWindow == DockingWindow.this.lastFocusedChildWindow) {
                    DockingWindow.this.lastFocusedChildWindow = null;
                }
                DockingWindow.this.doReplace(dockingWindow, dockingWindow3);
                DockingWindow.this.fireTitleChanged();
                dockingWindow.fireWindowRemoved(DockingWindow.this, dockingWindow);
                DockingWindow.this.fireWindowRemoved(DockingWindow.this, dockingWindow);
                dockingWindow3.fireWindowAdded(DockingWindow.this, dockingWindow3);
                if (dockingWindow3.isShowingInRootWindow()) {
                    dockingWindow3.fireWindowShown(dockingWindow3);
                }
                dockingWindow2.notifyListeners(windowAncestors);
            }
        });
        return dockingWindow3;
    }

    public String getTitle() {
        DockingWindowTitleProvider dockingWindowTitleProvider = this.getWindowProperties().getTitleProvider();
        return (dockingWindowTitleProvider == null ? SimpleDockingWindowTitleProvider.INSTANCE : dockingWindowTitleProvider).getTitle(this);
    }

    public String toString() {
        return this.getTitle();
    }

    protected WindowAncestors storeAncestors() {
        return new WindowAncestors(this.getAncestors(), this.isMinimized(), this.isUndocked());
    }

    protected void notifyListeners(WindowAncestors windowAncestors) {
        if (this.isMinimized() && !windowAncestors.isMinimized()) {
            this.fireWindowMinimized(this, windowAncestors.getAncestors());
        }
        if (this.isUndocked() && !windowAncestors.isUndocked()) {
            this.fireWindowUndocked(this, windowAncestors.getAncestors());
        }
        if (!this.isUndocked() && windowAncestors.isUndocked()) {
            this.fireWindowDocked(this, windowAncestors.getAncestors());
        }
    }

    protected boolean isShowingInRootWindow() {
        return this.windowParent != null && this.windowParent.isChildShowingInRootWindow(this);
    }

    protected boolean isChildShowingInRootWindow(DockingWindow dockingWindow) {
        return this.isShowingInRootWindow();
    }

    public void makeVisible() {
        this.showChildWindow(null);
    }

    public void restoreFocus() {
        if (this.lastFocusedChildWindow != null) {
            this.lastFocusedChildWindow.restoreFocus();
        } else {
            DockingWindow dockingWindow = this.getPreferredFocusChild();
            if (dockingWindow != null) {
                dockingWindow.restoreFocus();
            } else {
                ComponentUtil.smartRequestFocus(this);
            }
        }
    }

    protected DockingWindow getPreferredFocusChild() {
        return this.getChildWindowCount() > 0 ? this.getChildWindow(0) : null;
    }

    protected DockingWindow getOptimizedWindow() {
        return this;
    }

    protected DockingWindow getBestFittedWindow(DockingWindow dockingWindow) {
        return this;
    }

    protected void internalClose() {
        DockingWindow.optimizeAfter(this.windowParent, new Runnable(){

            public void run() {
                DockingWindow.this.windowParent.removeChildWindow(DockingWindow.this);
            }
        });
    }

    protected void showChildWindow(DockingWindow dockingWindow) {
        if (this.windowParent != null && !this.isMaximized()) {
            this.windowParent.showChildWindow(this);
        }
    }

    protected boolean insideTab() {
        return this.windowParent == null ? false : this.windowParent.childInsideTab();
    }

    protected boolean childInsideTab() {
        return this.windowParent == null ? false : this.windowParent.childInsideTab();
    }

    protected DockingWindow[] getAncestors() {
        DockingWindow dockingWindow = this;
        int n = 0;
        while (dockingWindow != null) {
            dockingWindow = dockingWindow.getWindowParent();
            ++n;
        }
        DockingWindow[] dockingWindowArray = new DockingWindow[n];
        for (dockingWindow = this; dockingWindow != null; dockingWindow = dockingWindow.getWindowParent()) {
            dockingWindowArray[--n] = dockingWindow;
        }
        return dockingWindowArray;
    }

    private void fireWindowRemoved(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowRemoved(dockingWindow, dockingWindow2);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowRemoved(dockingWindow, dockingWindow2);
        }
    }

    protected void fireWindowShown(DockingWindow dockingWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowShown(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowShown(dockingWindow);
        }
    }

    protected void fireViewFocusChanged(View view, View view2) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].viewFocusChanged(view, view2);
            }
        }
    }

    protected void fireWindowHidden(DockingWindow dockingWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowHidden(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowHidden(dockingWindow);
        }
    }

    private void fireWindowAdded(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowAdded(dockingWindow, dockingWindow2);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowAdded(dockingWindow, dockingWindow2);
        }
    }

    private void fireWindowClosing(DockingWindow dockingWindow) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowClosing(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowClosing(dockingWindow);
        }
    }

    private void fireWindowClosed(DockingWindow dockingWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowClosed(dockingWindow);
            }
        }
    }

    void fireWindowUndocking(DockingWindow dockingWindow) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowUndocking(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowUndocking(dockingWindow);
        }
    }

    void fireWindowUndocked(DockingWindow dockingWindow, DockingWindow[] dockingWindowArray) {
        this.doFireWindowUndocked(dockingWindow);
        for (int i = dockingWindowArray.length - 1; i >= 0; --i) {
            dockingWindowArray[i].doFireWindowUndocked(this);
        }
    }

    private void doFireWindowUndocked(DockingWindow dockingWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowUndocked(dockingWindow);
            }
        }
    }

    void fireWindowMinimizing(DockingWindow dockingWindow) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowMinimizing(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowMinimizing(dockingWindow);
        }
    }

    void fireWindowMaximizing(DockingWindow dockingWindow) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowMaximizing(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowMaximizing(dockingWindow);
        }
    }

    void fireWindowRestoring(DockingWindow dockingWindow) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowRestoring(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowRestoring(dockingWindow);
        }
    }

    void fireWindowDocking(DockingWindow dockingWindow) throws OperationAbortedException {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowDocking(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowDocking(dockingWindow);
        }
    }

    void fireWindowDocked(DockingWindow dockingWindow, DockingWindow[] dockingWindowArray) {
        this.doFireWindowDocked(dockingWindow);
        for (int i = dockingWindowArray.length - 1; i >= 0; --i) {
            dockingWindowArray[i].doFireWindowDocked(this);
        }
    }

    void fireWindowDocked(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            DockingWindow dockingWindow = (DockingWindow)arrayList.get(i);
            dockingWindow.doFireWindowDocked(dockingWindow);
            DockingWindow[] dockingWindowArray = dockingWindow.getAncestors();
            for (int j = 0; j < dockingWindowArray.length; ++j) {
                dockingWindowArray[j].doFireWindowDocked(dockingWindow);
            }
        }
    }

    private void doFireWindowDocked(DockingWindow dockingWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowDocked(dockingWindow);
            }
        }
    }

    private void doFireWindowRestored(DockingWindow dockingWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowRestored(dockingWindow);
            }
        }
    }

    void fireWindowMaximized(DockingWindow dockingWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowMaximized(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowMaximized(dockingWindow);
        }
    }

    void fireWindowMinimized(DockingWindow dockingWindow, DockingWindow[] dockingWindowArray) {
        this.doFireWindowMinimized(dockingWindow);
        for (int i = dockingWindowArray.length - 1; i >= 0; --i) {
            dockingWindowArray[i].doFireWindowMinimized(dockingWindow);
        }
    }

    private void doFireWindowMinimized(DockingWindow dockingWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowMinimized(dockingWindow);
            }
        }
    }

    void fireWindowRestored(DockingWindow dockingWindow) {
        if (this.getListeners() != null) {
            DockingWindowListener[] dockingWindowListenerArray = this.getListeners().toArray(new DockingWindowListener[this.getListeners().size()]);
            for (int i = 0; i < dockingWindowListenerArray.length; ++i) {
                dockingWindowListenerArray[i].windowRestored(dockingWindow);
            }
        }
        if (this.windowParent != null) {
            this.windowParent.fireWindowRestored(dockingWindow);
        }
    }

    protected void setLastMinimizedDirection(Direction direction) {
        this.windowItem.setLastMinimizedDirection(direction);
    }

    protected void clearChildrenFocus(DockingWindow dockingWindow, View view) {
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            if (dockingWindow == this.getChildWindow(i)) continue;
            this.getChildWindow(i).clearFocus(view);
        }
    }

    void childGainedFocus(DockingWindow dockingWindow, View view) {
        if (dockingWindow != null) {
            this.lastFocusedChildWindow = dockingWindow;
        }
        this.clearChildrenFocus(dockingWindow, view);
        if (this.windowParent != null) {
            this.windowParent.childGainedFocus(this, view);
        }
    }

    WindowTab getTab() {
        if (this.tab == null) {
            this.tab = new WindowTab(this, false);
        }
        return this.tab;
    }

    protected void childRemoved(DockingWindow dockingWindow) {
        if (this.lastFocusedChildWindow == dockingWindow) {
            this.lastFocusedChildWindow = null;
        }
    }

    protected void updateButtonVisibility() {
        if (this.tab != null) {
            this.tab.updateTabButtons(null);
        }
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            this.getChildWindow(i).updateButtonVisibility();
        }
    }

    protected final void readLocations(ObjectInputStream objectInputStream, RootWindow rootWindow, int n) throws IOException {
        int n2;
        if (n < 3) {
            LocationDecoder.decode(objectInputStream, rootWindow);
        }
        if (n > 1) {
            n2 = objectInputStream.readInt();
            this.lastFocusedChildWindow = n2 == -1 ? null : this.getChildWindow(n2);
        }
        for (n2 = 0; n2 < this.getChildWindowCount(); ++n2) {
            this.getChildWindow(n2).readLocations(objectInputStream, rootWindow, n);
        }
    }

    protected void writeLocations(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.lastFocusedChildWindow == null ? -1 : this.getChildWindowIndex(this.lastFocusedChildWindow));
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            this.getChildWindow(i).writeLocations(objectOutputStream);
        }
    }

    protected static void beginOptimize(DockingWindow dockingWindow) {
        ++optimizeDepth;
        if (dockingWindow != null) {
            optimizeWindows.add(dockingWindow);
        }
        PropertyMapManager.getInstance().beginBatch();
    }

    protected static void endOptimize() {
        PropertyMapManager.getInstance().endBatch();
        if (--optimizeDepth == 0) {
            while (optimizeWindows.size() > 0) {
                HashSet hashSet = optimizeWindows;
                optimizeWindows = new HashSet();
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    DockingWindow dockingWindow = (DockingWindow)iterator.next();
                    dockingWindow.optimizeWindowLayout();
                }
            }
        }
    }

    protected static void optimizeAfter(final DockingWindow dockingWindow, final Runnable runnable) {
        FocusManager.getInstance().pinFocus(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DockingWindow.beginOptimize(dockingWindow);
                try {
                    runnable.run();
                }
                finally {
                    DockingWindow.endOptimize();
                }
            }
        });
    }

    protected boolean needsTitleWindow() {
        return false;
    }

    protected boolean showsWindowTitle() {
        return false;
    }

    protected void optimizeWindowLayout() {
    }

    protected DockingWindow getLocationWindow() {
        return this;
    }

    protected void fireTitleChanged() {
        if (this.tab != null) {
            this.tab.windowTitleChanged();
        }
        if (this.windowParent != null) {
            this.windowParent.fireTitleChanged();
        }
    }

    protected DockingWindow getContentWindow(DockingWindow dockingWindow) {
        return this.needsTitleWindow() && !dockingWindow.showsWindowTitle() ? new TabWindow(this) : this;
    }

    protected final void removeChildWindow(final DockingWindow dockingWindow) {
        DockingWindow.optimizeAfter(dockingWindow.getWindowParent(), new Runnable(){

            public void run() {
                if (dockingWindow.isShowingInRootWindow()) {
                    dockingWindow.fireWindowHidden(dockingWindow);
                }
                dockingWindow.setWindowParent(null);
                if (DockingWindow.this.lastFocusedChildWindow == dockingWindow) {
                    DockingWindow.this.lastFocusedChildWindow = null;
                }
                DockingWindow.this.doRemoveWindow(dockingWindow);
                DockingWindow.this.fireTitleChanged();
                dockingWindow.fireWindowRemoved(DockingWindow.this, dockingWindow);
                DockingWindow.this.fireWindowRemoved(DockingWindow.this, dockingWindow);
                DockingWindow.this.afterWindowRemoved(dockingWindow);
            }
        });
    }

    protected final void removeWindow(DockingWindow dockingWindow) {
        dockingWindow.setWindowParent(null);
        if (this.getUpdateModel()) {
            this.windowItem.removeWindow(this.windowItem.getChildWindowContaining(dockingWindow.getWindowItem()));
            this.cleanUpModel();
        }
    }

    protected final void detach() {
        DockingWindow dockingWindow = this.getWindowParent();
        if (dockingWindow != null) {
            dockingWindow.removeChildWindow(this);
        }
    }

    protected final DockingWindow addWindow(DockingWindow dockingWindow) {
        if (dockingWindow == null) {
            return null;
        }
        DockingWindow dockingWindow2 = dockingWindow.getContentWindow(this);
        dockingWindow2.detach();
        dockingWindow2.setWindowParent(this);
        this.fireTitleChanged();
        dockingWindow2.fireWindowAdded(this, dockingWindow2);
        if (dockingWindow2.isShowingInRootWindow()) {
            this.fireWindowShown(dockingWindow2);
        }
        return dockingWindow2;
    }

    protected void rootChanged(RootWindow rootWindow, RootWindow rootWindow2) {
        if (rootWindow2 != null) {
            this.lastRootWindow = new WeakReference<RootWindow>(rootWindow2);
        }
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            if (this.getChildWindow(i) == null) continue;
            this.getChildWindow(i).rootChanged(rootWindow, rootWindow2);
        }
        this.updateWindowItem(rootWindow2);
    }

    protected void clearFocus(View view) {
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            this.getChildWindow(i).clearFocus(view);
        }
    }

    private void setWindowParent(DockingWindow dockingWindow) {
        if (dockingWindow == this.windowParent) {
            return;
        }
        RootWindow rootWindow = this.getRootWindow();
        if (this.windowParent != null) {
            if (this.isMaximized()) {
                if (this.isUndocked()) {
                    DockingUtil.getFloatingWindowFor(this).setMaximizedWindow(null);
                } else {
                    this.getRootWindow().setMaximizedWindow(null);
                }
            }
            this.windowParent.childRemoved(this);
            this.clearFocus(null);
            if (this.tab != null) {
                this.tab.setContentComponent(this);
            }
        }
        this.windowParent = dockingWindow;
        RootWindow rootWindow2 = this.getRootWindow();
        if (rootWindow != rootWindow2) {
            this.rootChanged(rootWindow, rootWindow2);
        }
    }

    private Direction getSplitDirection(Point point) {
        double[] dArray = new double[]{point.getX() / (double)this.getWidth(), ((double)this.getWidth() - point.getX()) / (double)this.getWidth(), point.getY() / (double)this.getHeight(), ((double)this.getHeight() - point.getY()) / (double)this.getHeight()};
        int n = ArrayUtil.findSmallest(dArray);
        return n == 0 ? Direction.LEFT : (n == 1 ? Direction.RIGHT : (n == 2 ? Direction.UP : Direction.DOWN));
    }

    private int getEdgeDistance(Point point, Direction direction) {
        return direction == Direction.RIGHT ? this.getWidth() - point.x : (direction == Direction.DOWN ? this.getHeight() - point.y : (direction == Direction.LEFT ? point.x : point.y));
    }

    DropAction acceptDrop(Point point, DockingWindow dockingWindow) {
        DropAction dropAction = null;
        FloatingWindow floatingWindow = DockingUtil.getFloatingWindowFor(dockingWindow);
        FloatingWindow floatingWindow2 = DockingUtil.getFloatingWindowFor(this);
        if (this.getRootWindow() != dockingWindow.getRootWindow() || (dockingWindow.getWindowProperties().getDockEnabled() || floatingWindow == null || floatingWindow2 != null) && (dockingWindow.getWindowProperties().getUndockEnabled() || floatingWindow == floatingWindow2)) {
            dropAction = !this.isShowing() || !this.contains(point) || this.hasParent(dockingWindow) || !this.getRootWindow().getRootWindowProperties().getRecursiveTabsEnabled() && this.insideTab() ? null : this.doAcceptDrop(point, dockingWindow);
        }
        return dropAction;
    }

    DropAction getDefaultDropAction() {
        return new DropAction(){

            public void execute(DockingWindow dockingWindow, MouseEvent mouseEvent) {
                if (DockingWindow.this.getWindowProperties().getUndockEnabled() && DockingWindow.this.getWindowProperties().getUndockOnDropEnabled()) {
                    FloatingWindow floatingWindow;
                    Point point = mouseEvent.getPoint();
                    Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, DockingWindow.this.getRootWindow());
                    Point point3 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, DockingWindow.this.getRootWindow().getRootPane());
                    if (!DockingWindow.this.getRootWindow().contains(point2) && !DockingWindow.this.getRootWindow().floatingWindowsContainPoint(point3) && ((floatingWindow = DockingUtil.getFloatingWindowFor(dockingWindow)) == null || floatingWindow.getChildWindowCount() > 0 && floatingWindow.getChildWindow(0).getChildWindowCount() > 1)) {
                        SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
                        point.x -= dockingWindow.getWidth() / 2;
                        point.y -= Math.min(DROP_FLOATING_YOFFSET, dockingWindow.getHeight() / 2);
                        try {
                            dockingWindow.undockWithAbort(point);
                        }
                        catch (OperationAbortedException operationAbortedException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
    }

    protected boolean acceptsSplitWith(DockingWindow dockingWindow) {
        return dockingWindow != this;
    }

    protected DropAction doAcceptDrop(Point point, DockingWindow dockingWindow) {
        DropAction dropAction = this.acceptSplitDrop(point, dockingWindow, this.getRootWindow().getRootWindowProperties().getEdgeSplitDistance());
        if (dropAction != null) {
            return dropAction;
        }
        dropAction = this.acceptChildDrop(point, dockingWindow);
        if (dropAction != null) {
            return dropAction;
        }
        dropAction = this.acceptInteriorDrop(point, dockingWindow);
        if (dropAction != null) {
            return dropAction;
        }
        return this.acceptSplitDrop(point, dockingWindow, -1);
    }

    protected DropAction acceptSplitDrop(Point point, DockingWindow dockingWindow, int n) {
        if (!this.acceptsSplitWith(dockingWindow)) {
            return null;
        }
        Direction direction = this.getSplitDirection(point);
        int n2 = this.getEdgeDistance(point, direction);
        if (n != -1 && n2 > n * this.getEdgeDepth(direction)) {
            return null;
        }
        if (this.getSplitDropFilter().acceptDrop(new SplitDropInfo(dockingWindow, this, point, direction))) {
            return this.split(dockingWindow, direction);
        }
        return null;
    }

    protected DropAction split(DockingWindow dockingWindow, final Direction direction) {
        int n = direction == Direction.LEFT || direction == Direction.RIGHT ? this.getWidth() / 3 : this.getWidth();
        int n2 = direction == Direction.DOWN || direction == Direction.UP ? this.getHeight() / 3 : this.getHeight();
        int n3 = direction == Direction.RIGHT ? this.getWidth() - n : 0;
        int n4 = direction == Direction.DOWN ? this.getHeight() - n2 : 0;
        Rectangle rectangle = new Rectangle(n3, n4, n, n2);
        this.getRootWindow().setDragRectangle(SwingUtilities.convertRectangle(this, rectangle, this.getRootWindow()));
        return new DropAction(){

            public void execute(DockingWindow dockingWindow, MouseEvent mouseEvent) {
                try {
                    dockingWindow.beforeDrop(DockingWindow.this);
                    DockingWindow.this.split(dockingWindow, direction, direction == Direction.UP || direction == Direction.LEFT ? 0.33f : 0.66f);
                    dockingWindow.restoreFocus();
                }
                catch (OperationAbortedException operationAbortedException) {
                    // empty catch block
                }
            }
        };
    }

    protected void beforeDrop(DockingWindow dockingWindow) throws OperationAbortedException {
        if (!this.isMinimized() && dockingWindow.isMinimized()) {
            this.fireWindowMinimizing(this);
        }
        if (!this.isUndocked() && dockingWindow.isUndocked()) {
            this.fireWindowUndocking(this);
        }
    }

    protected DropAction createTabWindow(DockingWindow dockingWindow) {
        this.getRootWindow().setDragRectangle(SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), this.getRootWindow()));
        return new DropAction(){

            public void execute(DockingWindow dockingWindow, MouseEvent mouseEvent) {
                DockingWindow.optimizeAfter(dockingWindow.getWindowParent(), new Runnable(this, dockingWindow){
                    private final /* synthetic */ DockingWindow val$window;
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$window = dockingWindow;
                    }

                    public void run() {
                        try {
                            this.val$window.beforeDrop(12.access$700(this.this$1));
                            TabWindow tabWindow = new TabWindow();
                            DockingWindow.access$100(12.access$700(this.this$1)).replaceChildWindow(12.access$700(this.this$1), tabWindow);
                            tabWindow.addTab(12.access$700(this.this$1));
                            tabWindow.addTab(this.val$window);
                        }
                        catch (OperationAbortedException operationAbortedException) {
                            // empty catch block
                        }
                    }
                });
            }

            static /* synthetic */ DockingWindow access$700(12 var0) {
                return var0.DockingWindow.this;
            }
        };
    }

    protected DropAction acceptInteriorDrop(Point point, DockingWindow dockingWindow) {
        return null;
    }

    protected boolean hasParent(DockingWindow dockingWindow) {
        return dockingWindow == this || this.getWindowParent() != null && this.getWindowParent().hasParent(dockingWindow);
    }

    protected DockingWindow oldRead(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        this.windowItem.readSettings(objectInputStream, readContext);
        return this;
    }

    protected abstract PropertyMap getPropertyObject();

    protected abstract PropertyMap createPropertyObject();

    void showPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        DockingWindow dockingWindow = this;
        while (dockingWindow.getPopupMenuFactory() == null) {
            if ((dockingWindow = dockingWindow.getWindowParent()) != null) continue;
            return;
        }
        JPopupMenu jPopupMenu = dockingWindow.getPopupMenuFactory().createPopupMenu(this);
        if (jPopupMenu != null && jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected void setFocused(boolean bl) {
        if (this.tab != null) {
            this.tab.setFocused(bl);
        }
    }

    protected int getEdgeDepth(Direction direction) {
        return 1 + (this.windowParent == null ? 0 : this.windowParent.getChildEdgeDepth(this, direction));
    }

    protected int getChildEdgeDepth(DockingWindow dockingWindow, Direction direction) {
        return this.windowParent == null ? 0 : this.windowParent.getChildEdgeDepth(this, direction);
    }

    protected DropAction acceptChildDrop(Point point, DockingWindow dockingWindow) {
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            DropAction dropAction;
            DockingWindow dockingWindow2 = this.getChildWindow(i);
            Point point2 = SwingUtilities.convertPoint(this, point, dockingWindow2);
            if (!this.getChildDropFilter().acceptDrop(new ChildDropInfo(dockingWindow, this, point, dockingWindow2)) || (dropAction = dockingWindow2.acceptDrop(point2, dockingWindow)) == null) continue;
            return dropAction;
        }
        return null;
    }

    protected WindowItem getWindowItem() {
        return this.windowItem;
    }

    protected boolean getUpdateModel() {
        return updateModelDepth == 0 && this.windowItem.isRestoreWindow();
    }

    private void findViews(ArrayList arrayList) {
        if (this instanceof View) {
            arrayList.add(this);
        }
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            this.getChildWindow(i).findViews(arrayList);
        }
    }

    private void restoreViews(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            ((DockingWindow)arrayList.get(i)).restoreItem();
        }
    }

    protected static void beginUpdateModel() {
        ++updateModelDepth;
    }

    protected static void endUpdateModel() {
        --updateModelDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreItem() {
        DockingWindow.beginUpdateModel();
        try {
            Object object;
            Object object2;
            if (this.windowItem != null) {
                object2 = this.windowItem;
                while (((WindowItem)object2).getParent() != null) {
                    Object object3;
                    DockingWindow dockingWindow;
                    object = ((WindowItem)object2).getParent().getConnectedWindow();
                    if (object != null && ((DockingWindow)object).getRootWindow() != null && !((DockingWindow)object).isMinimized() && !((DockingWindow)object).isUndocked()) {
                        if (object instanceof TabWindow) {
                            DockingWindow.insertTab((TabWindow)object, this);
                        } else if (object instanceof RootWindow) {
                            dockingWindow = this.getContainer(((WindowItem)object2).getParent(), this.windowItem);
                            ((RootWindow)object).setWindow(dockingWindow);
                        }
                        return;
                    }
                    dockingWindow = null;
                    for (int i = 0; i < ((WindowItem)object2).getParent().getWindowCount() && ((object3 = ((WindowItem)object2).getParent().getWindow(i)) == object2 || (dockingWindow = ((WindowItem)object3).getVisibleDockingWindow()) == null); ++i) {
                    }
                    if (dockingWindow != null) {
                        DockingWindow dockingWindow2 = dockingWindow;
                        object3 = object2;
                        DockingWindow.optimizeAfter(dockingWindow.getWindowParent(), new Runnable((WindowItem)object3, dockingWindow2){
                            private final /* synthetic */ WindowItem val$fitem;
                            private final /* synthetic */ DockingWindow val$w1;
                            {
                                this.val$fitem = windowItem;
                                this.val$w1 = dockingWindow2;
                            }

                            public void run() {
                                if (this.val$fitem.getParent() instanceof SplitWindowItem) {
                                    SplitWindowItem splitWindowItem = (SplitWindowItem)this.val$fitem.getParent();
                                    boolean bl = splitWindowItem.getWindow(0) == this.val$fitem;
                                    SplitWindow splitWindow = new SplitWindow(splitWindowItem.isHorizontal(), splitWindowItem.getDividerLocation(), null, null, splitWindowItem);
                                    this.val$w1.getWindowParent().internalReplaceChildWindow(this.val$w1, splitWindow);
                                    DockingWindow dockingWindow = DockingWindow.this.getContainer(splitWindowItem, DockingWindow.this.windowItem);
                                    DockingWindow dockingWindow2 = this.val$w1.getContainer(splitWindowItem, this.val$w1.windowItem);
                                    splitWindow.setWindows(bl ? dockingWindow : dockingWindow2, bl ? dockingWindow2 : dockingWindow);
                                } else if (this.val$fitem.getParent() instanceof TabWindowItem) {
                                    TabWindowItem tabWindowItem = (TabWindowItem)this.val$fitem.getParent();
                                    TabWindow tabWindow = new TabWindow(null, tabWindowItem);
                                    this.val$w1.getWindowParent().internalReplaceChildWindow(this.val$w1, tabWindow);
                                    DockingWindow.insertTab(tabWindow, DockingWindow.this);
                                    DockingWindow.insertTab(tabWindow, this.val$w1.getOptimizedWindow());
                                }
                            }
                        });
                        return;
                    }
                    object2 = ((WindowItem)object2).getParent();
                }
            }
            if ((object2 = (RootWindow)this.lastRootWindow.get()) != null) {
                object = this.getWindowItem().getTopItem();
                DockingWindow.optimizeAfter(null, new Runnable((RootWindow)object2, (WindowItem)object){
                    private final /* synthetic */ RootWindow val$rootWindow;
                    private final /* synthetic */ WindowItem val$topItem;
                    {
                        this.val$rootWindow = rootWindow;
                        this.val$topItem = windowItem;
                    }

                    public void run() {
                        DockingWindow dockingWindow = this.val$rootWindow.getWindow();
                        if (dockingWindow == null) {
                            WindowItem windowItem = this.val$rootWindow.getWindowItem();
                            if (windowItem.getWindowCount() == 0) {
                                windowItem.addWindow(this.val$topItem);
                            } else {
                                SplitWindowItem splitWindowItem = new SplitWindowItem();
                                splitWindowItem.addWindow(windowItem.getWindow(0));
                                splitWindowItem.addWindow(this.val$topItem);
                                windowItem.addWindow(splitWindowItem);
                            }
                            this.val$rootWindow.setWindow(DockingWindow.this.getContainer(this.val$topItem, DockingWindow.this.getWindowItem()));
                        } else {
                            SplitWindow splitWindow = new SplitWindow(true);
                            splitWindow.getWindowItem().addWindow(this.val$rootWindow.getWindowItem().getWindow(0));
                            splitWindow.getWindowItem().addWindow(this.val$topItem);
                            this.val$rootWindow.setWindow(splitWindow);
                            splitWindow.setWindows(dockingWindow, DockingWindow.this.getContainer(this.val$topItem, DockingWindow.this.getWindowItem()));
                            this.val$rootWindow.getWindowItem().addWindow(splitWindow.getWindowItem());
                        }
                    }
                });
            }
        }
        finally {
            DockingWindow.endUpdateModel();
        }
    }

    private static void insertTab(TabWindow tabWindow, DockingWindow dockingWindow) {
        WindowItem windowItem;
        int n = 0;
        WindowItem windowItem2 = tabWindow.getWindowItem();
        WindowItem windowItem3 = windowItem2.getChildWindowContaining(dockingWindow.getWindowItem());
        for (int i = 0; i < windowItem2.getWindowCount() && (windowItem = windowItem2.getWindow(i)) != windowItem3; ++i) {
            DockingWindow dockingWindow2 = windowItem.getVisibleDockingWindow();
            if (dockingWindow2 == null) continue;
            ++n;
        }
        tabWindow.addTabNoSelect(dockingWindow, n);
        tabWindow.updateSelectedTab();
    }

    private DockingWindow getContainer(WindowItem windowItem, WindowItem windowItem2) {
        if (!this.needsTitleWindow()) {
            return this;
        }
        while (windowItem2 != windowItem) {
            if (windowItem2 instanceof TabWindowItem) {
                TabWindow tabWindow = new TabWindow(null, (TabWindowItem)windowItem2);
                tabWindow.addTabNoSelect(this, 0);
                return tabWindow;
            }
            windowItem2 = windowItem2.getParent();
        }
        TabWindow tabWindow = new TabWindow();
        tabWindow.addTabNoSelect(this, 0);
        windowItem2.replaceWith(tabWindow.getWindowItem());
        tabWindow.getWindowItem().addWindow(windowItem2);
        return tabWindow;
    }

    private void setWindowItem(WindowItem windowItem) {
        this.windowItem = windowItem;
        windowItem.setConnectedWindow(this);
        this.updateWindowItem(this.getRootWindow());
    }

    protected void updateWindowItem(RootWindow rootWindow) {
        this.windowItem.setParentDockingWindowProperties(rootWindow == null ? WindowItem.emptyProperties : rootWindow.getRootWindowProperties().getDockingWindowProperties());
    }

    protected void afterWindowRemoved(DockingWindow dockingWindow) {
    }

    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
    }

    protected void cleanUpModel() {
        if (this.windowParent != null) {
            this.windowParent.cleanUpModel();
        }
    }

    DropFilter getSplitDropFilter() {
        return this.getWindowProperties().getDropFilterProperties().getSplitDropFilter();
    }

    DropFilter getChildDropFilter() {
        return this.getWindowProperties().getDropFilterProperties().getChildDropFilter();
    }

    DropFilter getInteriorDropFilter() {
        return this.getWindowProperties().getDropFilterProperties().getInteriorDropFilter();
    }

    DropFilter getInsertTabDropFilter() {
        return this.getWindowProperties().getDropFilterProperties().getInsertTabDropFilter();
    }
}

